/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.juxt.xtdb.txnfn;

import clojure.lang.IPersistentMap;
import clojure.lang.Keyword;
import clojure.lang.PersistentHashMap;
import org.odpi.egeria.connectors.juxt.xtdb.auditlog.XtdbOMRSErrorCode;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.EntityDetailMapping;
import org.odpi.egeria.connectors.juxt.xtdb.repositoryconnector.XtdbOMRSRepositoryConnector;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.PurgeClassificationReferenceCopy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xtdb.api.TransactionInstant;
import xtdb.api.XtdbDocument;
import xtdb.api.tx.Transaction;

public class PurgeClassificationReferenceCopyEntityDetail
extends PurgeClassificationReferenceCopy {
    private static final Logger log = LoggerFactory.getLogger(PurgeClassificationReferenceCopyEntityDetail.class);
    public static final Keyword FUNCTION_NAME = Keyword.intern((String)"egeria", (String)"purgeClassificationReferenceCopyEntityDetail");
    private static final String CLASS_NAME = PurgeClassificationReferenceCopyEntityDetail.class.getName();
    private static final String METHOD_NAME = FUNCTION_NAME.toString();

    public PurgeClassificationReferenceCopyEntityDetail(Long txId, PersistentHashMap existing, PersistentHashMap entity, String entityGUID, Classification classification, String homeMetadataCollectionId) throws Exception {
        super(CLASS_NAME, METHOD_NAME, txId, existing, entity, entityGUID, classification, homeMetadataCollectionId);
    }

    public static void transact(XtdbOMRSRepositoryConnector xtdb, EntityDetail toPurgeFrom, Classification classification) throws EntityConflictException, RepositoryErrorException {
        String docId = EntityDetailMapping.getReference(toPurgeFrom.getGUID());
        EntityDetailMapping edm = new EntityDetailMapping(xtdb, toPurgeFrom);
        XtdbDocument toPurgeFromXT = edm.toXTDB();
        Transaction.Builder tx = Transaction.builder();
        tx.invokeFunction((Object)FUNCTION_NAME, new Object[]{docId, toPurgeFromXT.toMap(), classification, xtdb.getMetadataCollectionId()});
        TransactionInstant results = xtdb.runTx(tx.build());
        try {
            xtdb.validateCommit(results, METHOD_NAME);
        }
        catch (EntityConflictException | RepositoryErrorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RepositoryErrorException(XtdbOMRSErrorCode.UNKNOWN_RUNTIME_ERROR.getMessageDefinition(), CLASS_NAME, METHOD_NAME, (Throwable)e);
        }
    }

    public IPersistentMap doc() {
        log.debug("Entity being persisted: {}", (Object)this.xtdbDoc);
        return this.xtdbDoc;
    }

    public static void create(Transaction.Builder tx) {
        PurgeClassificationReferenceCopyEntityDetail.createTransactionFunction(tx, FUNCTION_NAME, PurgeClassificationReferenceCopyEntityDetail.getTxFn(CLASS_NAME));
    }
}

