/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.utilities.serverops;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.odpi.openmetadata.adminservices.client.ConfigurationManagementClient;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.ServerTypeClassification;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.client.IntegrationDaemon;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.properties.IntegrationConnectorReport;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.properties.IntegrationServiceSummary;
import org.odpi.openmetadata.http.HttpHelper;
import org.odpi.openmetadata.platformservices.client.PlatformServicesClient;
import org.odpi.openmetadata.serveroperations.properties.ServerServicesStatus;

public class ServerOps {
    private final String platformURLRoot;
    private final String clientUserId;

    private ServerOps(String platformURLRoot, String clientUserId) {
        this.platformURLRoot = platformURLRoot;
        this.clientUserId = clientUserId;
    }

    private String getPlatformOrigin() {
        try {
            PlatformServicesClient platformServicesClient = new PlatformServicesClient("MyPlatform", this.platformURLRoot);
            return platformServicesClient.getPlatformOrigin(this.clientUserId);
        }
        catch (Exception error) {
            System.out.println("\n\nThere was an " + error.getClass().getName() + " exception when calling the platform.  Error message is: " + error.getMessage());
            System.out.println("Ensure the platform URl is correct and the platform is running");
            return null;
        }
    }

    private void startServer(String serverName) {
        try {
            PlatformServicesClient client = new PlatformServicesClient(serverName, this.platformURLRoot);
            System.out.println("Starting " + serverName + " ...");
            System.out.println(client.activateWithStoredConfig(this.clientUserId, serverName));
        }
        catch (Exception error) {
            System.out.println("There was an " + error.getClass().getName() + " exception when calling the platform.  Error message is: " + error.getMessage());
        }
    }

    private void startServers(List<String> serverNames) {
        if (serverNames != null) {
            for (String serverName : serverNames) {
                if (serverName == null) continue;
                this.startServer(serverName);
            }
        }
    }

    private void stopServer(String serverName) {
        try {
            PlatformServicesClient client = new PlatformServicesClient(serverName, this.platformURLRoot);
            System.out.println("Stopping " + serverName + " ...");
            client.shutdownServer(this.clientUserId, serverName);
            System.out.println(serverName + " stopped.");
        }
        catch (Exception error) {
            System.out.println("There was an " + error.getClass().getName() + " exception when calling the platform.  Error message is: " + error.getMessage());
        }
    }

    private void stopServers(List<String> serverNames) {
        if (serverNames != null) {
            for (String serverName : serverNames) {
                if (serverName == null) continue;
                this.stopServer(serverName);
            }
        }
    }

    private void queryIntegrationDaemon(String serverName) {
        try {
            IntegrationDaemon client = new IntegrationDaemon(this.clientUserId, this.platformURLRoot);
            List serviceSummaries = client.getIntegrationServicesSummaries(this.clientUserId);
            if (serviceSummaries != null) {
                System.out.println("  integration services: ");
                for (IntegrationServiceSummary serviceSummary : serviceSummaries) {
                    System.out.println("    integration service: " + serviceSummary.getIntegrationServiceFullName());
                    if (serviceSummary.getIntegrationConnectorReports() == null) continue;
                    System.out.println("      connectors: " + serviceSummary.getIntegrationServiceFullName());
                    for (IntegrationConnectorReport connectorReport : serviceSummary.getIntegrationConnectorReports()) {
                        System.out.println("        connector: " + connectorReport.getConnectorName() + "(" + connectorReport.getConnectorInstanceId() + ")");
                        System.out.println("          status: " + String.valueOf(connectorReport.getConnectorStatus()));
                        System.out.println("          lastRefreshTime: " + String.valueOf(connectorReport.getLastRefreshTime()));
                        System.out.println("          lastStatusChange: " + String.valueOf(connectorReport.getLastStatusChange()));
                        if (connectorReport.getStatistics() == null) continue;
                        System.out.println("          statistics: ");
                        for (String statisticName : connectorReport.getStatistics().keySet()) {
                            System.out.println("            " + statisticName + ": " + String.valueOf(connectorReport.getStatistics().get(statisticName)));
                        }
                    }
                }
            } else {
                System.out.println(serverName + "  not running.");
            }
        }
        catch (Exception error) {
            System.out.println("There was an " + error.getClass().getName() + " exception when calling the platform.  Error message is: " + error.getMessage());
        }
    }

    private void queryServer(String serverName) {
        try {
            PlatformServicesClient client = new PlatformServicesClient(serverName, this.platformURLRoot);
            System.out.println("Status of " + serverName + " ...");
            ServerServicesStatus serverStatus = client.getActiveServerStatus(this.clientUserId, serverName);
            if (serverStatus != null) {
                System.out.println("  serverType: " + serverStatus.getServerType());
                System.out.println("  status: " + String.valueOf(serverStatus.getServerActiveStatus()));
                if (ServerTypeClassification.INTEGRATION_DAEMON.getServerTypeName().equals(serverStatus.getServerType())) {
                    this.queryIntegrationDaemon(serverName);
                }
            } else {
                System.out.println(serverName + "  not running.");
            }
        }
        catch (Exception error) {
            System.out.println("There was an " + error.getClass().getName() + " exception when calling the platform.  Error message is: " + error.getMessage());
        }
    }

    private void queryServers(List<String> serverNames) {
        if (serverNames != null) {
            for (String serverName : serverNames) {
                if (serverName == null) continue;
                this.queryServer(serverName);
            }
        }
    }

    private void runCommand(String mode, String[] serverArray) {
        List<String> serverList = null;
        if (serverArray != null) {
            serverList = Arrays.asList(serverArray);
        }
        if ("start".equals(mode)) {
            this.startServers(serverList);
        } else if ("stop".equals(mode)) {
            this.stopServers(serverList);
        } else if ("query".equals(mode)) {
            this.queryServers(serverList);
        }
    }

    public static void main(String[] args) {
        String interactiveMode = "interactive";
        String endInteractiveMode = "exit";
        String platformURLRoot = "https://localhost:9443";
        String clientUserId = "garygeeke";
        String mode = "interactive";
        if (args.length > 0) {
            platformURLRoot = args[0];
        }
        if (args.length > 1) {
            clientUserId = args[1];
        }
        if (args.length > 2) {
            mode = args[2];
        }
        System.out.println("===============================");
        System.out.println("OMAG Server Operations Utility:    " + String.valueOf(new Date()));
        System.out.println("===============================");
        System.out.print("Running against platform: " + platformURLRoot);
        ServerOps utility = new ServerOps(platformURLRoot, clientUserId);
        HttpHelper.noStrictSSL();
        String platformOrigin = utility.getPlatformOrigin();
        if (platformOrigin != null) {
            System.out.print(" - " + platformOrigin);
        } else {
            System.out.println();
            System.exit(-1);
        }
        System.out.println("Using userId: " + clientUserId);
        System.out.println();
        try {
            ConfigurationManagementClient configurationManagementClient = new ConfigurationManagementClient(clientUserId, platformURLRoot);
            if ("interactive".equals(mode)) {
                while (!"exit".equals(mode)) {
                    Set configuredServers = configurationManagementClient.getAllServerConfigurations();
                    ArrayList<String> configuredServerNames = new ArrayList<String>();
                    if (configuredServers != null) {
                        for (OMAGServerConfig serverConfig : configuredServers) {
                            if (serverConfig == null) continue;
                            configuredServerNames.add(serverConfig.getLocalServerName());
                        }
                    }
                    BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
                    System.out.println("Available servers: " + String.valueOf(configuredServerNames));
                    System.out.println("Enter a command {start, query, stop, exit} along with one or more space separate server names. Press enter to execute request.");
                    String command = br.readLine();
                    String[] commandWords = command.split(" ");
                    if (commandWords.length > 0) {
                        mode = commandWords[0];
                        if (commandWords.length > 1) {
                            utility.runCommand(mode, Arrays.copyOfRange(commandWords, 1, commandWords.length));
                        }
                    }
                    System.out.println();
                }
            } else {
                utility.runCommand(mode, Arrays.copyOfRange(args, 3, args.length));
            }
        }
        catch (Exception error) {
            System.out.println("Exception: " + error.getClass().getName() + " with message " + error.getMessage());
            System.exit(-1);
        }
        System.exit(0);
    }
}

