/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.reports.platform;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.odpi.openmetadata.adminservices.client.ConfigurationManagementClient;
import org.odpi.openmetadata.adminservices.client.OMAGServerConfigurationClient;
import org.odpi.openmetadata.adminservices.client.OMAGServerPlatformConfigurationClient;
import org.odpi.openmetadata.adminservices.configuration.properties.CohortConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.EngineConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.EngineServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.IntegrationConnectorConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.IntegrationServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.ViewServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.adminservices.configuration.registration.GovernanceServicesDescription;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.http.HttpHelper;
import org.odpi.openmetadata.platformservices.client.PlatformServicesClient;
import org.odpi.openmetadata.reports.EgeriaReport;
import org.odpi.openmetadata.repositoryservices.clients.MetadataHighwayServicesClient;
import org.odpi.openmetadata.repositoryservices.connectors.stores.cohortregistrystore.properties.MemberRegistration;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.properties.CohortConnectionStatus;
import org.odpi.openmetadata.repositoryservices.properties.CohortDescription;
import org.odpi.openmetadata.serveroperations.properties.OMAGServerInstanceHistory;
import org.odpi.openmetadata.serveroperations.properties.OMAGServerServiceStatus;
import org.odpi.openmetadata.serveroperations.properties.ServerActiveStatus;
import org.odpi.openmetadata.serveroperations.properties.ServerServicesStatus;
import org.odpi.openmetadata.serveroperations.properties.ServerStatus;

public class EgeriaPlatformReport {
    private final String serverOfInterest;
    private final String platformURLRoot;
    private final String clientUserId;
    private final EgeriaReport report;

    private EgeriaPlatformReport(String serverOfInterest, String platformURLRoot, String clientUserId) throws IOException {
        String reportFileName = "egeria-platform-report.md";
        this.serverOfInterest = serverOfInterest;
        this.platformURLRoot = platformURLRoot;
        this.clientUserId = clientUserId;
        this.report = new EgeriaReport("egeria-platform-report.md");
    }

    private void run() {
        int indentLevel = 0;
        try {
            PlatformServicesClient platformServicesClient = new PlatformServicesClient("EgeriaPlatform", this.platformURLRoot);
            String reportTitle = "Platform report for: ";
            this.report.printReportTitle(indentLevel, "Platform report for: " + this.platformURLRoot);
            int detailIndentLevel = indentLevel + 1;
            this.report.printReportSubheading(detailIndentLevel, "Platform deployment");
            String platformOrigin = platformServicesClient.getPlatformOrigin(this.clientUserId);
            this.report.printReportLine(detailIndentLevel + 1, "Egeria version", platformOrigin.replace("\n", ""));
            OMAGServerPlatformConfigurationClient platformConfigurationClient = new OMAGServerPlatformConfigurationClient(this.clientUserId, this.platformURLRoot);
            ConfigurationManagementClient configurationManagementClient = new ConfigurationManagementClient(this.clientUserId, this.platformURLRoot);
            this.report.printConnection(detailIndentLevel + 1, "Configuration document store connector", platformConfigurationClient.getConfigurationStoreConnection());
            this.report.printConnection(detailIndentLevel + 1, "Platform security connector", platformServicesClient.getPlatformSecurityConnection(this.clientUserId));
            this.report.printReportSubheading(detailIndentLevel, "Registered services");
            this.report.printRegisteredServices(detailIndentLevel + 1, platformServicesClient.getAccessServices(this.clientUserId));
            this.report.printRegisteredServices(detailIndentLevel + 1, platformServicesClient.getEngineServices(this.clientUserId));
            this.report.printRegisteredServices(detailIndentLevel + 1, platformServicesClient.getIntegrationServices(this.clientUserId));
            this.report.printRegisteredServices(detailIndentLevel + 1, platformServicesClient.getViewServices(this.clientUserId));
            HashMap<String, OMAGServerDetails> serverDetailsMap = new HashMap<String, OMAGServerDetails>();
            if (this.serverOfInterest == null) {
                List serverList;
                this.report.printReportSubheading(detailIndentLevel, "Platform servers");
                Set configuredServers = null;
                try {
                    configuredServers = configurationManagementClient.getAllServerConfigurations();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (configuredServers != null) {
                    for (Object serverConfig : configuredServers) {
                        OMAGServerDetails currentDetails = (OMAGServerDetails)serverDetailsMap.get(serverConfig.getLocalServerName());
                        if (currentDetails == null) {
                            currentDetails = new OMAGServerDetails(serverConfig.getLocalServerName());
                        }
                        currentDetails.setConfiguration((OMAGServerConfig)serverConfig);
                        serverDetailsMap.put(serverConfig.getLocalServerName(), currentDetails);
                    }
                }
                if ((serverList = platformServicesClient.getKnownServers(this.clientUserId)) != null) {
                    for (String serverName : serverList) {
                        ServerStatus platformServerStatus;
                        if (serverName == null || (platformServerStatus = platformServicesClient.getServerStatus(this.clientUserId, serverName)) == null) continue;
                        OMAGServerDetails currentDetails = (OMAGServerDetails)serverDetailsMap.get(serverName);
                        if (currentDetails == null) {
                            currentDetails = new OMAGServerDetails(serverName);
                        }
                        currentDetails.setServerStartTime(platformServerStatus.getServerStartTime());
                        currentDetails.setServerEndTime(platformServerStatus.getServerEndTime());
                        currentDetails.setServerHistory(platformServerStatus.getServerHistory());
                    }
                }
                if ((serverList = platformServicesClient.getActiveServers(this.clientUserId)) != null) {
                    for (String serverName : serverList) {
                        PlatformServicesClient serverOperationsClient;
                        ServerServicesStatus adminServerStatus;
                        if (serverName == null || (adminServerStatus = (serverOperationsClient = new PlatformServicesClient(serverName, this.platformURLRoot)).getActiveServerStatus(this.clientUserId, serverName)) == null) continue;
                        OMAGServerDetails currentDetails = (OMAGServerDetails)serverDetailsMap.get(serverName);
                        if (currentDetails == null) {
                            currentDetails = new OMAGServerDetails(serverName);
                        }
                        currentDetails.setServerActiveStatus(adminServerStatus.getServerActiveStatus());
                        currentDetails.setServerType(adminServerStatus.getServerType());
                        currentDetails.setServices(adminServerStatus.getServices());
                    }
                }
            } else {
                Object serverConfig;
                this.report.printReportSubheading(detailIndentLevel, "Server of interest");
                OMAGServerDetails serverDetails = new OMAGServerDetails(this.serverOfInterest);
                OMAGServerConfigurationClient configurationClient = new OMAGServerConfigurationClient(this.clientUserId, this.serverOfInterest, this.platformURLRoot);
                serverConfig = configurationClient.getOMAGServerConfig();
                if (serverConfig != null) {
                    serverDetails.setConfiguration((OMAGServerConfig)serverConfig);
                }
                try {
                    ServerStatus platformServerStatus = platformServicesClient.getServerStatus(this.clientUserId, this.serverOfInterest);
                    if (platformServerStatus != null) {
                        serverDetails.setServerStartTime(platformServerStatus.getServerStartTime());
                        serverDetails.setServerEndTime(platformServerStatus.getServerEndTime());
                        serverDetails.setServerHistory(platformServerStatus.getServerHistory());
                    }
                }
                catch (InvalidParameterException platformServerStatus) {
                    // empty catch block
                }
                try {
                    PlatformServicesClient serverOperationsClient = new PlatformServicesClient(this.serverOfInterest, this.platformURLRoot);
                    ServerServicesStatus adminServerStatus = serverOperationsClient.getActiveServerStatus(this.clientUserId, this.serverOfInterest);
                    if (adminServerStatus != null) {
                        serverDetails.setServerActiveStatus(adminServerStatus.getServerActiveStatus());
                        serverDetails.setServerType(adminServerStatus.getServerType());
                        serverDetails.setServices(adminServerStatus.getServices());
                    }
                }
                catch (Exception serverOperationsClient) {
                    // empty catch block
                }
                serverDetailsMap.put(this.serverOfInterest, serverDetails);
            }
            for (OMAGServerDetails serverDetails : serverDetailsMap.values()) {
                if (serverDetails == null) continue;
                MetadataHighwayServicesClient metadataHighwayServicesClient = new MetadataHighwayServicesClient(serverDetails.getServerName(), this.platformURLRoot);
                try {
                    List cohorts = metadataHighwayServicesClient.getCohortDescriptions(this.clientUserId);
                    if (cohorts == null) continue;
                    for (CohortDescription cohortDescription : cohorts) {
                        if (cohortDescription == null) continue;
                        OMAGServerDetails.OMAGCohortDetails cohortDetails = serverDetails.getCohortDetails(cohortDescription.getCohortName());
                        cohortDetails.setConnectionStatus(cohortDescription.getConnectionStatus());
                        cohortDetails.setLocalRegistration(metadataHighwayServicesClient.getLocalRegistration(this.clientUserId, cohortDescription.getCohortName()));
                        cohortDetails.setRemoteRegistrations(metadataHighwayServicesClient.getRemoteRegistrations(this.clientUserId, cohortDescription.getCohortName()));
                    }
                }
                catch (RepositoryErrorException repositoryErrorException) {
                }
            }
            if (serverDetailsMap.isEmpty()) {
                this.report.printReportLine(detailIndentLevel + 1, "None");
            } else {
                for (OMAGServerDetails serverDetails : serverDetailsMap.values()) {
                    if (serverDetails == null) continue;
                    serverDetails.printServer(detailIndentLevel + 1);
                }
            }
            this.report.closeReport();
        }
        catch (Exception error) {
            System.out.println("There was an " + error.getClass().getName() + " exception when calling the platform.  Error message is: " + error.getMessage());
            System.exit(-1);
        }
    }

    public static void main(String[] args) {
        String serverName = null;
        String platformURLRoot = "https://localhost:9443";
        String clientUserId = "garygeeke";
        if (args.length > 0) {
            platformURLRoot = args[0];
        }
        if (args.length > 1) {
            clientUserId = args[1];
        }
        if (args.length > 2) {
            serverName = args[2];
        }
        System.out.println("===============================");
        System.out.println("OMAG Server Platform Report:    " + new Date());
        System.out.println("===============================");
        System.out.println("Running against platform: " + platformURLRoot);
        if (serverName != null) {
            System.out.println("Focused on server: " + serverName);
        }
        System.out.println("Using userId: " + clientUserId);
        System.out.println();
        HttpHelper.noStrictSSL();
        try {
            EgeriaPlatformReport report = new EgeriaPlatformReport(serverName, platformURLRoot, clientUserId);
            report.run();
        }
        catch (Exception error) {
            System.out.println("Exception: " + error.getClass().getName() + " with message " + error.getMessage());
            System.exit(-1);
        }
    }

    private class OMAGServerDetails {
        private final String serverName;
        private String serverType = null;
        private OMAGServerConfig configuration = null;
        private ServerActiveStatus serverActiveStatus = ServerActiveStatus.UNKNOWN;
        private Date serverStartTime = null;
        private Date serverEndTime = null;
        private List<OMAGServerInstanceHistory> serverHistory = null;
        private final Map<String, OMAGServiceDetails> serviceDetailsMap = new HashMap<String, OMAGServiceDetails>();
        private final Map<String, OMAGCohortDetails> cohortDetailsMap = new HashMap<String, OMAGCohortDetails>();

        OMAGServerDetails(String serverName) {
            this.serverName = serverName;
        }

        String getServerName() {
            return this.serverName;
        }

        void setConfiguration(OMAGServerConfig configuration) {
            this.configuration = configuration;
            if (configuration != null) {
                Object currentDetails;
                Object currentDetails2;
                this.serverType = configuration.getLocalServerType();
                if (configuration.getRepositoryServicesConfig() != null && configuration.getRepositoryServicesConfig().getCohortConfigList() != null) {
                    for (CohortConfig cohortConfig : configuration.getRepositoryServicesConfig().getCohortConfigList()) {
                        currentDetails2 = this.getCohortDetails(cohortConfig.getCohortName());
                        if (cohortConfig.getCohortRegistryConnection() != null) {
                            ((OMAGCohortDetails)currentDetails2).setConnection("Cohort Registry Store", cohortConfig.getCohortRegistryConnection());
                        }
                        if (cohortConfig.getCohortOMRSRegistrationTopicConnection() != null) {
                            ((OMAGCohortDetails)currentDetails2).setConnection("Cohort Registration Topic", cohortConfig.getCohortOMRSRegistrationTopicConnection());
                        }
                        if (cohortConfig.getCohortOMRSTypesTopicConnection() != null) {
                            ((OMAGCohortDetails)currentDetails2).setConnection("Cohort Types Topic", cohortConfig.getCohortOMRSTypesTopicConnection());
                        }
                        if (cohortConfig.getCohortOMRSInstancesTopicConnection() != null) {
                            ((OMAGCohortDetails)currentDetails2).setConnection("Cohort Instances Topic", cohortConfig.getCohortOMRSInstancesTopicConnection());
                        }
                        if (cohortConfig.getCohortOMRSTopicConnection() == null) continue;
                        ((OMAGCohortDetails)currentDetails2).setConnection("Cohort OMRS Topic (deprecated)", cohortConfig.getCohortOMRSTopicConnection());
                    }
                }
                if (configuration.getAccessServicesConfig() != null) {
                    for (Object accessServiceConfig : configuration.getAccessServicesConfig()) {
                        if (accessServiceConfig == null) continue;
                        currentDetails2 = this.serviceDetailsMap.get(accessServiceConfig.getAccessServiceFullName());
                        if (currentDetails2 == null) {
                            currentDetails2 = new OMAGServiceDetails(accessServiceConfig.getAccessServiceFullName());
                        }
                        ((OMAGServiceDetails)currentDetails2).setServiceOptions(accessServiceConfig.getAccessServiceOptions());
                        ((OMAGServiceDetails)currentDetails2).setConnection("InTopic", accessServiceConfig.getAccessServiceInTopic());
                        ((OMAGServiceDetails)currentDetails2).setConnection("OutTopic", accessServiceConfig.getAccessServiceInTopic());
                        this.serviceDetailsMap.put(accessServiceConfig.getAccessServiceFullName(), (OMAGServiceDetails)currentDetails2);
                    }
                }
                if (configuration.getEngineHostServicesConfig() != null) {
                    currentDetails = this.serviceDetailsMap.get(GovernanceServicesDescription.ENGINE_HOST_SERVICES.getServiceName());
                    if (currentDetails == null) {
                        currentDetails = new OMAGServiceDetails(GovernanceServicesDescription.ENGINE_HOST_SERVICES.getServiceName());
                    }
                    ((OMAGServiceDetails)currentDetails).setPartnerService(configuration.getEngineHostServicesConfig().getOMAGServerName(), configuration.getEngineHostServicesConfig().getOMAGServerPlatformRootURL(), AccessServiceDescription.GOVERNANCE_ENGINE_OMAS.getAccessServiceFullName());
                    if (configuration.getEngineHostServicesConfig().getEngineServiceConfigs() != null) {
                        for (EngineServiceConfig engineServiceConfig : configuration.getEngineHostServicesConfig().getEngineServiceConfigs()) {
                            if (engineServiceConfig == null) continue;
                            OMAGServiceDetails nestedDetails = this.serviceDetailsMap.get(engineServiceConfig.getEngineServiceFullName());
                            if (nestedDetails == null) {
                                nestedDetails = new OMAGServiceDetails(engineServiceConfig.getEngineServiceFullName());
                            }
                            nestedDetails.setServiceOptions(engineServiceConfig.getEngineServiceOptions());
                            nestedDetails.setPartnerService(engineServiceConfig.getOMAGServerName(), engineServiceConfig.getOMAGServerPlatformRootURL(), engineServiceConfig.getEngineServicePartnerOMAS());
                            if (engineServiceConfig.getEngines() != null) {
                                for (EngineConfig engineConfig : engineServiceConfig.getEngines()) {
                                    if (engineConfig == null) continue;
                                    OMAGServiceDetails engineServiceDetails = new OMAGServiceDetails(engineConfig.getEngineQualifiedName());
                                    engineServiceDetails.setServiceId(engineConfig.getEngineId());
                                    engineServiceDetails.setServiceUserId(engineConfig.getEngineUserId());
                                    nestedDetails.addNestedService(engineConfig.getEngineQualifiedName(), engineServiceDetails);
                                }
                            }
                            this.serviceDetailsMap.put(engineServiceConfig.getEngineServiceFullName(), (OMAGServiceDetails)currentDetails);
                        }
                    }
                }
                if (configuration.getIntegrationServicesConfig() != null) {
                    for (IntegrationServiceConfig integrationServiceConfig : configuration.getIntegrationServicesConfig()) {
                        if (integrationServiceConfig == null) continue;
                        currentDetails2 = this.serviceDetailsMap.get(integrationServiceConfig.getIntegrationServiceFullName());
                        if (currentDetails2 == null) {
                            currentDetails2 = new OMAGServiceDetails(integrationServiceConfig.getIntegrationServiceFullName());
                        }
                        ((OMAGServiceDetails)currentDetails2).setServiceOptions(integrationServiceConfig.getIntegrationServiceOptions());
                        ((OMAGServiceDetails)currentDetails2).setPartnerService(integrationServiceConfig.getOMAGServerName(), integrationServiceConfig.getOMAGServerPlatformRootURL(), integrationServiceConfig.getIntegrationServicePartnerOMAS());
                        if (integrationServiceConfig.getIntegrationConnectorConfigs() != null) {
                            for (IntegrationConnectorConfig connectorConfig : integrationServiceConfig.getIntegrationConnectorConfigs()) {
                                if (connectorConfig == null) continue;
                                String nestedServiceName = "Integration Connector: " + connectorConfig.getConnectorName();
                                OMAGServiceDetails connectorConfigDetails = new OMAGServiceDetails(nestedServiceName);
                                connectorConfigDetails.setServiceUserId(connectorConfig.getConnectorUserId());
                                connectorConfigDetails.setServiceId(connectorConfig.getConnectorId());
                                connectorConfigDetails.setConnection("Integration Connector Implementation", connectorConfig.getConnection());
                                ((OMAGServiceDetails)currentDetails2).addNestedService(nestedServiceName, connectorConfigDetails);
                            }
                        }
                        this.serviceDetailsMap.put(integrationServiceConfig.getIntegrationServiceFullName(), (OMAGServiceDetails)currentDetails2);
                    }
                }
                if (configuration.getViewServicesConfig() != null) {
                    for (ViewServiceConfig viewServiceConfig : configuration.getViewServicesConfig()) {
                        if (viewServiceConfig == null) continue;
                        currentDetails2 = this.serviceDetailsMap.get(viewServiceConfig.getViewServiceFullName());
                        if (currentDetails2 == null) {
                            currentDetails2 = new OMAGServiceDetails(viewServiceConfig.getViewServiceFullName());
                        }
                        ((OMAGServiceDetails)currentDetails2).setServiceOptions(viewServiceConfig.getViewServiceOptions());
                        ((OMAGServiceDetails)currentDetails2).setPartnerService(viewServiceConfig.getOMAGServerName(), viewServiceConfig.getOMAGServerPlatformRootURL(), null);
                        this.serviceDetailsMap.put(viewServiceConfig.getViewServiceFullName(), (OMAGServiceDetails)currentDetails2);
                    }
                }
                if (configuration.getDataEngineProxyConfig() != null) {
                    currentDetails = this.serviceDetailsMap.get(GovernanceServicesDescription.DATA_ENGINE_PROXY_SERVICES.getServiceName());
                    if (currentDetails == null) {
                        currentDetails = new OMAGServiceDetails(GovernanceServicesDescription.DATA_ENGINE_PROXY_SERVICES.getServiceName());
                    }
                    ((OMAGServiceDetails)currentDetails).setPartnerService(configuration.getDataEngineProxyConfig().getAccessServiceServerName(), configuration.getDataEngineProxyConfig().getAccessServiceRootURL(), AccessServiceDescription.DATA_ENGINE_OMAS.getAccessServiceFullName());
                    this.serviceDetailsMap.put(GovernanceServicesDescription.DATA_ENGINE_PROXY_SERVICES.getServiceName(), (OMAGServiceDetails)currentDetails);
                }
                if (configuration.getOpenLineageServerConfig() != null) {
                    currentDetails = this.serviceDetailsMap.get(GovernanceServicesDescription.OPEN_LINEAGE_SERVICES.getServiceName());
                    if (currentDetails == null) {
                        currentDetails = new OMAGServiceDetails(GovernanceServicesDescription.OPEN_LINEAGE_SERVICES.getServiceName());
                    }
                    ((OMAGServiceDetails)currentDetails).setPartnerService(configuration.getOpenLineageServerConfig().getAccessServiceConfig().getServerName(), configuration.getOpenLineageServerConfig().getAccessServiceConfig().getServerPlatformUrlRoot(), AccessServiceDescription.ASSET_LINEAGE_OMAS.getAccessServiceFullName());
                    this.serviceDetailsMap.put(GovernanceServicesDescription.OPEN_LINEAGE_SERVICES.getServiceName(), (OMAGServiceDetails)currentDetails);
                }
            }
        }

        void setServerType(String serverType) {
            this.serverType = serverType;
        }

        void setServerActiveStatus(ServerActiveStatus serverActiveStatus) {
            this.serverActiveStatus = serverActiveStatus;
        }

        void setServerStartTime(Date serverStartTime) {
            this.serverStartTime = serverStartTime;
        }

        void setServerEndTime(Date serverEndTime) {
            this.serverEndTime = serverEndTime;
        }

        void setServerHistory(List<OMAGServerInstanceHistory> serverHistory) {
            this.serverHistory = serverHistory;
        }

        void setServices(List<OMAGServerServiceStatus> services) {
            if (services != null) {
                for (OMAGServerServiceStatus serviceStatus : services) {
                    OMAGServiceDetails currentDetails = this.serviceDetailsMap.get(serviceStatus.getServiceName());
                    if (currentDetails == null) {
                        currentDetails = new OMAGServiceDetails(serviceStatus.getServiceName());
                    }
                    currentDetails.setServiceStatus(serviceStatus.getServiceStatus());
                    this.serviceDetailsMap.put(serviceStatus.getServiceName(), currentDetails);
                }
            }
        }

        OMAGCohortDetails getCohortDetails(String cohortName) {
            OMAGCohortDetails cohortDetails = this.cohortDetailsMap.get(cohortName);
            if (cohortDetails == null) {
                cohortDetails = new OMAGCohortDetails(cohortName);
                this.cohortDetailsMap.put(cohortName, cohortDetails);
            }
            return cohortDetails;
        }

        void printServer(int indentLevel) throws IOException {
            EgeriaPlatformReport.this.report.printReportSubheading(indentLevel, "Server: " + this.serverName);
            int detailIndentLevel = indentLevel + 1;
            EgeriaPlatformReport.this.report.printReportLine(detailIndentLevel, "Type", this.serverType);
            if (this.configuration != null) {
                EgeriaPlatformReport.this.report.printReportLine(detailIndentLevel, "Description", this.configuration.getLocalServerDescription());
                EgeriaPlatformReport.this.report.printReportLine(detailIndentLevel, "UserId", this.configuration.getLocalServerUserId());
                if (this.configuration.getServerSecurityConnection() != null) {
                    EgeriaPlatformReport.this.report.printConnection(detailIndentLevel, "Security Connector", this.configuration.getServerSecurityConnection());
                }
                if (this.configuration.getRepositoryServicesConfig() != null && this.configuration.getRepositoryServicesConfig().getLocalRepositoryConfig() != null) {
                    EgeriaPlatformReport.this.report.printReportSubheading(detailIndentLevel, "Local Repository");
                    if (this.configuration.getRepositoryServicesConfig().getLocalRepositoryConfig().getLocalRepositoryMode() != null) {
                        EgeriaPlatformReport.this.report.printReportLine(detailIndentLevel + 1, "Local Repository Mode", this.configuration.getRepositoryServicesConfig().getLocalRepositoryConfig().getLocalRepositoryMode().getName());
                    }
                    if (this.configuration.getRepositoryServicesConfig().getLocalRepositoryConfig().getLocalRepositoryLocalConnection() != null) {
                        EgeriaPlatformReport.this.report.printConnection(detailIndentLevel + 1, "Local Repository Connector", this.configuration.getRepositoryServicesConfig().getLocalRepositoryConfig().getLocalRepositoryLocalConnection());
                    }
                    if (this.configuration.getRepositoryServicesConfig().getLocalRepositoryConfig().getEventMapperConnection() != null) {
                        EgeriaPlatformReport.this.report.printConnection(detailIndentLevel + 1, "Local Repository Event Mapper Connector", this.configuration.getRepositoryServicesConfig().getLocalRepositoryConfig().getEventMapperConnection());
                    }
                    if (this.configuration.getRepositoryServicesConfig().getLocalRepositoryConfig().getLocalRepositoryRemoteConnection() != null) {
                        EgeriaPlatformReport.this.report.printConnection(detailIndentLevel + 1, "Local Repository Remote Connector", this.configuration.getRepositoryServicesConfig().getLocalRepositoryConfig().getLocalRepositoryRemoteConnection());
                    }
                }
            }
            EgeriaPlatformReport.this.report.printReportSubheading(detailIndentLevel, "Runtime Status");
            if (this.serverStartTime != null) {
                EgeriaPlatformReport.this.report.printReportLine(detailIndentLevel + 1, "Last Start Time", this.serverStartTime.toString());
            }
            if (this.serverEndTime != null) {
                EgeriaPlatformReport.this.report.printReportLine(detailIndentLevel + 1, "Last End Time", this.serverEndTime.toString());
            }
            if (this.serverActiveStatus != null && this.serverActiveStatus != ServerActiveStatus.UNKNOWN) {
                EgeriaPlatformReport.this.report.printReportLine(detailIndentLevel + 1, "Server Active Status", this.serverActiveStatus.getName());
            }
            if (this.serverHistory != null) {
                EgeriaPlatformReport.this.report.printReportSubheading(detailIndentLevel + 1, "History");
                for (OMAGServerInstanceHistory instanceHistory : this.serverHistory) {
                    if (instanceHistory.getStartTime() != null) {
                        EgeriaPlatformReport.this.report.printReportLine(detailIndentLevel + 2, "Start Time", instanceHistory.getStartTime().toString());
                    }
                    if (instanceHistory.getEndTime() == null) continue;
                    EgeriaPlatformReport.this.report.printReportLine(detailIndentLevel + 2, "End Time", instanceHistory.getEndTime().toString());
                }
            }
            EgeriaPlatformReport.this.report.printReportSubheading(detailIndentLevel, "Services");
            for (OMAGServiceDetails serviceDetails : this.serviceDetailsMap.values()) {
                serviceDetails.printService(detailIndentLevel + 1);
            }
            if (!this.cohortDetailsMap.isEmpty()) {
                EgeriaPlatformReport.this.report.printReportSubheading(detailIndentLevel, "Cohorts");
                for (OMAGCohortDetails cohortDetails : this.cohortDetailsMap.values()) {
                    cohortDetails.printCohort(detailIndentLevel + 1);
                }
            }
        }

        private class OMAGCohortDetails {
            private final String cohortName;
            private CohortConnectionStatus connectionStatus = null;
            private Map<String, Connection> connectors = null;
            private MemberRegistration localRegistration = null;
            private List<MemberRegistration> remoteRegistrations = null;

            OMAGCohortDetails(String cohortName) {
                this.cohortName = cohortName;
            }

            void setConnectionStatus(CohortConnectionStatus connectionStatus) {
                this.connectionStatus = connectionStatus;
            }

            void setConnection(String connectorName, Connection connection) {
                if (connection != null) {
                    Connection existingConnection;
                    if (this.connectors == null) {
                        this.connectors = new HashMap<String, Connection>();
                    }
                    if ((existingConnection = this.connectors.put(connectorName, connection)) != null) {
                        System.out.println("Error: two connectors of the same name: " + connectorName + " in service: " + this.cohortName);
                        System.out.println("       existing connection: " + existingConnection);
                        System.out.println("       new connection: " + connection);
                    }
                }
            }

            void setLocalRegistration(MemberRegistration localRegistration) {
                this.localRegistration = localRegistration;
            }

            void setRemoteRegistrations(List<MemberRegistration> remoteRegistrations) {
                this.remoteRegistrations = remoteRegistrations;
            }

            void printCohort(int indentLevel) throws IOException {
                EgeriaPlatformReport.this.report.printReportSubheading(indentLevel, "Cohort: " + this.cohortName);
                int detailIndentLevel = indentLevel + 1;
                if (this.connectionStatus != null) {
                    EgeriaPlatformReport.this.report.printReportLine(detailIndentLevel, "Cohort Connection Status", this.connectionStatus.getStatusName());
                }
                if (this.connectors != null) {
                    if (this.connectors.size() > 1) {
                        EgeriaPlatformReport.this.report.printReportSubheading(detailIndentLevel, "Cohort Connectors");
                        ++detailIndentLevel;
                    }
                    for (String connectorName : this.connectors.keySet()) {
                        EgeriaPlatformReport.this.report.printConnection(detailIndentLevel, connectorName, this.connectors.get(connectorName));
                    }
                }
                if (this.localRegistration != null) {
                    EgeriaPlatformReport.this.report.printReportSubheading(detailIndentLevel, "Local registration to " + this.cohortName);
                    EgeriaPlatformReport.this.report.printReportLine(detailIndentLevel + 1, "Metadata Collection Id", this.localRegistration.getMetadataCollectionId());
                    EgeriaPlatformReport.this.report.printReportLine(detailIndentLevel + 1, "Metadata Collection Name", this.localRegistration.getMetadataCollectionName());
                    if (this.localRegistration.getRegistrationTime() != null) {
                        EgeriaPlatformReport.this.report.printReportLine(detailIndentLevel + 1, "First registration time with cohort", this.localRegistration.getRegistrationTime().toString());
                    }
                }
                if (this.remoteRegistrations != null) {
                    EgeriaPlatformReport.this.report.printReportSubheading(detailIndentLevel, "Registrations received from members of " + this.cohortName);
                    for (MemberRegistration remoteRegistration : this.remoteRegistrations) {
                        if (remoteRegistration == null) continue;
                        EgeriaPlatformReport.this.report.printReportSubheading(detailIndentLevel + 1, "Registration from " + remoteRegistration.getServerName());
                        EgeriaPlatformReport.this.report.printReportLine(detailIndentLevel + 2, "Metadata Collection Id", this.localRegistration.getMetadataCollectionId());
                        EgeriaPlatformReport.this.report.printReportLine(detailIndentLevel + 2, "Metadata Collection Name", this.localRegistration.getMetadataCollectionName());
                        EgeriaPlatformReport.this.report.printReportLine(detailIndentLevel + 2, "Server Type", this.localRegistration.getServerType());
                        EgeriaPlatformReport.this.report.printReportLine(detailIndentLevel + 2, "Organization", this.localRegistration.getOrganizationName());
                        if (remoteRegistration.getRegistrationTime() == null) continue;
                        EgeriaPlatformReport.this.report.printReportLine(detailIndentLevel + 2, "First registration time with this member", remoteRegistration.getRegistrationTime().toString());
                    }
                }
            }
        }

        private class OMAGServiceDetails {
            private final String serviceName;
            private String serviceId = null;
            private String serviceUserId = null;
            private ServerActiveStatus serviceStatus = ServerActiveStatus.UNKNOWN;
            private Map<String, Object> serviceOptions = null;
            private String partnerServerName = null;
            private String partnerURLRoot = null;
            private String partnerServiceName = null;
            private Map<String, Connection> connectors = null;
            private Map<String, OMAGServiceDetails> nestedServices = null;

            OMAGServiceDetails(String serviceName) {
                this.serviceName = serviceName;
            }

            void setServiceId(String serviceId) {
                this.serviceId = serviceId;
            }

            void setServiceUserId(String serviceUserId) {
                this.serviceUserId = serviceUserId;
            }

            void setServiceStatus(ServerActiveStatus serviceStatus) {
                this.serviceStatus = serviceStatus;
            }

            void setServiceOptions(Map<String, Object> serviceOptions) {
                this.serviceOptions = serviceOptions;
            }

            void setPartnerService(String partnerServerName, String partnerURLRoot, String partnerServiceName) {
                this.partnerServerName = partnerServerName;
                this.partnerURLRoot = partnerURLRoot;
                this.partnerServiceName = partnerServiceName;
            }

            void setConnection(String connectorName, Connection connection) {
                if (connection != null) {
                    Connection existingConnection;
                    if (this.connectors == null) {
                        this.connectors = new HashMap<String, Connection>();
                    }
                    if ((existingConnection = this.connectors.put(connectorName, connection)) != null) {
                        System.out.println("Error: two connectors of the same name: " + connectorName + " in service: " + this.serviceName);
                        System.out.println("       existing connection: " + existingConnection);
                        System.out.println("       new connection: " + connection);
                    }
                }
            }

            void addNestedService(String serviceName, OMAGServiceDetails serviceDetails) {
                OMAGServiceDetails existingService;
                if (this.nestedServices == null) {
                    this.nestedServices = new HashMap<String, OMAGServiceDetails>();
                }
                if ((existingService = this.nestedServices.put(serviceName, serviceDetails)) != null) {
                    System.out.println("Error: two nested services of same name: " + serviceName + " in service: " + this.serviceName);
                    System.out.println("       existing nested service: " + existingService);
                    System.out.println("       new nested service: " + serviceDetails);
                }
            }

            void printService(int indentLevel) throws IOException {
                EgeriaPlatformReport.this.report.printReportSubheading(indentLevel, "Service: " + this.serviceName);
                int detailIndentLevel = indentLevel + 1;
                if (this.serviceId != null) {
                    EgeriaPlatformReport.this.report.printReportLine(detailIndentLevel, "Service Id", this.serviceId);
                }
                if (this.serviceUserId != null) {
                    EgeriaPlatformReport.this.report.printReportLine(detailIndentLevel, "Service UserId", this.serviceUserId);
                }
                if (this.serviceStatus != null && this.serviceStatus != ServerActiveStatus.UNKNOWN) {
                    EgeriaPlatformReport.this.report.printReportLine(detailIndentLevel, "Service Status", this.serviceStatus.getName());
                }
                if (this.partnerServerName != null) {
                    EgeriaPlatformReport.this.report.printReportSubheading(detailIndentLevel, "Partner Service:");
                    EgeriaPlatformReport.this.report.printReportLine(detailIndentLevel + 1, "Partner Server", this.partnerServerName);
                    EgeriaPlatformReport.this.report.printReportLine(detailIndentLevel + 1, "Partner URL root", this.partnerURLRoot);
                    EgeriaPlatformReport.this.report.printReportLine(detailIndentLevel + 1, "Calling Service Name", this.partnerServiceName);
                }
                if (this.serviceOptions != null) {
                    EgeriaPlatformReport.this.report.printReportSubheading(detailIndentLevel, "Service Options");
                    for (String optionName : this.serviceOptions.keySet()) {
                        if (optionName == null) continue;
                        EgeriaPlatformReport.this.report.printReportLine(detailIndentLevel + 1, optionName, this.serviceOptions.get(optionName).toString());
                    }
                }
                if (this.nestedServices != null) {
                    EgeriaPlatformReport.this.report.printReportSubheading(detailIndentLevel, "Nested Services");
                    for (OMAGServiceDetails nestedService : this.nestedServices.values()) {
                        if (nestedService == null) continue;
                        nestedService.printService(detailIndentLevel + 1);
                    }
                }
                if (this.connectors != null) {
                    if (this.connectors.size() > 1) {
                        EgeriaPlatformReport.this.report.printReportSubheading(detailIndentLevel, "Connectors");
                        ++detailIndentLevel;
                    }
                    for (String connectorName : this.connectors.keySet()) {
                        EgeriaPlatformReport.this.report.printConnection(detailIndentLevel, connectorName, this.connectors.get(connectorName));
                    }
                }
            }
        }
    }
}

