/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.control;

import org.odpi.openmetadata.frameworks.openmetadata.mapper.OpenMetadataValidValues;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.DeployedImplementationType;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.DeployedImplementationTypeDefinition;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;

public enum EgeriaDeployedImplementationType implements DeployedImplementationTypeDefinition
{
    OMAG_SERVER_PLATFORM("OMAG Server Platform", (DeployedImplementationTypeDefinition)DeployedImplementationType.SOFTWARE_SERVER, OpenMetadataType.SOFTWARE_SERVER_PLATFORM.typeName, null, "An Open Metadata and Governance (OMAG) runtime for running one to many OMAG Servers.", "https://egeria-project.org/concepts/omag-server-platform/"),
    OMAG_SERVER_RUNTIME("OMAG Server Runtime", (DeployedImplementationTypeDefinition)DeployedImplementationType.SOFTWARE_SERVER, OpenMetadataType.SOFTWARE_SERVER_PLATFORM.typeName, null, "An Open Metadata and Governance (OMAG) runtime for running a single OMAG Server.", "https://egeria-project.org/concepts/omag-server-runtime/"),
    OMAG_SERVER("OMAG Server", (DeployedImplementationTypeDefinition)DeployedImplementationType.SOFTWARE_SERVER, OpenMetadataType.SOFTWARE_SERVER.typeName, null, "A server providing Open Metadata and Governance (OMAG) services.", "https://egeria-project.org/concepts/omag-server/"),
    ENGINE_HOST("Engine Host", OMAG_SERVER, OpenMetadataType.SOFTWARE_SERVER.typeName, OpenMetadataType.GOVERNANCE_DAEMON_CLASSIFICATION.typeName, "A server that runs governance engines.", "https://egeria-project.org/concepts/engine-host/"),
    INTEGRATION_DAEMON("Integration Daemon", OMAG_SERVER, OpenMetadataType.SOFTWARE_SERVER.typeName, OpenMetadataType.INTEGRATION_SERVER_CLASSIFICATION.typeName, "A server that runs integration connectors that synchronize metadata between different types of technologies.", "https://egeria-project.org/concepts/integration-daemon/"),
    METADATA_ACCESS_SERVER("Metadata Access Server", OMAG_SERVER, OpenMetadataType.SOFTWARE_SERVER.typeName, OpenMetadataType.METADATA_SERVER_CLASSIFICATION.typeName, "A server that provides access to one or more open metadata repositories.", "https://egeria-project.org/concepts/metadata-access-server/"),
    VIEW_SERVER("View Server", OMAG_SERVER, OpenMetadataType.SOFTWARE_SERVER.typeName, OpenMetadataType.STEWARDSHIP_SERVER_CLASSIFICATION.typeName, "A server that provides access to end user open metadata and governance services.", "https://egeria-project.org/concepts/metadata-access-server/");

    private final String deployedImplementationType;
    private final DeployedImplementationTypeDefinition isATypeOf;
    private final String associatedTypeName;
    private final String associatedClassification;
    private final String description;
    private final String wikiLink;

    public static DeployedImplementationTypeDefinition getDefinitionFromDeployedImplementationType(String deployedImplementationType) {
        if (deployedImplementationType != null) {
            for (EgeriaDeployedImplementationType definition : EgeriaDeployedImplementationType.values()) {
                if (!definition.getDeployedImplementationType().equals(deployedImplementationType)) continue;
                return definition;
            }
        }
        return null;
    }

    private EgeriaDeployedImplementationType(String deployedImplementationType, DeployedImplementationTypeDefinition isATypeOf, String associatedTypeName, String associatedClassification, String description, String wikiLink) {
        this.deployedImplementationType = deployedImplementationType;
        this.isATypeOf = isATypeOf;
        this.associatedTypeName = associatedTypeName;
        this.associatedClassification = associatedClassification;
        this.description = description;
        this.wikiLink = wikiLink;
    }

    public String getDeployedImplementationType() {
        return this.deployedImplementationType;
    }

    public DeployedImplementationTypeDefinition getIsATypeOf() {
        return this.isATypeOf;
    }

    public String getAssociatedTypeName() {
        return this.associatedTypeName;
    }

    public String getAssociatedClassification() {
        return this.associatedClassification;
    }

    public String getQualifiedName() {
        return OpenMetadataValidValues.constructValidValueQualifiedName((String)this.associatedTypeName, (String)OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, null, (String)this.deployedImplementationType);
    }

    public String getCategory() {
        return OpenMetadataValidValues.constructValidValueCategory((String)this.associatedTypeName, (String)OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, null);
    }

    public String getDescription() {
        return this.description;
    }

    public String getWikiLink() {
        return this.wikiLink;
    }

    public String toString() {
        return "DeployedImplementationType{" + this.deployedImplementationType + "}";
    }
}

