/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.control;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.control.EgeriaDeployedImplementationType;
import org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.control.OMAGServerPlatformPlaceholderProperty;
import org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.platform.OMAGServerPlatformProvider;
import org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.servers.EngineHostProvider;
import org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.servers.IntegrationDaemonProvider;
import org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.servers.MetadataAccessServerProvider;
import org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.servers.ViewServerProvider;
import org.odpi.openmetadata.adapters.connectors.secretsstore.yaml.YAMLSecretsStoreProvider;
import org.odpi.openmetadata.frameworks.connectors.controls.SecretsStorePurpose;
import org.odpi.openmetadata.frameworks.openmetadata.controls.PlaceholderProperty;
import org.odpi.openmetadata.frameworks.openmetadata.controls.PlaceholderPropertyType;
import org.odpi.openmetadata.frameworks.openmetadata.controls.ReplacementAttributeType;
import org.odpi.openmetadata.frameworks.openmetadata.controls.TemplateDefinition;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.DeployedImplementationType;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.DeployedImplementationTypeDefinition;

public enum EgeriaSoftwareServerTemplateDefinition implements TemplateDefinition
{
    OMAG_SERVER_PLATFORM_TEMPLATE("9b06c4dc-ddc8-47ae-b56b-28775d3a96f0", EgeriaDeployedImplementationType.OMAG_SERVER_PLATFORM, (DeployedImplementationTypeDefinition)DeployedImplementationType.USER_AUTHENTICATION_MANAGER, "User Token Manager", OMAGServerPlatformPlaceholderProperty.PLATFORM_NAME.getPlaceholder(), OMAGServerPlatformPlaceholderProperty.PLATFORM_DESCRIPTION.getPlaceholder(), OMAGServerPlatformPlaceholderProperty.CONNECTION_USER_ID.getPlaceholder(), new OMAGServerPlatformProvider().getConnectorType().getGUID(), OMAGServerPlatformPlaceholderProperty.HOST_URL.getPlaceholder() + ":" + OMAGServerPlatformPlaceholderProperty.PORT_NUMBER.getPlaceholder(), EgeriaSoftwareServerTemplateDefinition.getOMAGServerPlatformConfigProperties(), null, null, null, null, OMAGServerPlatformPlaceholderProperty.getPlaceholderPropertyTypes()),
    ENGINE_HOST_TEMPLATE("1764a891-4234-45f1-8cc3-536af40c790d", EgeriaDeployedImplementationType.ENGINE_HOST, (DeployedImplementationTypeDefinition)DeployedImplementationType.REST_API_MANAGER, "Governance Engine Status APIs", PlaceholderProperty.SERVER_NAME.getPlaceholder(), PlaceholderProperty.DESCRIPTION.getPlaceholder(), PlaceholderProperty.CONNECTION_USER_ID.getPlaceholder(), new EngineHostProvider().getConnectorType().getGUID(), PlaceholderProperty.SERVER_NETWORK_ADDRESS.getPlaceholder(), EgeriaSoftwareServerTemplateDefinition.getOMAGServerConfigProperties(), null, null, null, null, EgeriaSoftwareServerTemplateDefinition.getOMAGServerPlaceholderPropertyTypes()),
    INTEGRATION_DAEMON_TEMPLATE("6b3516f0-dd13-4786-9601-07215f995197", EgeriaDeployedImplementationType.INTEGRATION_DAEMON, (DeployedImplementationTypeDefinition)DeployedImplementationType.REST_API_MANAGER, "Governance Engine Status APIs", PlaceholderProperty.SERVER_NAME.getPlaceholder(), PlaceholderProperty.DESCRIPTION.getPlaceholder(), PlaceholderProperty.CONNECTION_USER_ID.getPlaceholder(), new IntegrationDaemonProvider().getConnectorType().getGUID(), PlaceholderProperty.SERVER_NETWORK_ADDRESS.getPlaceholder(), EgeriaSoftwareServerTemplateDefinition.getOMAGServerConfigProperties(), null, null, null, null, EgeriaSoftwareServerTemplateDefinition.getOMAGServerPlaceholderPropertyTypes()),
    METADATA_ACCESS_SERVER_TEMPLATE("bd8de890-fa79-4c24-aab8-20b41b5893dd", EgeriaDeployedImplementationType.METADATA_ACCESS_SERVER, (DeployedImplementationTypeDefinition)DeployedImplementationType.REST_API_MANAGER, "Open Metadata Repository Access APIs", PlaceholderProperty.SERVER_NAME.getPlaceholder(), PlaceholderProperty.DESCRIPTION.getPlaceholder(), PlaceholderProperty.CONNECTION_USER_ID.getPlaceholder(), new MetadataAccessServerProvider().getConnectorType().getGUID(), PlaceholderProperty.SERVER_NETWORK_ADDRESS.getPlaceholder(), EgeriaSoftwareServerTemplateDefinition.getOMAGServerConfigProperties(), null, null, null, null, EgeriaSoftwareServerTemplateDefinition.getOMAGServerPlaceholderPropertyTypes()),
    VIEW_SERVER_TEMPLATE("fd61ca01-390d-4aa2-a55d-426826aa4e1b", EgeriaDeployedImplementationType.VIEW_SERVER, (DeployedImplementationTypeDefinition)DeployedImplementationType.REST_API_MANAGER, "Open Metadata and Governance End User APIs", PlaceholderProperty.SERVER_NAME.getPlaceholder(), PlaceholderProperty.DESCRIPTION.getPlaceholder(), PlaceholderProperty.CONNECTION_USER_ID.getPlaceholder(), new ViewServerProvider().getConnectorType().getGUID(), PlaceholderProperty.SERVER_NETWORK_ADDRESS.getPlaceholder(), EgeriaSoftwareServerTemplateDefinition.getOMAGServerConfigProperties(), SecretsStorePurpose.REST_BEARER_TOKEN.getName(), new YAMLSecretsStoreProvider().getConnectorType().getGUID(), PlaceholderProperty.SECRETS_STORE.getPlaceholder(), null, EgeriaSoftwareServerTemplateDefinition.getViewServerPlaceholderPropertyTypes());

    private final String guid;
    private final DeployedImplementationTypeDefinition deployedImplementationType;
    private final DeployedImplementationTypeDefinition softwareCapabilityType;
    private final String softwareCapabilityName;
    private final String serverName;
    private final String description;
    private final String userId;
    private final String connectorTypeGUID;
    private final String networkAddress;
    private final Map<String, Object> configurationProperties;
    private final String secretsStorePurpose;
    private final String secretsStoreConnectorTypeGUID;
    private final String secretsStoreFileName;
    private final List<ReplacementAttributeType> replacementAttributeTypes;
    private final List<PlaceholderPropertyType> placeholderPropertyTypes;

    private static Map<String, Object> getOMAGServerConfigProperties() {
        HashMap<String, Object> configurationProperties = new HashMap<String, Object>();
        configurationProperties.put(PlaceholderProperty.SERVER_NAME.getName(), PlaceholderProperty.SERVER_NAME.getPlaceholder());
        return configurationProperties;
    }

    private static Map<String, Object> getOMAGServerPlatformConfigProperties() {
        HashMap<String, Object> configurationProperties = new HashMap<String, Object>();
        configurationProperties.put(PlaceholderProperty.SECRETS_STORE.getName(), PlaceholderProperty.SECRETS_STORE.getPlaceholder());
        return configurationProperties;
    }

    public static List<PlaceholderPropertyType> getOMAGServerPlaceholderPropertyTypes() {
        ArrayList<PlaceholderPropertyType> placeholderPropertyTypes = new ArrayList<PlaceholderPropertyType>();
        placeholderPropertyTypes.add(PlaceholderProperty.SERVER_NETWORK_ADDRESS.getPlaceholderType());
        placeholderPropertyTypes.add(PlaceholderProperty.SERVER_NAME.getPlaceholderType());
        placeholderPropertyTypes.add(PlaceholderProperty.SERVER_ID.getPlaceholderType());
        placeholderPropertyTypes.add(PlaceholderProperty.DESCRIPTION.getPlaceholderType());
        placeholderPropertyTypes.add(PlaceholderProperty.VERSION_IDENTIFIER.getPlaceholderType());
        placeholderPropertyTypes.add(PlaceholderProperty.CONNECTION_USER_ID.getPlaceholderType());
        return placeholderPropertyTypes;
    }

    public static List<PlaceholderPropertyType> getViewServerPlaceholderPropertyTypes() {
        ArrayList<PlaceholderPropertyType> placeholderPropertyTypes = new ArrayList<PlaceholderPropertyType>();
        placeholderPropertyTypes.add(PlaceholderProperty.SERVER_NETWORK_ADDRESS.getPlaceholderType());
        placeholderPropertyTypes.add(PlaceholderProperty.SERVER_NAME.getPlaceholderType());
        placeholderPropertyTypes.add(PlaceholderProperty.SERVER_ID.getPlaceholderType());
        placeholderPropertyTypes.add(PlaceholderProperty.DESCRIPTION.getPlaceholderType());
        placeholderPropertyTypes.add(PlaceholderProperty.VERSION_IDENTIFIER.getPlaceholderType());
        placeholderPropertyTypes.add(PlaceholderProperty.CONNECTION_USER_ID.getPlaceholderType());
        placeholderPropertyTypes.add(PlaceholderProperty.SECRETS_STORE.getPlaceholderType());
        return placeholderPropertyTypes;
    }

    private EgeriaSoftwareServerTemplateDefinition(String guid, DeployedImplementationTypeDefinition deployedImplementationType, DeployedImplementationTypeDefinition softwareCapabilityType, String softwareCapabilityName, String serverName, String description, String userId, String connectorTypeGUID, String networkAddress, Map<String, Object> configurationProperties, String secretsStorePurpose, String secretsStoreConnectorTypeGUID, String secretsStoreFileName, List<ReplacementAttributeType> replacementAttributeTypes, List<PlaceholderPropertyType> placeholderPropertyTypes) {
        this.guid = guid;
        this.deployedImplementationType = deployedImplementationType;
        this.softwareCapabilityType = softwareCapabilityType;
        this.softwareCapabilityName = softwareCapabilityName;
        this.serverName = serverName;
        this.description = description;
        this.userId = userId;
        this.connectorTypeGUID = connectorTypeGUID;
        this.networkAddress = networkAddress;
        this.configurationProperties = configurationProperties;
        this.secretsStorePurpose = secretsStorePurpose;
        this.secretsStoreConnectorTypeGUID = secretsStoreConnectorTypeGUID;
        this.secretsStoreFileName = secretsStoreFileName;
        this.replacementAttributeTypes = replacementAttributeTypes;
        this.placeholderPropertyTypes = placeholderPropertyTypes;
    }

    public String getTemplateGUID() {
        return this.guid;
    }

    public String getQualifiedName() {
        return this.deployedImplementationType.getDeployedImplementationType() + ":" + this.serverName;
    }

    public String getTemplateName() {
        return this.deployedImplementationType.getDeployedImplementationType() + " template";
    }

    public String getTemplateDescription() {
        return "Create a " + this.deployedImplementationType.getDeployedImplementationType() + " SoftwareServer with an associated SoftwareCapability and Connection.";
    }

    public String getTemplateVersionIdentifier() {
        return "V1.0";
    }

    public DeployedImplementationTypeDefinition getDeployedImplementationType() {
        return this.deployedImplementationType;
    }

    public DeployedImplementationTypeDefinition getSoftwareCapabilityType() {
        return this.softwareCapabilityType;
    }

    public String getSoftwareCapabilityName() {
        return this.softwareCapabilityName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getServerDescription() {
        return this.description;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getConnectorTypeGUID() {
        return this.connectorTypeGUID;
    }

    public String getNetworkAddress() {
        return this.networkAddress;
    }

    public Map<String, Object> getConfigurationProperties() {
        return this.configurationProperties;
    }

    public String getSecretsStorePurpose() {
        return this.secretsStorePurpose;
    }

    public String getSecretsStoreConnectorTypeGUID() {
        return this.secretsStoreConnectorTypeGUID;
    }

    public String getSecretsStoreFileName() {
        return this.secretsStoreFileName;
    }

    public List<PlaceholderPropertyType> getPlaceholders() {
        return this.placeholderPropertyTypes;
    }

    public List<ReplacementAttributeType> getReplacementAttributes() {
        return this.replacementAttributeTypes;
    }

    public String toString() {
        return "TemplateDefinition{templateName='" + this.getTemplateName() + "'}";
    }
}

