/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.control;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.control.EgeriaDeployedImplementationType;
import org.odpi.openmetadata.frameworks.governanceaction.controls.ActionTargetType;
import org.odpi.openmetadata.frameworks.integration.controls.CatalogTargetType;

public enum OMAGServerPlatformTarget {
    PLATFORM_TARGET("omagServerPlatformInstance", EgeriaDeployedImplementationType.OMAG_SERVER_PLATFORM.getDescription(), EgeriaDeployedImplementationType.OMAG_SERVER_PLATFORM.getAssociatedTypeName(), EgeriaDeployedImplementationType.OMAG_SERVER_PLATFORM.getDeployedImplementationType(), null);

    private final String name;
    public final String description;
    private final String typeName;
    private final String deployedImplementationType;
    private final Map<String, String> otherPropertyValues;

    private OMAGServerPlatformTarget(String name, String description, String typeName, String deployedImplementationType, Map<String, String> otherPropertyValues) {
        this.name = name;
        this.description = description;
        this.typeName = typeName;
        this.deployedImplementationType = deployedImplementationType;
        this.otherPropertyValues = otherPropertyValues;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getDeployedImplementationType() {
        return this.deployedImplementationType;
    }

    public Map<String, String> getOtherPropertyValues() {
        return this.otherPropertyValues;
    }

    public static List<CatalogTargetType> getCatalogTargetTypes() {
        ArrayList<CatalogTargetType> catalogTargetTypes = new ArrayList<CatalogTargetType>();
        for (OMAGServerPlatformTarget catalogTarget : OMAGServerPlatformTarget.values()) {
            catalogTargetTypes.add(catalogTarget.getCatalogTargetType());
        }
        return catalogTargetTypes;
    }

    public CatalogTargetType getCatalogTargetType() {
        CatalogTargetType catalogTargetType = new CatalogTargetType();
        catalogTargetType.setName(this.name);
        catalogTargetType.setTypeName(this.typeName);
        catalogTargetType.setDeployedImplementationType(this.deployedImplementationType);
        catalogTargetType.setOtherPropertyValues(this.otherPropertyValues);
        return catalogTargetType;
    }

    public static List<ActionTargetType> getActionTargetTypes() {
        ArrayList<ActionTargetType> actionTargetTypes = new ArrayList<ActionTargetType>();
        for (OMAGServerPlatformTarget catalogTarget : OMAGServerPlatformTarget.values()) {
            actionTargetTypes.add(catalogTarget.getActionTargetType());
        }
        return actionTargetTypes;
    }

    public ActionTargetType getActionTargetType() {
        ActionTargetType actionTargetType = new ActionTargetType();
        actionTargetType.setName(this.name);
        actionTargetType.setDescription(this.description);
        actionTargetType.setTypeName(this.typeName);
        actionTargetType.setDeployedImplementationType(this.deployedImplementationType);
        return actionTargetType;
    }

    public String toString() {
        return "TargetEnum{catalogTargetName='" + this.name + "'}";
    }
}

