/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.platform;

import java.util.List;
import java.util.Set;
import org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.extractor.EgeriaExtractor;
import org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.ffdc.OMAGConnectorAuditCode;
import org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.ffdc.OMAGConnectorErrorCode;
import org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.properties.OMAGServerPlatformProperties;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGService;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLoggingComponent;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDescription;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.EndpointProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ConnectorType;

public class OMAGServerPlatformConnector
extends ConnectorBase
implements AuditLoggingComponent {
    private AuditLog auditLog = null;
    private String connectorName = "OMAG Server Platform Connector";
    private String targetRootURL = null;
    private String platformName = "OMAG Server Platform";
    private String clientUserId = null;
    private EgeriaExtractor extractor = null;

    public void setAuditLog(AuditLog auditLog) {
        this.auditLog = auditLog;
    }

    public ComponentDescription getConnectorComponentDescription() {
        if (this.auditLog != null && this.auditLog.getReport() != null) {
            return this.auditLog.getReport().getReportingComponent();
        }
        return null;
    }

    public void setPlatformName(String platformName) {
        this.platformName = platformName;
    }

    public void setClientUserId(String clientUserId) {
        this.clientUserId = clientUserId;
    }

    public void start() throws ConnectorCheckedException {
        EndpointProperties endpoint;
        super.start();
        String methodName = "start";
        if (this.connectionProperties.getConnectionName() != null) {
            this.connectorName = this.connectionProperties.getConnectionName();
        }
        if ((endpoint = this.connectionProperties.getEndpoint()) != null) {
            this.targetRootURL = endpoint.getAddress();
        }
        if (this.targetRootURL == null) {
            throw new ConnectorCheckedException(OMAGConnectorErrorCode.NULL_URL.getMessageDefinition(this.connectorName), ((Object)((Object)this)).getClass().getName(), "start");
        }
        try {
            this.extractor = this.connectionProperties.getUserId() != null ? new EgeriaExtractor(this.targetRootURL, this.platformName, null, this.connectionProperties.getUserId()) : new EgeriaExtractor(this.targetRootURL, this.platformName, null, this.clientUserId);
        }
        catch (Exception error) {
            if (this.auditLog != null) {
                this.auditLog.logException("start", OMAGConnectorAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), "start", error.getMessage()), (Throwable)error);
            }
            throw new ConnectorCheckedException(OMAGConnectorErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), "start", error.getMessage()), ((Object)((Object)this)).getClass().getName(), "start", (Throwable)error);
        }
    }

    public OMAGServerPlatformProperties getPlatformReport() throws Exception {
        return this.extractor.getPlatformReport();
    }

    public ConnectorType getConnectorType(String connectorProviderClassName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.extractor.getConnectorType(connectorProviderClassName);
    }

    public List<RegisteredOMAGService> getAccessServices() throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.extractor.getAccessServices();
    }

    public List<RegisteredOMAGService> getEngineServices() throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.extractor.getEngineServices();
    }

    public List<RegisteredOMAGService> getViewServices() throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.extractor.getViewServices();
    }

    public List<RegisteredOMAGService> getIntegrationServices() throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.extractor.getIntegrationServices();
    }

    public List<RegisteredOMAGService> getAllServices() throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.extractor.getAllServices();
    }

    public Set<OMAGServerConfig> getAllServerConfigurations() throws OMAGNotAuthorizedException, OMAGConfigurationErrorException, OMAGInvalidParameterException {
        return this.extractor.getAllServerConfigurations();
    }

    public void deployOMAGServerConfig(String serverName, String destinationPlatformURLRoot) throws OMAGNotAuthorizedException, OMAGConfigurationErrorException, OMAGInvalidParameterException {
        this.extractor.deployOMAGServerConfig(serverName, destinationPlatformURLRoot);
    }

    public OMAGServerConfig getOMAGServerConfig(String serverName) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        return this.extractor.getOMAGServerConfig(serverName);
    }

    public String activateServer(String serverName) throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        return this.extractor.activateServer(serverName);
    }

    public void shutdownServer(String serverName) throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        this.extractor.shutdownServer(serverName);
    }

    public void shutdownAllServers() throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        this.extractor.shutdownAllServers();
    }

    public void shutdownAndUnregisterServer(String serverName) throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        this.extractor.shutdownAndUnregisterServer(serverName);
    }

    public void shutdownAndUnregisterAllServers() throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        this.extractor.shutdownAndUnregisterAllServers();
    }
}

