/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.servers;

import java.util.List;
import org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.extractor.EgeriaExtractor;
import org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.ffdc.OMAGConnectorAuditCode;
import org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.ffdc.OMAGConnectorErrorCode;
import org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.properties.OMAGServerProperties;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLoggingComponent;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDescription;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBase;
import org.odpi.openmetadata.frameworks.connectors.VirtualConnectorExtension;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.EndpointProperties;
import org.odpi.openmetadata.serveroperations.properties.ServerServicesStatus;
import org.odpi.openmetadata.serveroperations.properties.ServerStatus;

public abstract class OMAGServerConnectorBase
extends ConnectorBase
implements AuditLoggingComponent,
VirtualConnectorExtension {
    private AuditLog auditLog = null;
    private String connectorName;
    private String clientUserId = null;
    private String targetRootURL = null;
    protected EgeriaExtractor extractor = null;

    public OMAGServerConnectorBase(String connectorName) {
        this.connectorName = connectorName;
    }

    public void setAuditLog(AuditLog auditLog) {
        this.auditLog = auditLog;
    }

    public ComponentDescription getConnectorComponentDescription() {
        if (this.auditLog != null && this.auditLog.getReport() != null) {
            return this.auditLog.getReport().getReportingComponent();
        }
        return null;
    }

    public void setClientUserId(String clientUserId) {
        this.clientUserId = clientUserId;
    }

    public void start() throws ConnectorCheckedException {
        EndpointProperties endpoint;
        super.start();
        String methodName = "start";
        if (this.connectionProperties.getConnectionName() != null) {
            this.connectorName = this.connectionProperties.getConnectionName();
        }
        if ((endpoint = this.connectionProperties.getEndpoint()) != null) {
            this.targetRootURL = endpoint.getAddress();
        }
        if (this.targetRootURL == null) {
            throw new ConnectorCheckedException(OMAGConnectorErrorCode.NULL_URL.getMessageDefinition(this.connectorName), ((Object)((Object)this)).getClass().getName(), "start");
        }
        String serverName = null;
        if (this.connectionProperties.getConfigurationProperties() != null && this.connectionProperties.getConfigurationProperties().get("serverName") != null) {
            serverName = this.connectionProperties.getConfigurationProperties().get("serverName").toString();
        }
        if (serverName == null) {
            throw new ConnectorCheckedException(OMAGConnectorErrorCode.NULL_SERVER_NAME.getMessageDefinition(this.connectorName), ((Object)((Object)this)).getClass().getName(), "start");
        }
        try {
            this.extractor = this.clientUserId != null ? new EgeriaExtractor(this.targetRootURL, null, serverName, this.clientUserId) : new EgeriaExtractor(this.targetRootURL, null, serverName, this.connectionProperties.getUserId());
        }
        catch (Exception error) {
            if (this.auditLog != null) {
                this.auditLog.logException("start", OMAGConnectorAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), "start", error.getMessage()), (Throwable)error);
            }
            throw new ConnectorCheckedException(OMAGConnectorErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), "start", error.getMessage()), ((Object)((Object)this)).getClass().getName(), "start", (Throwable)error);
        }
    }

    public OMAGServerProperties getServerReport() throws Exception {
        return this.extractor.getServerReport();
    }

    public OMAGServerConfig getOMAGServerConfig() throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        return this.extractor.getOMAGServerConfig();
    }

    public String activateServer() throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        return this.extractor.activateServer();
    }

    public void shutdownServer() throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        this.extractor.shutdownServer();
    }

    public void shutdownAndUnregisterServer() throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        this.extractor.shutdownAndUnregisterServer();
    }

    public ServerStatus getServerStatus() throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.extractor.getServerStatus();
    }

    public OMAGServerConfig getActiveConfiguration() throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        return this.extractor.getActiveConfiguration();
    }

    public ServerServicesStatus getActiveServerStatus() throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        return this.extractor.getActiveServerStatus();
    }

    public List<String> getActiveServices() throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.extractor.getActiveServices();
    }

    public boolean connectToCohort(String userId, String cohortName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.extractor.connectToCohort(userId, cohortName);
    }

    public boolean disconnectFromCohort(String userId, String cohortName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.extractor.disconnectFromCohort(userId, cohortName);
    }

    public boolean unregisterFromCohort(String userId, String cohortName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.extractor.unregisterFromCohort(userId, cohortName);
    }
}

