/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.control;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.control.OMAGServerPlatformMetric;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.frameworks.surveyaction.controls.AnalysisStep;
import org.odpi.openmetadata.frameworks.surveyaction.controls.AnnotationTypeType;
import org.odpi.openmetadata.frameworks.surveyaction.measurements.SurveyMetric;

public enum OMAGServerPlatformAnnotationType {
    SERVER_TYPES("Capture number of each type of server.", OpenMetadataType.RESOURCE_PROFILE_ANNOTATION.typeName, "Extract the list of OMAG Servers running on the platform and count how many of each server type.", "The OMAG Server Platform hosts OMAG Servers.   There are different types of servers for different purposes.  This annotation shows how many of each type of server are present.", null),
    SERVER_NAMES("Capture server names and description.", OpenMetadataType.RESOURCE_PROFILE_ANNOTATION.typeName, "Extract the list of OMAG Servers running on the platform and count how many of each server type.", "The OMAG Server Platform hosts OMAG Servers.   There are different types of servers for different purposes.  This annotation shows how many of each type of server are present.", null),
    PLATFORM_METRICS("Capture OMAG Server Platform metrics", OpenMetadataType.RESOURCE_MEASURE_ANNOTATION.typeName, "Capture summary statistics about an OMAG Server Platform.", "This annotation retrieves statistics about an OMAG Server Platform.", OMAGServerPlatformMetric.getMetrics()),
    SERVER_AVAILABILITY("Capture Server Availability", OpenMetadataType.RESOURCE_PROFILE_ANNOTATION.typeName, "Capture the percentage of time that the each server has been available since the platform started.", "This annotation uses the server history and current start time to calculate the percentage of the time that the server has been available since the platform started.", null);

    public final String name;
    public final String openMetadataTypeName;
    public final String summary;
    public final String explanation;
    public final List<SurveyMetric> metrics;

    private OMAGServerPlatformAnnotationType(String name, String openMetadataTypeName, String summary, String explanation, List<SurveyMetric> metrics) {
        this.name = name;
        this.openMetadataTypeName = openMetadataTypeName;
        this.summary = summary;
        this.explanation = explanation;
        this.metrics = metrics;
    }

    public static List<AnnotationTypeType> getAnnotationTypeTypes() {
        ArrayList<AnnotationTypeType> annotationTypeTypes = new ArrayList<AnnotationTypeType>();
        for (OMAGServerPlatformAnnotationType annotationType : OMAGServerPlatformAnnotationType.values()) {
            annotationTypeTypes.add(annotationType.getAnnotationTypeType());
        }
        return annotationTypeTypes;
    }

    public String getName() {
        return this.name;
    }

    public String getAnalysisStep() {
        return AnalysisStep.PROFILING_ASSOCIATED_RESOURCES.getName();
    }

    public String getOpenMetadataTypeName() {
        return this.openMetadataTypeName;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getExplanation() {
        return this.explanation;
    }

    public AnnotationTypeType getAnnotationTypeType() {
        AnnotationTypeType annotationTypeType = new AnnotationTypeType();
        annotationTypeType.setName(this.name);
        annotationTypeType.setOpenMetadataTypeName(this.openMetadataTypeName);
        annotationTypeType.setAnalysisStepName(AnalysisStep.PROFILING_ASSOCIATED_RESOURCES.getName());
        annotationTypeType.setSummary(this.summary);
        annotationTypeType.setExplanation(this.explanation);
        if (this.metrics != null) {
            HashMap<String, String> metricsMap = new HashMap<String, String>();
            for (SurveyMetric surveyMetric : this.metrics) {
                metricsMap.put(surveyMetric.getDisplayName(), surveyMetric.getDescription());
            }
            annotationTypeType.setOtherPropertyValues(metricsMap);
        }
        return annotationTypeType;
    }

    public String toString() {
        return "AnnotationType{ name='" + this.name + "}";
    }
}

