/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.control;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.openmetadata.controls.PlaceholderProperty;
import org.odpi.openmetadata.frameworks.openmetadata.controls.PlaceholderPropertyType;

public enum OMAGServerPlatformPlaceholderProperty {
    HOST_URL("platformHostURL", "The host IP address or domain name of the platform with the HTTP protocol prefix.", "string", "https://coconet.com"),
    PORT_NUMBER("platformPortNumber", "The number of the port to use to connect to the platform.", "string", "9443"),
    CONNECTION_USER_ID("platformUserId", "The userId to store in the userId attribute of the connection. This is a platform user that is defined to the platform security connector and is used when making REST API calls to the platform.", "string", "garygeeke"),
    SECRETS_STORE(PlaceholderProperty.SECRETS_STORE.getName(), PlaceholderProperty.SECRETS_STORE.getDescription(), PlaceholderProperty.SECRETS_STORE.getDataType(), PlaceholderProperty.SECRETS_STORE.getExample()),
    PLATFORM_NAME("platformName", "The name of the platform being catalogued.", "string", "Default OMAG Server Platform"),
    PLATFORM_DESCRIPTION("platformDescription", "The description of the platform being catalogued.", "string", null);

    public final String name;
    public final String description;
    public final String dataType;
    public final String example;

    private OMAGServerPlatformPlaceholderProperty(String name, String description, String dataType, String example) {
        this.name = name;
        this.description = description;
        this.dataType = dataType;
        this.example = example;
    }

    public String getName() {
        return this.name;
    }

    public String getPlaceholder() {
        return "{{" + this.name + "}}";
    }

    public String getDescription() {
        return this.description;
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getExample() {
        return this.example;
    }

    public static List<PlaceholderPropertyType> getPlaceholderPropertyTypes() {
        ArrayList<PlaceholderPropertyType> placeholderPropertyTypes = new ArrayList<PlaceholderPropertyType>();
        for (OMAGServerPlatformPlaceholderProperty placeholderProperty : OMAGServerPlatformPlaceholderProperty.values()) {
            placeholderPropertyTypes.add(placeholderProperty.getPlaceholderType());
        }
        return placeholderPropertyTypes;
    }

    public PlaceholderPropertyType getPlaceholderType() {
        PlaceholderPropertyType placeholderPropertyType = new PlaceholderPropertyType();
        placeholderPropertyType.setName(this.name);
        placeholderPropertyType.setDescription(this.description);
        placeholderPropertyType.setDataType(this.dataType);
        placeholderPropertyType.setExample(this.example);
        placeholderPropertyType.setRequired(true);
        return placeholderPropertyType;
    }

    public String toString() {
        return "PlaceholderProperty{ name=" + this.name + "}";
    }
}

