/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.extractor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.properties.OMAGCohortProperties;
import org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.properties.OMAGConnectorProperties;
import org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.properties.OMAGEngineHostProperties;
import org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.properties.OMAGIntegrationDaemonProperties;
import org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.properties.OMAGIntegrationGroupProperties;
import org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.properties.OMAGMetadataStoreProperties;
import org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.properties.OMAGServerPlatformProperties;
import org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.properties.OMAGServerProperties;
import org.odpi.openmetadata.adminservices.classifier.ServerTypeClassifier;
import org.odpi.openmetadata.adminservices.client.ConfigurationManagementClient;
import org.odpi.openmetadata.adminservices.client.OMAGServerPlatformConfigurationClient;
import org.odpi.openmetadata.adminservices.configuration.properties.CohortConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.ServerTypeClassification;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGService;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ConnectorType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.EmbeddedConnection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.VirtualConnection;
import org.odpi.openmetadata.governanceservers.enginehostservices.client.EngineHostClient;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.client.IntegrationDaemon;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.properties.IntegrationDaemonStatus;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.properties.IntegrationGroupSummary;
import org.odpi.openmetadata.integrationservices.lineage.client.LineageIntegrator;
import org.odpi.openmetadata.platformservices.client.PlatformServicesClient;
import org.odpi.openmetadata.repositoryservices.clients.AuditLogServicesClient;
import org.odpi.openmetadata.repositoryservices.clients.MetadataHighwayServicesClient;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.properties.CohortConnectionStatus;
import org.odpi.openmetadata.repositoryservices.properties.CohortDescription;
import org.odpi.openmetadata.serveroperations.client.ServerOperationsClient;
import org.odpi.openmetadata.serveroperations.properties.ServerServicesStatus;
import org.odpi.openmetadata.serveroperations.properties.ServerStatus;

public class EgeriaExtractor {
    private final String platformURLRoot;
    private final String platformName;
    private final String serverOfInterest;
    private final String clientUserId;
    private final PlatformServicesClient platformServicesClient;
    private final OMAGServerPlatformConfigurationClient platformConfigurationClient;
    private final ConfigurationManagementClient configurationManagementClient;
    private final IntegrationDaemon integrationDaemonClient;
    private final LineageIntegrator openLineageClient;
    private final EngineHostClient engineHostClient;
    private final AuditLogServicesClient auditLogServicesClient;
    private final MetadataHighwayServicesClient metadataHighwayServicesClient;
    private final ServerOperationsClient serverOperationsClient;

    public EgeriaExtractor(String platformURLRoot, String platformName, String serverOfInterest, String clientUserId) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, OMAGInvalidParameterException, InvalidParameterException {
        this.platformURLRoot = platformURLRoot;
        this.platformName = platformName;
        this.serverOfInterest = serverOfInterest;
        this.clientUserId = clientUserId;
        this.platformServicesClient = new PlatformServicesClient(platformName, platformURLRoot);
        this.platformConfigurationClient = new OMAGServerPlatformConfigurationClient(clientUserId, platformURLRoot);
        this.configurationManagementClient = new ConfigurationManagementClient(clientUserId, platformURLRoot);
        this.serverOperationsClient = new ServerOperationsClient(clientUserId, platformURLRoot);
        if (serverOfInterest != null) {
            this.integrationDaemonClient = new IntegrationDaemon(serverOfInterest, platformURLRoot);
            this.openLineageClient = new LineageIntegrator(serverOfInterest, platformURLRoot);
            this.engineHostClient = new EngineHostClient(platformURLRoot, serverOfInterest);
            this.metadataHighwayServicesClient = new MetadataHighwayServicesClient(serverOfInterest, platformURLRoot);
            this.auditLogServicesClient = new AuditLogServicesClient(serverOfInterest, platformURLRoot);
        } else {
            this.integrationDaemonClient = null;
            this.openLineageClient = null;
            this.engineHostClient = null;
            this.metadataHighwayServicesClient = null;
            this.auditLogServicesClient = null;
        }
    }

    public OMAGServerPlatformProperties getPlatformReport() throws Exception {
        OMAGServerPlatformProperties platformReport = new OMAGServerPlatformProperties();
        platformReport.setPlatformName(this.platformName);
        platformReport.setPlatformURLRoot(this.platformURLRoot);
        platformReport.setPlatformOrigin(this.platformServicesClient.getPlatformOrigin(this.clientUserId));
        platformReport.setPlatformBuildProperties(this.platformServicesClient.getPlatformBuildProperties(this.clientUserId));
        platformReport.setPlatformStartTime(this.platformServicesClient.getPlatformStartTime(this.clientUserId));
        platformReport.setPlatformSecurityConnection(this.getConnectorProperties("Platform Security Connector", this.platformServicesClient.getPlatformSecurityConnection(this.clientUserId)));
        platformReport.setConfigurationStoreConnection(this.getConnectorProperties("Configuration Store Connector", this.platformConfigurationClient.getConfigurationStoreConnection()));
        platformReport.setRegisteredOMAGServices(this.platformServicesClient.getAllServices(this.clientUserId));
        HashMap<String, OMAGServerProperties> serverDetailsMap = new HashMap<String, OMAGServerProperties>();
        if (this.serverOfInterest != null) {
            serverDetailsMap.put(this.serverOfInterest, this.extractServerReport(this.serverOfInterest));
        } else {
            List knownServers = this.platformServicesClient.getKnownServers(this.clientUserId);
            if (knownServers != null) {
                for (String serverName : knownServers) {
                    if (serverName == null) continue;
                    serverDetailsMap.put(serverName, this.extractServerReport(serverName));
                }
            }
        }
        if (!serverDetailsMap.isEmpty()) {
            platformReport.setOMAGServers(new ArrayList<OMAGServerProperties>(serverDetailsMap.values()));
        }
        return platformReport;
    }

    public ConnectorType getConnectorType(String connectorProviderClassName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.platformServicesClient.getConnectorType(this.clientUserId, connectorProviderClassName);
    }

    public List<RegisteredOMAGService> getAccessServices() throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.platformServicesClient.getAccessServices(this.clientUserId);
    }

    public List<RegisteredOMAGService> getEngineServices() throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.platformServicesClient.getEngineServices(this.clientUserId);
    }

    public List<RegisteredOMAGService> getViewServices() throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.platformServicesClient.getViewServices(this.clientUserId);
    }

    public List<RegisteredOMAGService> getIntegrationServices() throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.platformServicesClient.getIntegrationServices(this.clientUserId);
    }

    public List<RegisteredOMAGService> getAllServices() throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.platformServicesClient.getAllServices(this.clientUserId);
    }

    public String activateServer(String serverName) throws UserNotAuthorizedException, org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException {
        return this.platformServicesClient.activateWithStoredConfig(this.clientUserId, serverName);
    }

    public String activateServer() throws UserNotAuthorizedException, org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException {
        return this.platformServicesClient.activateWithStoredConfig(this.clientUserId, this.serverOfInterest);
    }

    public void shutdownServer(String serverName) throws UserNotAuthorizedException, org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException {
        this.platformServicesClient.shutdownServer(this.clientUserId, serverName);
    }

    public void shutdownServer() throws UserNotAuthorizedException, org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException {
        this.platformServicesClient.shutdownServer(this.clientUserId, this.serverOfInterest);
    }

    public void shutdownAllServers() throws UserNotAuthorizedException, org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException {
        this.platformServicesClient.shutdownAllServers(this.clientUserId);
    }

    public void shutdownAndUnregisterServer(String serverName) throws UserNotAuthorizedException, org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException {
        this.platformServicesClient.shutdownAndUnregisterServer(this.clientUserId, serverName);
    }

    public void shutdownAndUnregisterServer() throws UserNotAuthorizedException, org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException {
        this.platformServicesClient.shutdownAndUnregisterServer(this.clientUserId, this.serverOfInterest);
    }

    public void shutdownAndUnregisterAllServers() throws UserNotAuthorizedException, org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException {
        this.platformServicesClient.shutdownAndUnregisterAllServers(this.clientUserId);
    }

    public boolean connectToCohort(String userId, String cohortName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        assert (this.metadataHighwayServicesClient != null);
        try {
            return this.metadataHighwayServicesClient.connectToCohort(userId, cohortName);
        }
        catch (InvalidParameterException error) {
            throw new org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException((OCFCheckedExceptionBase)error, cohortName);
        }
        catch (RepositoryErrorException error) {
            throw new PropertyServerException((OCFCheckedExceptionBase)error);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            throw new UserNotAuthorizedException((OCFCheckedExceptionBase)error, userId);
        }
    }

    public boolean disconnectFromCohort(String userId, String cohortName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        assert (this.metadataHighwayServicesClient != null);
        try {
            return this.metadataHighwayServicesClient.disconnectFromCohort(userId, cohortName);
        }
        catch (InvalidParameterException error) {
            throw new org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException((OCFCheckedExceptionBase)error, cohortName);
        }
        catch (RepositoryErrorException error) {
            throw new PropertyServerException((OCFCheckedExceptionBase)error);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            throw new UserNotAuthorizedException((OCFCheckedExceptionBase)error, userId);
        }
    }

    public boolean unregisterFromCohort(String userId, String cohortName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        assert (this.metadataHighwayServicesClient != null);
        try {
            return this.metadataHighwayServicesClient.unregisterFromCohort(userId, cohortName);
        }
        catch (InvalidParameterException error) {
            throw new org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException((OCFCheckedExceptionBase)error, cohortName);
        }
        catch (RepositoryErrorException error) {
            throw new PropertyServerException((OCFCheckedExceptionBase)error);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            throw new UserNotAuthorizedException((OCFCheckedExceptionBase)error, userId);
        }
    }

    public Set<OMAGServerConfig> getAllServerConfigurations() throws OMAGNotAuthorizedException, OMAGConfigurationErrorException, OMAGInvalidParameterException {
        return this.configurationManagementClient.getAllServerConfigurations();
    }

    public void deployOMAGServerConfig(String serverName, String destinationPlatformURLRoot) throws OMAGNotAuthorizedException, OMAGConfigurationErrorException, OMAGInvalidParameterException {
        this.configurationManagementClient.deployOMAGServerConfig(serverName, destinationPlatformURLRoot);
    }

    public OMAGServerConfig getOMAGServerConfig(String serverName) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        return this.configurationManagementClient.getOMAGServerConfig(serverName);
    }

    public OMAGServerConfig getOMAGServerConfig() throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        return this.configurationManagementClient.getOMAGServerConfig(this.serverOfInterest);
    }

    public ServerStatus getServerStatus() throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (this.serverOfInterest != null) {
            return this.serverOperationsClient.getServerStatus(this.clientUserId, this.serverOfInterest);
        }
        return null;
    }

    public OMAGServerConfig getActiveConfiguration() throws UserNotAuthorizedException, org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException {
        if (this.serverOfInterest != null) {
            return this.serverOperationsClient.getActiveConfiguration(this.clientUserId, this.serverOfInterest);
        }
        return null;
    }

    public ServerServicesStatus getActiveServerStatus() throws UserNotAuthorizedException, org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException {
        if (this.serverOfInterest != null) {
            return this.serverOperationsClient.getActiveServerStatus(this.clientUserId, this.serverOfInterest);
        }
        return null;
    }

    public List<String> getActiveServices() throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (this.serverOfInterest != null) {
            return this.serverOperationsClient.getActiveServices(this.clientUserId, this.serverOfInterest);
        }
        return null;
    }

    public void addOpenMetadataArchiveFile(String fileName) throws UserNotAuthorizedException, org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException {
        if (this.serverOfInterest != null) {
            this.serverOperationsClient.addOpenMetadataArchiveFile(this.clientUserId, this.serverOfInterest, fileName);
        }
    }

    public void addOpenMetadataArchive(Connection connection) throws UserNotAuthorizedException, org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException {
        if (this.serverOfInterest != null) {
            this.serverOperationsClient.addOpenMetadataArchive(this.clientUserId, this.serverOfInterest, connection);
        }
    }

    public void addOpenMetadataArchiveContent(OpenMetadataArchive openMetadataArchive) throws UserNotAuthorizedException, org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, PropertyServerException {
        if (this.serverOfInterest != null) {
            this.serverOperationsClient.addOpenMetadataArchiveContent(this.clientUserId, this.serverOfInterest, openMetadataArchive);
        }
    }

    public OMAGServerProperties getServerReport() throws Exception {
        if (this.serverOfInterest != null) {
            return this.extractServerReport(this.serverOfInterest);
        }
        return null;
    }

    private OMAGServerProperties extractServerReport(String serverName) throws Exception {
        OMAGServerConfig savedConfiguration = this.configurationManagementClient.getOMAGServerConfig(serverName);
        if (savedConfiguration != null) {
            OMAGServerProperties serverProperties;
            ServerTypeClassifier serverTypeClassifier = new ServerTypeClassifier(serverName, savedConfiguration);
            ServerTypeClassification serverTypeClassification = serverTypeClassifier.getServerType();
            if (serverTypeClassification == ServerTypeClassification.INTEGRATION_DAEMON) {
                IntegrationDaemon integrationDaemonClient = new IntegrationDaemon(serverName, this.platformURLRoot);
                OMAGIntegrationDaemonProperties integrationDaemon = new OMAGIntegrationDaemonProperties();
                IntegrationDaemonStatus integrationDaemonStatus = integrationDaemonClient.getIntegrationDaemonStatus(this.clientUserId);
                if (integrationDaemonStatus != null) {
                    if (integrationDaemonStatus.getIntegrationGroupSummaries() != null) {
                        ArrayList<OMAGIntegrationGroupProperties> integrationGroups = new ArrayList<OMAGIntegrationGroupProperties>();
                        for (IntegrationGroupSummary integrationGroupSummary : integrationDaemonStatus.getIntegrationGroupSummaries()) {
                            if (integrationGroupSummary == null) continue;
                            OMAGIntegrationGroupProperties integrationGroupProperties = new OMAGIntegrationGroupProperties();
                            integrationGroupProperties.setIntegrationGroupName(integrationGroupSummary.getIntegrationGroupName());
                            integrationGroupProperties.setIntegrationGroupGUID(integrationGroupSummary.getIntegrationGroupGUID());
                            integrationGroupProperties.setIntegrationGroupDescription(integrationGroupSummary.getIntegrationGroupDescription());
                            integrationGroupProperties.setIntegrationGroupStatus(integrationGroupSummary.getIntegrationGroupStatus());
                            integrationGroups.add(integrationGroupProperties);
                        }
                        integrationDaemon.setIntegrationGroups(integrationGroups);
                    }
                    integrationDaemon.setIntegrationConnectorReports(integrationDaemonStatus.getIntegrationConnectorReports());
                }
                serverProperties = integrationDaemon;
            } else if (serverTypeClassification == ServerTypeClassification.ENGINE_HOST) {
                EngineHostClient engineHostClient = new EngineHostClient(this.platformURLRoot, serverName);
                OMAGEngineHostProperties engineHost = new OMAGEngineHostProperties();
                engineHost.setGovernanceEngineSummaries(engineHostClient.getGovernanceEngineSummaries(this.clientUserId));
                serverProperties = engineHost;
            } else if (serverTypeClassification == ServerTypeClassification.METADATA_ACCESS_STORE) {
                OMAGMetadataStoreProperties metadataStoreProperties = new OMAGMetadataStoreProperties();
                if (savedConfiguration.getRepositoryServicesConfig() != null && savedConfiguration.getRepositoryServicesConfig().getLocalRepositoryConfig() != null) {
                    metadataStoreProperties.setRepositoryConnector(this.getConnectorProperties("Local Repository", savedConfiguration.getRepositoryServicesConfig().getLocalRepositoryConfig().getLocalRepositoryLocalConnection()));
                }
                serverProperties = metadataStoreProperties;
            } else {
                serverProperties = new OMAGServerProperties();
            }
            this.fillInStandardServerProperties(serverName, serverTypeClassification, savedConfiguration, serverProperties);
            return serverProperties;
        }
        return null;
    }

    private void fillInStandardServerProperties(String serverName, ServerTypeClassification serverTypeClassification, OMAGServerConfig configuration, OMAGServerProperties currentDetails) throws Exception {
        ServerStatus platformServerStatus;
        currentDetails.setServerName(serverName);
        currentDetails.setServerType(serverTypeClassification.getServerTypeName());
        if (configuration != null) {
            currentDetails.setMaxPageSize(configuration.getMaxPageSize());
            currentDetails.setDescription(configuration.getLocalServerDescription());
            currentDetails.setOrganizationName(configuration.getOrganizationName());
            currentDetails.setSecurityConnection(configuration.getServerSecurityConnection());
            currentDetails.setServerId(configuration.getLocalServerId());
            if (configuration.getRepositoryServicesConfig() != null) {
                currentDetails.setCohorts(this.getCohortConfigDetails(serverName, configuration.getRepositoryServicesConfig().getCohortConfigList()));
            }
        }
        if ((platformServerStatus = this.platformServicesClient.getServerStatus(this.clientUserId, serverName)) != null) {
            currentDetails.setLastStartTime(platformServerStatus.getServerStartTime());
            currentDetails.setLastShutdownTime(platformServerStatus.getServerEndTime());
            currentDetails.setServerHistory(platformServerStatus.getServerHistory());
        }
        try {
            ServerServicesStatus activeServerStatus = this.platformServicesClient.getActiveServerStatus(this.clientUserId, serverName);
            if (activeServerStatus != null) {
                currentDetails.setServerActiveStatus(activeServerStatus.getServerActiveStatus());
                currentDetails.setServerType(activeServerStatus.getServerType());
                currentDetails.setServices(activeServerStatus.getServices());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private List<OMAGCohortProperties> getCohortConfigDetails(String serverName, List<CohortConfig> cohortConfigs) throws InvalidParameterException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        if (cohortConfigs != null) {
            try {
                MetadataHighwayServicesClient metadataHighwayServicesClient = new MetadataHighwayServicesClient(serverName, this.platformURLRoot);
                List cohortDescriptions = metadataHighwayServicesClient.getCohortDescriptions(this.clientUserId);
                HashMap<String, CohortConnectionStatus> cohortConnectionStatusMap = new HashMap<String, CohortConnectionStatus>();
                if (cohortDescriptions != null) {
                    for (CohortDescription cohortDescription : cohortDescriptions) {
                        if (cohortDescription == null) continue;
                        cohortConnectionStatusMap.put(cohortDescription.getCohortName(), cohortDescription.getConnectionStatus());
                    }
                }
                ArrayList<OMAGCohortProperties> cohortPropertiesList = new ArrayList<OMAGCohortProperties>();
                for (CohortConfig cohortConfig : cohortConfigs) {
                    if (cohortConfig == null) continue;
                    OMAGCohortProperties cohortDetails = new OMAGCohortProperties();
                    cohortDetails.setCohortName(cohortConfig.getCohortName());
                    ArrayList<OMAGConnectorProperties> cohortConnectors = new ArrayList<OMAGConnectorProperties>();
                    if (cohortConfig.getCohortRegistryConnection() != null) {
                        cohortConnectors.add(this.getConnectorProperties(cohortDetails.getCohortName() + " Cohort Registry Connector", cohortConfig.getCohortRegistryConnection()));
                    }
                    if (cohortConfig.getCohortOMRSTopicConnection() != null) {
                        cohortConnectors.add(this.getConnectorProperties(cohortDetails.getCohortName() + " Cohort Topic", cohortConfig.getCohortOMRSTopicConnection()));
                    }
                    if (cohortConfig.getCohortOMRSRegistrationTopicConnection() != null) {
                        cohortConnectors.add(this.getConnectorProperties(cohortDetails.getCohortName() + " Cohort Registration Topic", cohortConfig.getCohortOMRSRegistrationTopicConnection()));
                    }
                    if (cohortConfig.getCohortOMRSTypesTopicConnection() != null) {
                        cohortConnectors.add(this.getConnectorProperties(cohortDetails.getCohortName() + " Cohort Types Topic", cohortConfig.getCohortOMRSTypesTopicConnection()));
                    }
                    if (cohortConfig.getCohortOMRSInstancesTopicConnection() != null) {
                        cohortConnectors.add(this.getConnectorProperties(cohortDetails.getCohortName() + " Cohort Instances Topic", cohortConfig.getCohortOMRSInstancesTopicConnection()));
                    }
                    cohortDetails.setConnectors(cohortConnectors);
                    cohortDetails.setConnectionStatus((CohortConnectionStatus)cohortConnectionStatusMap.get(cohortConfig.getCohortName()));
                    cohortDetails.setLocalRegistration(metadataHighwayServicesClient.getLocalRegistration(this.clientUserId, cohortConfig.getCohortName()));
                    cohortDetails.setRemoteRegistrations(metadataHighwayServicesClient.getRemoteRegistrations(this.clientUserId, cohortConfig.getCohortName()));
                    cohortPropertiesList.add(cohortDetails);
                }
                return cohortPropertiesList;
            }
            catch (RepositoryErrorException repositoryErrorException) {
                // empty catch block
            }
        }
        return null;
    }

    private OMAGConnectorProperties getConnectorProperties(String connectorName, Connection connection) {
        OMAGConnectorProperties connectorProperties = new OMAGConnectorProperties();
        connectorProperties.setConnectorName(connectorName);
        if (connection != null) {
            VirtualConnection virtualConnection;
            connectorProperties.setConnectorType(connection.getConnectorType());
            connectorProperties.setConfigurationProperties(connection.getConfigurationProperties());
            if (connectorName == null) {
                if (connection.getDisplayName() != null) {
                    connectorProperties.setConnectorName(connection.getDisplayName());
                } else {
                    connectorProperties.setConnectorName(connection.getQualifiedName());
                }
            }
            connectorProperties.setConnectorUserId(connection.getUserId());
            if (connection.getEndpoint() != null) {
                connectorProperties.setNetworkAddress(connection.getEndpoint().getAddress());
            }
            if (connection instanceof VirtualConnection && (virtualConnection = (VirtualConnection)connection).getEmbeddedConnections() != null) {
                ArrayList<OMAGConnectorProperties> nestedConnectors = new ArrayList<OMAGConnectorProperties>();
                for (EmbeddedConnection embeddedConnection : virtualConnection.getEmbeddedConnections()) {
                    if (embeddedConnection == null || embeddedConnection.getEmbeddedConnection() == null) continue;
                    nestedConnectors.add(this.getConnectorProperties(embeddedConnection.getDisplayName(), embeddedConnection.getEmbeddedConnection()));
                }
                connectorProperties.setNestedConnectors(nestedConnectors);
            }
        }
        return connectorProperties;
    }

    public Map<String, Object> getConfigurationProperties(String connectorName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        assert (this.integrationDaemonClient != null);
        return this.integrationDaemonClient.getConfigurationProperties(this.clientUserId, connectorName);
    }

    public void updateConfigurationProperties(String connectorName, boolean isMergeUpdate, Map<String, Object> configurationProperties) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        assert (this.integrationDaemonClient != null);
        this.integrationDaemonClient.updateConfigurationProperties(this.clientUserId, connectorName, isMergeUpdate, configurationProperties);
    }

    public void updateEndpointNetworkAddress(String connectorName, String networkAddress) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        assert (this.integrationDaemonClient != null);
        this.integrationDaemonClient.updateEndpointNetworkAddress(this.clientUserId, connectorName, networkAddress);
    }

    public void updateConnectorConnection(String connectorName, Connection connection) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        assert (this.integrationDaemonClient != null);
        this.integrationDaemonClient.updateConnectorConnection(this.clientUserId, connectorName, connection);
    }

    public void refreshConnector(String connectorName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        assert (this.integrationDaemonClient != null);
        this.integrationDaemonClient.refreshConnector(this.clientUserId, connectorName);
    }

    public void refreshConnectors() throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        assert (this.integrationDaemonClient != null);
        this.integrationDaemonClient.refreshConnectors(this.clientUserId);
    }

    public void restartConnector(String connectorName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        assert (this.integrationDaemonClient != null);
        this.integrationDaemonClient.restartConnector(this.clientUserId, connectorName);
    }

    public void restartConnectors() throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        assert (this.integrationDaemonClient != null);
        this.integrationDaemonClient.restartConnectors(this.clientUserId);
    }

    public void refreshIntegrationGroupConfig(String integrationGroupName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        assert (this.integrationDaemonClient != null);
        this.integrationDaemonClient.refreshConfig(this.clientUserId, integrationGroupName);
    }

    public void publishOpenLineageEvent(String event) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        assert (this.openLineageClient != null);
        this.openLineageClient.publishOpenLineageEvent(this.clientUserId, event);
    }

    public void refreshEngineConfig(String governanceEngineName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        assert (this.engineHostClient != null);
        this.engineHostClient.refreshConfig(this.clientUserId, governanceEngineName);
    }

    public void refreshEngineConfig() throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        assert (this.engineHostClient != null);
        this.engineHostClient.refreshConfig(this.clientUserId);
    }

    public boolean connectToCohort(String cohortName) throws InvalidParameterException, RepositoryErrorException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        assert (this.metadataHighwayServicesClient != null);
        return this.metadataHighwayServicesClient.connectToCohort(this.clientUserId, cohortName);
    }

    public boolean disconnectFromCohort(String cohortName) throws InvalidParameterException, RepositoryErrorException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        assert (this.metadataHighwayServicesClient != null);
        return this.metadataHighwayServicesClient.disconnectFromCohort(this.clientUserId, cohortName);
    }

    public boolean unregisterFromCohort(String cohortName) throws InvalidParameterException, RepositoryErrorException, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException {
        assert (this.metadataHighwayServicesClient != null);
        return this.metadataHighwayServicesClient.unregisterFromCohort(this.clientUserId, cohortName);
    }
}

