/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.AuditLogRecordSeverityLevel;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageSet;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogRecordSeverity;

public enum OMAGConnectorAuditCode implements AuditLogMessageSet
{
    UNEXPECTED_EXCEPTION("OMAG-CONNECTORS-0001", AuditLogRecordSeverityLevel.EXCEPTION, "The {0} Egeria Connector received an unexpected exception {1} during method {2}; the error message was: {3}", "The connector is unable to connector the the OMAG Infrastructure.", "Use the details from the error message to determine the cause of the error and retry the request once it is resolved."),
    EGERIA_CONNECTOR_START("OMAG-CONNECTORS-0002", AuditLogRecordSeverityLevel.INFO, "The {0} Egeria Connector has been started and will call the platforms with userId {1}.  The monitored platforms are: {2}", "The connector is designed to catalog details of Software Server Platforms that have the deployedImplementationType property set to 'OMAG Server Platform'.", "No specific action is required.  This message is to confirm the start of the integration connector."),
    UNKNOWN_PLATFORM("OMAG-CONNECTORS-0003", AuditLogRecordSeverityLevel.ERROR, "The {0} integration connector is not able to retrieve platform {1} ({2}) from the catalog", "The connector continues to catalog platforms.", "Determine why this platform is not catalogued."),
    CONNECTOR_STOPPING("OMAG-CONNECTORS-0004", AuditLogRecordSeverityLevel.INFO, "The {0} integration connector has stopped its platform monitoring and is shutting down", "The connector is disconnecting.", "No action is required unless there are errors that follow indicating that there were problems shutting down."),
    NEW_SERVER("OMAG-CONNECTORS-0005", AuditLogRecordSeverityLevel.INFO, "The {0} integration connector has created a new {1} server element {2} for server {3} on platform {4}", "The connector is has catalogued a new server.", "No action is required unless there are errors that follow indicating that there were problems with the new definition.");

    private final String logMessageId;
    private final AuditLogRecordSeverityLevel severity;
    private final String logMessage;
    private final String systemAction;
    private final String userAction;

    private OMAGConnectorAuditCode(String messageId, AuditLogRecordSeverityLevel severity, String message, String systemAction, String userAction) {
        this.logMessageId = messageId;
        this.severity = severity;
        this.logMessage = message;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public AuditLogMessageDefinition getMessageDefinition() {
        return new AuditLogMessageDefinition(this.logMessageId, (AuditLogRecordSeverity)this.severity, this.logMessage, this.systemAction, this.userAction);
    }

    public AuditLogMessageDefinition getMessageDefinition(String ... params) {
        AuditLogMessageDefinition messageDefinition = new AuditLogMessageDefinition(this.logMessageId, (AuditLogRecordSeverity)this.severity, this.logMessage, this.systemAction, this.userAction);
        messageDefinition.setMessageParameters(params);
        return messageDefinition;
    }

    public String toString() {
        return "OMAGConnectorAuditCode{logMessageId='" + this.logMessageId + "', severity=" + this.severity + ", logMessage='" + this.logMessage + "', systemAction='" + this.systemAction + "', userAction='" + this.userAction + "'}";
    }
}

