/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageSet;

public enum OMAGConnectorErrorCode implements ExceptionMessageSet
{
    NULL_URL(400, "OMAG-CONNECTORS-400-001", "Egeria connector {0} has been configured without the URL to the OMAG Server Platform", "The connector is unable to contact the OMAG Infrastructure.", "The Platform URL Root is configured in the connector's connection endpoint in the address property.  Typically it is the host name and port where the OMAG Server Platform is running."),
    NULL_SERVER_NAME(400, "OMAG-CONNECTORS-400-002", "Egeria connector {0} has been configured without the name of the OMAG Server to call", "The connector is unable to contact the OMAG Server.", "The server's name is configured in the connector's connection additionalProperties in the serverName property."),
    UNEXPECTED_EXCEPTION(500, "OMAG-CONNECTORS-500-001", "The {0} Egeria connector received an unexpected exception {1} during method {2}; the error message was: {3}", "The connector is unable to contact the OMAG Infrastructure.", "Use the details from the error message to determine the cause of the error and retry the request once it is resolved.");

    private final int httpErrorCode;
    private final String errorMessageId;
    private final String errorMessage;
    private final String systemAction;
    private final String userAction;

    private OMAGConnectorErrorCode(int httpErrorCode, String errorMessageId, String errorMessage, String systemAction, String userAction) {
        this.httpErrorCode = httpErrorCode;
        this.errorMessageId = errorMessageId;
        this.errorMessage = errorMessage;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public ExceptionMessageDefinition getMessageDefinition() {
        return new ExceptionMessageDefinition(this.httpErrorCode, this.errorMessageId, this.errorMessage, this.systemAction, this.userAction);
    }

    public ExceptionMessageDefinition getMessageDefinition(String ... params) {
        ExceptionMessageDefinition messageDefinition = new ExceptionMessageDefinition(this.httpErrorCode, this.errorMessageId, this.errorMessage, this.systemAction, this.userAction);
        messageDefinition.setMessageParameters(params);
        return messageDefinition;
    }

    public String toString() {
        return "ErrorCode{httpErrorCode=" + this.httpErrorCode + ", errorMessageId='" + this.errorMessageId + "', errorMessage='" + this.errorMessage + "', systemAction='" + this.systemAction + "', userAction='" + this.userAction + "'}";
    }
}

