/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.platform.catalog;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.odpi.openmetadata.accessservices.itinfrastructure.api.ITInfrastructureEventListener;
import org.odpi.openmetadata.accessservices.itinfrastructure.events.ITInfrastructureOutTopicEvent;
import org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.control.EgeriaDeployedImplementationType;
import org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.control.EgeriaSoftwareServerTemplateDefinition;
import org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.control.OMAGServerPlatformConfigurationProperty;
import org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.ffdc.OMAGConnectorAuditCode;
import org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.ffdc.OMAGConnectorErrorCode;
import org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.platform.OMAGServerPlatformConnector;
import org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.properties.OMAGServerPlatformProperties;
import org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.properties.OMAGServerProperties;
import org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.servers.EngineHostProvider;
import org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.servers.IntegrationDaemonProvider;
import org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.servers.MetadataAccessServerProvider;
import org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.servers.OMAGServerProvider;
import org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.servers.ViewServerProvider;
import org.odpi.openmetadata.adminservices.configuration.registration.ServerTypeClassification;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.integration.context.OpenMetadataAccess;
import org.odpi.openmetadata.frameworks.openmetadata.controls.PlaceholderProperty;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.DeploymentElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementControlHeader;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementHeader;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.SoftwareServerElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.SoftwareServerPlatformElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.assets.infrastructure.SoftwareServerProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.integrationservices.infrastructure.connector.InfrastructureIntegratorConnector;

public class OMAGServerPlatformCatalogConnector
extends InfrastructureIntegratorConnector
implements ITInfrastructureEventListener {
    List<PlatformDetails> monitoredPlatforms = new ArrayList<PlatformDetails>();
    String clientUserId = "garygeeke";
    final IntegrationDaemonProvider integrationDaemonProvider = new IntegrationDaemonProvider();
    final EngineHostProvider engineHostProvider = new EngineHostProvider();
    final MetadataAccessServerProvider metadataAccessServerProvider = new MetadataAccessServerProvider();
    final ViewServerProvider viewServerProvider = new ViewServerProvider();
    final OMAGServerProvider omagServerProvider = new OMAGServerProvider();

    public void start() throws ConnectorCheckedException {
        super.start();
        String methodName = "start";
        if (this.connectionProperties.getUserId() != null) {
            this.clientUserId = this.connectionProperties.getUserId();
        }
        try {
            super.getContext().registerListener((ITInfrastructureEventListener)this);
            super.getContext().setInfrastructureManagerIsHome(false);
        }
        catch (Exception error) {
            throw new ConnectorCheckedException(OMAGConnectorErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), "start", error.getMessage()), ((Object)((Object)this)).getClass().getName(), "start", (Throwable)error);
        }
        if (this.auditLog != null) {
            this.auditLog.logMessage("start", OMAGConnectorAuditCode.EGERIA_CONNECTOR_START.getMessageDefinition(this.connectorName, this.clientUserId, this.monitoredPlatforms.toString()));
        }
    }

    public void refresh() throws ConnectorCheckedException {
        String methodName = "refresh";
        try {
            int startFrom = 0;
            List softwarePlatforms = super.getContext().findSoftwareServerPlatforms(".*", new Date(), startFrom, super.getContext().getMaxPageSize());
            while (softwarePlatforms != null) {
                for (SoftwareServerPlatformElement softwarePlatform : softwarePlatforms) {
                    if (softwarePlatform == null) continue;
                    this.assessElementForMonitoring(softwarePlatform.getElementHeader(), softwarePlatform.getProperties().getName(), softwarePlatform.getProperties().getDeployedImplementationType());
                }
                softwarePlatforms = super.getContext().findSoftwareServerPlatforms(".*", new Date(), startFrom += super.getContext().getMaxPageSize(), super.getContext().getMaxPageSize());
            }
            this.processPlatforms();
        }
        catch (Exception error) {
            this.auditLog.logMessage("refresh", OMAGConnectorAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), "refresh", error.getMessage()));
            throw new ConnectorCheckedException(OMAGConnectorErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), "refresh", error.getMessage()), ((Object)((Object)this)).getClass().getName(), "refresh", (Throwable)error);
        }
    }

    public void processEvent(ITInfrastructureOutTopicEvent event) {
        if (event.getElementProperties() != null && event.getElementProperties().get(OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name) != null) {
            Object nameProperty = event.getElementProperties().get(OpenMetadataProperty.NAME.name);
            if (nameProperty == null) {
                this.assessElementForMonitoring(event.getElementHeader(), null, event.getElementProperties().get(OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name).toString());
            } else {
                this.assessElementForMonitoring(event.getElementHeader(), nameProperty.toString(), event.getElementProperties().get(OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name).toString());
            }
        }
    }

    private synchronized void assessElementForMonitoring(ElementHeader elementHeader, String displayName, String deployedImplementationType) {
        String methodName = "assessElementForMonitoring";
        if (EgeriaDeployedImplementationType.OMAG_SERVER_PLATFORM.getDeployedImplementationType().equals(deployedImplementationType) && this.propertyHelper.isTypeOf((ElementControlHeader)elementHeader, OpenMetadataType.SOFTWARE_SERVER_PLATFORM.typeName) && !this.propertyHelper.isClassified(elementHeader, OpenMetadataType.TEMPLATE_CLASSIFICATION.typeName)) {
            boolean alreadyMonitored = false;
            for (PlatformDetails platformDetails : this.monitoredPlatforms) {
                if (!elementHeader.getGUID().equals(platformDetails.platformGUID)) continue;
                alreadyMonitored = true;
                break;
            }
            if (!alreadyMonitored) {
                try {
                    Connector connector = super.getContext().getConnectedAssetContext().getConnectorToAsset(elementHeader.getGUID(), this.auditLog);
                    if (connector instanceof OMAGServerPlatformConnector) {
                        OMAGServerPlatformConnector omagServerPlatformConnector = (OMAGServerPlatformConnector)connector;
                        omagServerPlatformConnector.start();
                        PlatformDetails platformDetails = new PlatformDetails();
                        platformDetails.platformGUID = elementHeader.getGUID();
                        platformDetails.platformConnector = omagServerPlatformConnector;
                        platformDetails.platformDisplayName = displayName;
                        platformDetails.platformRootURL = omagServerPlatformConnector.getConnection().getEndpoint().getAddress();
                        this.monitoredPlatforms.add(platformDetails);
                    }
                }
                catch (Exception error) {
                    this.auditLog.logException("assessElementForMonitoring", OMAGConnectorAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), "assessElementForMonitoring", error.getMessage()), (Throwable)error);
                }
            }
        }
    }

    private synchronized void processPlatforms() throws Exception {
        String methodName = "processPlatforms";
        for (PlatformDetails platformDetails : this.monitoredPlatforms) {
            OMAGServerPlatformProperties platformProperties;
            if (platformDetails == null || (platformProperties = platformDetails.platformConnector.getPlatformReport()).getOMAGServers() == null) continue;
            HashMap<String, OMAGServerProperties> knownServerMap = new HashMap<String, OMAGServerProperties>();
            ArrayList<String> processedServers = new ArrayList<String>();
            for (OMAGServerProperties omagServerProperties : platformProperties.getOMAGServers()) {
                if (omagServerProperties == null) continue;
                knownServerMap.put(omagServerProperties.getServerName(), omagServerProperties);
            }
            int startFrom = 0;
            List deployedSoftwareServers = super.getContext().getDeployedITAssets(platformDetails.platformGUID, new Date(), startFrom, super.getContext().getMaxPageSize());
            while (deployedSoftwareServers != null) {
                for (DeploymentElement deploymentElement : deployedSoftwareServers) {
                    OMAGServerProperties omagServerProperties;
                    if (deploymentElement == null || deploymentElement.getAssetElement() == null || deploymentElement.getAssetElement().getProperties() == null || deploymentElement.getAssetElement().getProperties().getName() == null || (omagServerProperties = (OMAGServerProperties)knownServerMap.get(deploymentElement.getAssetElement().getProperties().getName())) == null) continue;
                    processedServers.add(deploymentElement.getAssetElement().getProperties().getName());
                }
                deployedSoftwareServers = super.getContext().getDeployedITAssets(platformDetails.platformGUID, new Date(), startFrom += super.getContext().getMaxPageSize(), super.getContext().getMaxPageSize());
            }
            for (OMAGServerProperties omagServerProperties : knownServerMap.values()) {
                if (omagServerProperties == null) continue;
                String qualifiedName = this.getServerQualifiedName(omagServerProperties.getServerId(), omagServerProperties.getServerName());
                if (processedServers.contains(omagServerProperties.getServerName())) continue;
                String matchingServerGUID = null;
                List softwareServerElements = super.getContext().getSoftwareServersByName(qualifiedName, null, 0, 0);
                if (softwareServerElements != null) {
                    for (SoftwareServerElement softwareServerElement : softwareServerElements) {
                        if (softwareServerElement == null) continue;
                        matchingServerGUID = softwareServerElement.getElementHeader().getGUID();
                        break;
                    }
                }
                if (matchingServerGUID == null) {
                    matchingServerGUID = this.catalogServer(omagServerProperties, platformProperties);
                    this.auditLog.logMessage("processPlatforms", OMAGConnectorAuditCode.NEW_SERVER.getMessageDefinition(this.connectorName, omagServerProperties.getServerType(), matchingServerGUID, omagServerProperties.getServerName(), platformProperties.getPlatformURLRoot()));
                }
                super.getContext().deployITAsset(matchingServerGUID, platformDetails.platformGUID, null);
            }
        }
    }

    private String getServerQualifiedName(String serverId, String serverName) {
        return serverName + " [" + serverId + "]";
    }

    private SoftwareServerProperties getSoftwareServerProperties(OMAGServerProperties omagServerProperties, String platformOrigin) {
        SoftwareServerProperties softwareServerProperties = new SoftwareServerProperties();
        softwareServerProperties.setQualifiedName(this.getServerQualifiedName(omagServerProperties.getServerId(), omagServerProperties.getServerName()));
        softwareServerProperties.setName(omagServerProperties.getServerName());
        softwareServerProperties.setResourceDescription(omagServerProperties.getDescription());
        softwareServerProperties.setSoftwareServerSource("Egeria Community");
        softwareServerProperties.setSoftwareServerVersion(platformOrigin);
        softwareServerProperties.setSoftwareServerUserId(omagServerProperties.getUserId());
        softwareServerProperties.setDeployedImplementationType(this.getServerDeployedImplementationType(omagServerProperties.getServerType()));
        HashMap<String, String> additionalProperties = new HashMap<String, String>();
        additionalProperties.put("organizationName", omagServerProperties.getOrganizationName());
        additionalProperties.put("serverId", omagServerProperties.getServerId());
        additionalProperties.put("maxPageSize", Integer.toString(omagServerProperties.getMaxPageSize()));
        additionalProperties.put("serverType", omagServerProperties.getServerType());
        softwareServerProperties.setAdditionalProperties(additionalProperties);
        return softwareServerProperties;
    }

    private String getServerDeployedImplementationType(String serverType) {
        if (ServerTypeClassification.INTEGRATION_DAEMON.getServerTypeName().equals(serverType)) {
            return EgeriaDeployedImplementationType.INTEGRATION_DAEMON.getDeployedImplementationType();
        }
        if (ServerTypeClassification.ENGINE_HOST.getServerTypeName().equals(serverType)) {
            return EgeriaDeployedImplementationType.ENGINE_HOST.getDeployedImplementationType();
        }
        if (ServerTypeClassification.METADATA_ACCESS_STORE.getServerTypeName().equals(serverType) || ServerTypeClassification.METADATA_ACCESS_POINT.getServerTypeName().equals(serverType) || ServerTypeClassification.METADATA_ACCESS_SERVER.getServerTypeName().equals(serverType)) {
            return EgeriaDeployedImplementationType.METADATA_ACCESS_SERVER.getDeployedImplementationType();
        }
        if (ServerTypeClassification.VIEW_SERVER.getServerTypeName().equals(serverType)) {
            return EgeriaDeployedImplementationType.VIEW_SERVER.getDeployedImplementationType();
        }
        return EgeriaDeployedImplementationType.OMAG_SERVER.getDeployedImplementationType();
    }

    private String getTemplateGUID(String serverType) {
        if (ServerTypeClassification.INTEGRATION_DAEMON.getServerTypeName().equals(serverType)) {
            return EgeriaSoftwareServerTemplateDefinition.INTEGRATION_DAEMON_TEMPLATE.getTemplateGUID();
        }
        if (ServerTypeClassification.ENGINE_HOST.getServerTypeName().equals(serverType)) {
            return EgeriaSoftwareServerTemplateDefinition.ENGINE_HOST_TEMPLATE.getTemplateGUID();
        }
        if (ServerTypeClassification.METADATA_ACCESS_STORE.getServerTypeName().equals(serverType) || ServerTypeClassification.METADATA_ACCESS_POINT.getServerTypeName().equals(serverType) || ServerTypeClassification.METADATA_ACCESS_SERVER.getServerTypeName().equals(serverType)) {
            return EgeriaSoftwareServerTemplateDefinition.METADATA_ACCESS_SERVER_TEMPLATE.getTemplateGUID();
        }
        if (ServerTypeClassification.VIEW_SERVER.getServerTypeName().equals(serverType)) {
            return EgeriaSoftwareServerTemplateDefinition.VIEW_SERVER_TEMPLATE.getTemplateGUID();
        }
        return EgeriaSoftwareServerTemplateDefinition.OMAG_SERVER_PLATFORM_TEMPLATE.getTemplateGUID();
    }

    private String getServerConnectorTypeGUID(String serverType) {
        if (ServerTypeClassification.INTEGRATION_DAEMON.getServerTypeName().equals(serverType)) {
            return this.integrationDaemonProvider.getConnectorType().getGUID();
        }
        if (ServerTypeClassification.ENGINE_HOST.getServerTypeName().equals(serverType)) {
            return this.engineHostProvider.getConnectorType().getGUID();
        }
        if (ServerTypeClassification.METADATA_ACCESS_STORE.getServerTypeName().equals(serverType) || ServerTypeClassification.METADATA_ACCESS_POINT.getServerTypeName().equals(serverType) || ServerTypeClassification.METADATA_ACCESS_SERVER.getServerTypeName().equals(serverType)) {
            return this.metadataAccessServerProvider.getConnectorType().getGUID();
        }
        if (ServerTypeClassification.VIEW_SERVER.getServerTypeName().equals(serverType)) {
            return this.viewServerProvider.getConnectorType().getGUID();
        }
        return this.omagServerProvider.getConnectorType().getGUID();
    }

    private String catalogServer(OMAGServerProperties omagServerProperties, OMAGServerPlatformProperties platformProperties) throws ConnectorCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        OpenMetadataAccess openMetadataAccess = super.getContext().getIntegrationGovernanceContext().getOpenMetadataAccess();
        String templateGUID = this.getTemplateGUID(omagServerProperties.getServerType());
        HashMap<String, String> placeholderProperties = new HashMap<String, String>();
        placeholderProperties.put(PlaceholderProperty.SERVER_NETWORK_ADDRESS.getName(), platformProperties.getPlatformURLRoot());
        placeholderProperties.put(PlaceholderProperty.SERVER_NAME.getName(), omagServerProperties.getServerName());
        placeholderProperties.put(PlaceholderProperty.SECRETS_STORE.getName(), super.getStringConfigurationProperty(OMAGServerPlatformConfigurationProperty.SECRETS_STORE.getName(), this.connectionProperties.getConfigurationProperties()));
        placeholderProperties.put(PlaceholderProperty.VERSION_IDENTIFIER.getName(), platformProperties.getPlatformOrigin());
        placeholderProperties.put(PlaceholderProperty.DESCRIPTION.getName(), omagServerProperties.getDescription());
        placeholderProperties.put(PlaceholderProperty.CONNECTION_USER_ID.getName(), omagServerProperties.getUserId());
        return openMetadataAccess.createMetadataElementFromTemplate(OpenMetadataType.SOFTWARE_SERVER.typeName, null, true, null, null, templateGUID, null, placeholderProperties, null, null, null, false);
    }

    static class PlatformDetails {
        String platformRootURL = null;
        String platformGUID = null;
        String platformDisplayName = null;
        OMAGServerPlatformConnector platformConnector = null;

        PlatformDetails() {
        }

        public String toString() {
            return "PlatformDetails{, platformGUID='" + this.platformGUID + "', platformDisplayName='" + this.platformDisplayName + "'}";
        }
    }
}

