/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.integration.elasticsearch;

import java.util.Map;
import org.odpi.openmetadata.adapters.connectors.integration.elasticsearch.ffdc.ElasticsearchIntegrationConnectorAuditCode;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.EndpointProperties;
import org.odpi.openmetadata.integrationservices.search.connector.SearchIntegratorConnector;
import org.odpi.openmetadata.integrationservices.search.connector.SearchIntegratorContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchIntegrationConnector
extends SearchIntegratorConnector {
    private static final Logger log = LoggerFactory.getLogger(ElasticsearchIntegrationConnector.class);
    private String targetRootURL = null;
    private SearchIntegratorContext myContext = null;

    public void initialize(String connectorInstanceId, ConnectionProperties connectionProperties) {
        super.initialize(connectorInstanceId, connectionProperties);
        EndpointProperties endpoint = connectionProperties.getEndpoint();
        if (endpoint != null) {
            this.targetRootURL = endpoint.getAddress();
        }
        Map configurationProperties = connectionProperties.getConfigurationProperties();
    }

    public void start() throws ConnectorCheckedException {
        super.start();
        String methodName = "start";
        this.myContext = super.getContext();
    }

    public void refresh() throws ConnectorCheckedException {
        String methodName = "refresh";
    }

    public void disconnect() throws ConnectorCheckedException {
        String methodName = "disconnect";
        log.debug("disconnecting");
        if (this.auditLog != null) {
            this.auditLog.logMessage("disconnect", ElasticsearchIntegrationConnectorAuditCode.CONNECTOR_STOPPING.getMessageDefinition(this.connectorName));
        }
        super.disconnect();
    }
}

