/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.integration.elasticsearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.http.HttpHost;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.odpi.openmetadata.accessservices.assetcatalog.model.AssetCatalogEvent;
import org.odpi.openmetadata.adapters.connectors.integration.elasticsearch.ffdc.ElasticsearchIntegrationConnectorAuditCode;
import org.odpi.openmetadata.adapters.connectors.integration.elasticsearch.ffdc.ElasticsearchIntegratorErrorCode;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.EndpointProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Asset;
import org.odpi.openmetadata.integrationservices.search.connector.SearchIntegratorConnector;
import org.odpi.openmetadata.integrationservices.search.connector.SearchIntegratorContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchIntegrationConnector
extends SearchIntegratorConnector {
    private static final Logger log = LoggerFactory.getLogger(ElasticsearchIntegrationConnector.class);
    private static final String INDEX_NAME = "indexName";
    private static final String ASSETS_INDEX_NAME = "assets";
    private String targetRootURL = null;
    private String targetRootProtocol = null;
    private SearchIntegratorContext myContext = null;
    private RestHighLevelClient client;
    private String indexName = "test";
    private ObjectMapper objectMapper;

    public void initialize(String connectorInstanceId, ConnectionProperties connectionProperties) {
        super.initialize(connectorInstanceId, connectionProperties);
        EndpointProperties endpoint = connectionProperties.getEndpoint();
        if (endpoint != null) {
            this.targetRootURL = endpoint.getAddress();
            this.targetRootProtocol = endpoint.getProtocol();
        }
        Map configurationProperties = connectionProperties.getConfigurationProperties();
        String configuredIndexName = (String)configurationProperties.get(INDEX_NAME);
        this.indexName = Objects.requireNonNullElse(configuredIndexName, ASSETS_INDEX_NAME);
        this.objectMapper = new ObjectMapper();
    }

    public synchronized void start() throws ConnectorCheckedException {
        super.start();
        String methodName = "start";
        this.initializeElasticSearchClient("start");
        this.myContext = super.getContext();
    }

    public synchronized void refresh() throws ConnectorCheckedException {
        String methodName = "refresh";
    }

    public synchronized void disconnect() throws ConnectorCheckedException {
        String methodName = "disconnect";
        log.debug("disconnecting");
        if (this.auditLog != null) {
            this.auditLog.logMessage("disconnect", ElasticsearchIntegrationConnectorAuditCode.CONNECTOR_STOPPING.getMessageDefinition(this.connectorName));
        }
        super.disconnect();
    }

    public void initializeElasticSearchClient(String callingMethodName) throws ConnectorCheckedException {
        int port;
        String[] urlParts = this.targetRootURL.split(":");
        String hostname = urlParts[0];
        try {
            port = Integer.parseInt(urlParts[1]);
        }
        catch (NumberFormatException e) {
            log.debug("received exception trying to determine port " + e.getMessage());
            throw new ConnectorCheckedException(ElasticsearchIntegratorErrorCode.BAD_CONFIG.getMessageDefinition("port", "targetRootURL", callingMethodName, e.getMessage()), ((Object)((Object)this)).getClass().getName(), callingMethodName);
        }
        this.client = new RestHighLevelClient(RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(hostname, port, this.targetRootProtocol)}));
    }

    public void saveAsset(AssetCatalogEvent assetCatalogEvent) {
        Asset asset = assetCatalogEvent.getAsset();
        if (asset == null) {
            return;
        }
        if (asset.getGUID() == null) {
            return;
        }
        log.debug("saving to elasticsearch {}", (Object)asset);
        IndexRequest indexRequest = new IndexRequest(this.indexName);
        try {
            String jsonAsset = this.objectMapper.writeValueAsString((Object)asset);
            indexRequest.id(asset.getGUID()).source(jsonAsset, XContentType.JSON);
            this.client.index(indexRequest, RequestOptions.DEFAULT);
        }
        catch (IOException ioException) {
            String actionDescription = "The client could not write to the Elasticsearch cluster";
            this.auditLog.logException(actionDescription, ElasticsearchIntegrationConnectorAuditCode.IO_EXCEPTION.getMessageDefinition(), (Throwable)ioException);
        }
    }
}

