/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.enginehostservices.client;

import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.governanceservers.enginehostservices.client.rest.EngineHostRESTClient;
import org.odpi.openmetadata.governanceservers.enginehostservices.properties.GovernanceEngineSummary;
import org.odpi.openmetadata.governanceservers.enginehostservices.rest.GovernanceEngineSummariesResponse;
import org.odpi.openmetadata.governanceservers.enginehostservices.rest.GovernanceEngineSummaryResponse;

public class EngineHostClient {
    private String serverName;
    private String serverPlatformRootURL;
    private EngineHostRESTClient restClient;
    private InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private RESTExceptionHandler exceptionHandler = new RESTExceptionHandler();

    public EngineHostClient(String serverPlatformRootURL, String serverName) throws InvalidParameterException {
        this.serverPlatformRootURL = serverPlatformRootURL;
        this.serverName = serverName;
        this.restClient = new EngineHostRESTClient(serverName, serverPlatformRootURL);
    }

    public EngineHostClient(String serverPlatformRootURL, String serverName, String userId, String password) throws InvalidParameterException {
        this.serverPlatformRootURL = serverPlatformRootURL;
        this.serverName = serverName;
        this.restClient = new EngineHostRESTClient(serverName, serverPlatformRootURL, userId, password);
    }

    GovernanceEngineSummary getGovernanceEngineSummary(String userId, String governanceEngineName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceEngineSummaries";
        String urlTemplate = "/servers/{0}/open-metadata/engine-host-services/users/{1}/governance-engines/{2}/summary";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceEngineSummaries");
        GovernanceEngineSummaryResponse restResult = this.restClient.callGovernanceEngineSummaryGetRESTCall("getGovernanceEngineSummaries", this.serverPlatformRootURL + "/servers/{0}/open-metadata/engine-host-services/users/{1}/governance-engines/{2}/summary", this.serverName, userId, governanceEngineName);
        this.exceptionHandler.detectAndThrowInvalidParameterException((FFDCResponse)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException((FFDCResponse)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponse)restResult);
        return restResult.getGovernanceEngineSummary();
    }

    List<GovernanceEngineSummary> getGovernanceEngineSummaries(String userId, String serviceURLMarker) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceEngineSummaries";
        String urlTemplate = "/servers/{0}/open-metadata/engine-host-services/users/{1}/{2}/governance-engines/summary";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceEngineSummaries");
        GovernanceEngineSummariesResponse restResult = this.restClient.callGovernanceEngineSummariesGetRESTCall("getGovernanceEngineSummaries", this.serverPlatformRootURL + "/servers/{0}/open-metadata/engine-host-services/users/{1}/{2}/governance-engines/summary", this.serverName, userId, serviceURLMarker);
        this.exceptionHandler.detectAndThrowInvalidParameterException((FFDCResponse)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException((FFDCResponse)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponse)restResult);
        return restResult.getGovernanceEngineSummaries();
    }

    List<GovernanceEngineSummary> getGovernanceEngineSummaries(String userId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceEngineSummaries";
        String urlTemplate = "/servers/{0}/open-metadata/engine-host-services/users/{1}/governance-engines/summary";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceEngineSummaries");
        GovernanceEngineSummariesResponse restResult = this.restClient.callGovernanceEngineSummariesGetRESTCall("getGovernanceEngineSummaries", this.serverPlatformRootURL + "/servers/{0}/open-metadata/engine-host-services/users/{1}/governance-engines/summary", this.serverName, userId);
        this.exceptionHandler.detectAndThrowInvalidParameterException((FFDCResponse)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException((FFDCResponse)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponse)restResult);
        return restResult.getGovernanceEngineSummaries();
    }

    public void refreshConfig(String userId, String governanceEngineName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "refreshConfig";
        String governanceEngineParameterName = "governanceEngineName";
        String urlTemplate = "/servers/{0}/open-metadata/engine-host-services/users/{1}/governance-engines/{2}/refresh-config";
        this.invalidParameterHandler.validateUserId(userId, "refreshConfig");
        this.invalidParameterHandler.validateName(governanceEngineName, "governanceEngineName", "refreshConfig");
        this.restClient.callVoidGetRESTCall("refreshConfig", this.serverPlatformRootURL + "/servers/{0}/open-metadata/engine-host-services/users/{1}/governance-engines/{2}/refresh-config", new Object[]{this.serverName, userId, governanceEngineName});
    }
}

