/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.enginehostservices.admin;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.governanceengine.client.GovernanceEngineClient;
import org.odpi.openmetadata.accessservices.governanceengine.properties.GovernanceEngineProperties;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CompletionStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceActionStatus;

public abstract class GovernanceServiceHandler
implements Runnable {
    protected GovernanceEngineProperties governanceEngineProperties;
    protected String governanceEngineGUID;
    protected String engineHostUserId;
    protected String governanceServiceGUID;
    protected String governanceServiceName;
    private GovernanceEngineClient governanceActionClient;
    protected Connector governanceService;
    protected String governanceActionGUID;
    protected String requestType;
    protected AuditLog auditLog;

    protected GovernanceServiceHandler(GovernanceEngineProperties governanceEngineProperties, String governanceEngineGUID, String engineHostUserId, String governanceActionGUID, GovernanceEngineClient governanceActionClient, String requestType, String governanceServiceGUID, String governanceServiceName, Connector governanceService, AuditLog auditLog) {
        this.governanceEngineProperties = governanceEngineProperties;
        this.governanceEngineGUID = governanceEngineGUID;
        this.engineHostUserId = engineHostUserId;
        this.governanceServiceGUID = governanceServiceGUID;
        this.governanceServiceName = governanceServiceName;
        this.governanceActionGUID = governanceActionGUID;
        this.governanceActionClient = governanceActionClient;
        this.requestType = requestType;
        this.governanceService = governanceService;
        this.auditLog = auditLog;
    }

    public String getGovernanceServiceName() {
        return this.governanceServiceName;
    }

    public String getGovernanceServiceGUID() {
        return this.governanceServiceGUID;
    }

    public String getGovernanceEngineName() {
        return this.governanceEngineProperties.getQualifiedName();
    }

    public void updateActionTargetStatus(String actionTargetGUID, GovernanceActionStatus status, Date startDate, Date completionDate) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (this.governanceActionGUID != null) {
            this.governanceActionClient.updateActionTargetStatus(this.engineHostUserId, actionTargetGUID, status, startDate, completionDate);
        }
    }

    public void recordCompletionStatus(CompletionStatus status, List<String> outputGuards, Map<String, String> requestParameters, List<String> newActionTargetGUIDs) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (this.governanceActionGUID != null) {
            this.governanceActionClient.recordCompletionStatus(this.engineHostUserId, this.governanceActionGUID, requestParameters, status, outputGuards, newActionTargetGUIDs);
        }
    }

    public void disconnect() throws ConnectorCheckedException {
        if (this.governanceService != null) {
            this.governanceService.disconnect();
        }
    }
}

