/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.enginehostservices.registration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adminservices.configuration.registration.EngineServiceRegistration;

public class OMAGEngineServiceRegistration {
    private static Map<String, EngineServiceRegistration> engineServiceRegistrationMap = new HashMap<String, EngineServiceRegistration>();

    public static synchronized void registerEngineService(EngineServiceRegistration registration) {
        String serviceName;
        if (registration != null && (serviceName = registration.getEngineServiceName()) != null) {
            engineServiceRegistrationMap.put(serviceName, registration);
        }
    }

    public static synchronized List<EngineServiceRegistration> getEngineServiceRegistrationList() {
        ArrayList<EngineServiceRegistration> registrationList = new ArrayList<EngineServiceRegistration>();
        for (EngineServiceRegistration engineServiceRegistration : engineServiceRegistrationMap.values()) {
            if (engineServiceRegistration == null) continue;
            registrationList.add(engineServiceRegistration);
        }
        return registrationList;
    }

    public static synchronized EngineServiceRegistration getEngineServiceRegistration(String urlMarker) {
        if (urlMarker != null) {
            for (EngineServiceRegistration engineServiceRegistration : engineServiceRegistrationMap.values()) {
                if (engineServiceRegistration == null || !urlMarker.equals(engineServiceRegistration.getEngineServiceURLMarker())) continue;
                return engineServiceRegistration;
            }
        }
        return null;
    }
}

