/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.enginehostservices.admin;

import java.util.Map;
import org.odpi.openmetadata.accessservices.governanceengine.metadataelements.RegisteredGovernanceServiceElement;
import org.odpi.openmetadata.accessservices.governanceengine.properties.RegisteredGovernanceService;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBroker;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.governanceservers.enginehostservices.ffdc.EngineHostServicesErrorCode;

public class GovernanceServiceCache {
    private Connector nextGovernanceService;
    private RegisteredGovernanceServiceElement element;
    private RegisteredGovernanceService properties;
    private Map<String, Map<String, String>> requestTypeMapping;
    private AuditLog auditLog;

    GovernanceServiceCache(String governanceServerName, String governanceEngineName, RegisteredGovernanceServiceElement element, AuditLog auditLog) throws InvalidParameterException, PropertyServerException {
        String methodName = "GovernanceServiceCache constructor";
        this.auditLog = auditLog;
        if (element == null || element.getElementHeader() == null || element.getProperties() == null) {
            throw new PropertyServerException(EngineHostServicesErrorCode.NULL_GOVERNANCE_SERVICE.getMessageDefinition(new String[]{"GovernanceServiceCache constructor", governanceEngineName, governanceServerName}), this.getClass().getName(), "GovernanceServiceCache constructor");
        }
        this.element = element;
        this.properties = element.getProperties();
        this.requestTypeMapping = this.properties.getRequestTypes();
        this.getNextGovernanceService();
    }

    public String getGovernanceServiceName() {
        return this.properties.getQualifiedName();
    }

    public String getGovernanceServiceGUID() {
        return this.element.getElementHeader().getGUID();
    }

    public Map<String, String> getRequestParameters(String requestType) {
        return this.requestTypeMapping.get(requestType);
    }

    public synchronized Connector getNextGovernanceService() throws InvalidParameterException, PropertyServerException {
        Connector returnValue = this.nextGovernanceService;
        try {
            ConnectorBroker connectorBroker = new ConnectorBroker(this.auditLog);
            this.nextGovernanceService = connectorBroker.getConnector(this.properties.getConnection());
        }
        catch (ConnectionCheckedException error) {
            throw new InvalidParameterException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error, this.properties.getQualifiedName() + "GovernanceService Connection");
        }
        catch (ConnectorCheckedException error) {
            throw new PropertyServerException((OCFCheckedExceptionBase)error);
        }
        return returnValue;
    }
}

