/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.enginehostservices.admin;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.governanceengine.client.GovernanceEngineClient;
import org.odpi.openmetadata.accessservices.governanceengine.properties.GovernanceEngineProperties;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CompletionStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceActionStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.NewActionTarget;
import org.odpi.openmetadata.governanceservers.enginehostservices.ffdc.EngineHostServicesAuditCode;

public abstract class GovernanceServiceHandler
implements Runnable {
    protected GovernanceEngineProperties governanceEngineProperties;
    protected String governanceEngineGUID;
    protected String engineHostUserId;
    protected String governanceServiceGUID;
    protected String governanceServiceName;
    private final GovernanceEngineClient governanceActionClient;
    protected Connector governanceService;
    protected String governanceActionGUID;
    protected String requestType;
    protected AuditLog auditLog;

    protected GovernanceServiceHandler(GovernanceEngineProperties governanceEngineProperties, String governanceEngineGUID, String engineHostUserId, String governanceActionGUID, GovernanceEngineClient governanceActionClient, String requestType, String governanceServiceGUID, String governanceServiceName, Connector governanceService, AuditLog auditLog) {
        this.governanceEngineProperties = governanceEngineProperties;
        this.governanceEngineGUID = governanceEngineGUID;
        this.engineHostUserId = engineHostUserId;
        this.governanceServiceGUID = governanceServiceGUID;
        this.governanceServiceName = governanceServiceName;
        this.governanceActionGUID = governanceActionGUID;
        this.governanceActionClient = governanceActionClient;
        this.requestType = requestType;
        this.governanceService = governanceService;
        this.auditLog = auditLog;
    }

    public String getGovernanceServiceName() {
        return this.governanceServiceName;
    }

    public String getGovernanceServiceGUID() {
        return this.governanceServiceGUID;
    }

    public String getGovernanceEngineName() {
        return this.governanceEngineProperties.getQualifiedName();
    }

    public void updateActionTargetStatus(String actionTargetGUID, GovernanceActionStatus status, Date startDate, Date completionDate) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateActionTargetStatus";
        if (this.auditLog != null) {
            String statusString = "<null>";
            String startTime = "<null>";
            String completionTime = "<null>";
            if (status != null) {
                statusString = status.getName();
            }
            if (startDate != null) {
                startTime = startDate.toString();
            }
            if (completionDate != null) {
                completionTime = completionDate.toString();
            }
            this.auditLog.logMessage("updateActionTargetStatus", EngineHostServicesAuditCode.GOVERNANCE_ACTION_TARGET_COMPLETION.getMessageDefinition(new String[]{this.governanceActionGUID, this.governanceServiceName, this.getGovernanceEngineName(), this.requestType, actionTargetGUID, statusString, startTime, completionTime}));
        }
        this.governanceActionClient.updateActionTargetStatus(this.engineHostUserId, actionTargetGUID, status, startDate, completionDate);
    }

    public void recordCompletionStatus(CompletionStatus status, List<String> outputGuards, Map<String, String> requestParameters, List<NewActionTarget> newActionTargets) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "recordCompletionStatus";
        if (this.auditLog != null) {
            String statusString = "<null>";
            String guardsString = "<null>";
            String requestParameterNames = "<null>";
            String actionTargets = "<null>";
            if (status != null) {
                statusString = status.getName();
            }
            if (outputGuards != null) {
                guardsString = outputGuards.toString();
            }
            if (requestParameters != null) {
                requestParameterNames = requestParameters.keySet().toString();
            }
            if (newActionTargets != null) {
                actionTargets = newActionTargets.toString();
            }
            this.auditLog.logMessage("recordCompletionStatus", EngineHostServicesAuditCode.GOVERNANCE_ACTION_RECORD_COMPLETION.getMessageDefinition(new String[]{this.governanceActionGUID, this.governanceServiceName, this.getGovernanceEngineName(), this.requestType, statusString, guardsString, requestParameterNames, actionTargets}));
        }
        this.governanceActionClient.recordCompletionStatus(this.engineHostUserId, this.governanceActionGUID, requestParameters, status, outputGuards, newActionTargets);
    }

    public void disconnect() throws ConnectorCheckedException {
        if (this.governanceService != null) {
            this.governanceService.disconnect();
        }
    }
}

