/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.enginehostservices.admin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.odpi.openmetadata.accessservices.governanceengine.client.GovernanceEngineClient;
import org.odpi.openmetadata.accessservices.governanceengine.client.GovernanceEngineConfigurationClient;
import org.odpi.openmetadata.accessservices.governanceengine.metadataelements.GovernanceActionElement;
import org.odpi.openmetadata.accessservices.governanceengine.metadataelements.GovernanceEngineElement;
import org.odpi.openmetadata.accessservices.governanceengine.metadataelements.RegisteredGovernanceServiceElement;
import org.odpi.openmetadata.accessservices.governanceengine.properties.GovernanceActionProperties;
import org.odpi.openmetadata.accessservices.governanceengine.properties.GovernanceEngineProperties;
import org.odpi.openmetadata.accessservices.governanceengine.properties.RegisteredGovernanceService;
import org.odpi.openmetadata.adminservices.configuration.properties.EngineConfig;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogGovernanceEvent;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ActionTargetElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceActionStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RequestSourceElement;
import org.odpi.openmetadata.governanceservers.enginehostservices.admin.GovernanceServiceCache;
import org.odpi.openmetadata.governanceservers.enginehostservices.admin.GovernanceServiceHandler;
import org.odpi.openmetadata.governanceservers.enginehostservices.ffdc.EngineHostServicesAuditCode;
import org.odpi.openmetadata.governanceservers.enginehostservices.ffdc.EngineHostServicesErrorCode;
import org.odpi.openmetadata.governanceservers.enginehostservices.properties.GovernanceEngineStatus;
import org.odpi.openmetadata.governanceservers.enginehostservices.properties.GovernanceEngineSummary;

public abstract class GovernanceEngineHandler {
    protected String serverName;
    protected String serverUserId;
    protected GovernanceEngineClient serverClient;
    protected String engineUserId;
    protected AuditLog auditLog;
    protected int maxPageSize;
    private final String engineServiceName;
    protected String governanceEngineName;
    protected String governanceEngineGUID = null;
    protected GovernanceEngineProperties governanceEngineProperties = null;
    private GovernanceEngineElement governanceEngineElement = null;
    private String governanceEngineTypeName = null;
    private List<String> governanceEngineSuperTypeNames = null;
    private final GovernanceEngineConfigurationClient configurationClient;
    private final GovernanceServiceCacheMap governanceServiceLookupTable = new GovernanceServiceCacheMap();

    public GovernanceEngineHandler(EngineConfig engineConfig, String serverName, String serverUserId, String engineServiceName, GovernanceEngineConfigurationClient configurationClient, GovernanceEngineClient serverClient, AuditLog auditLog, int maxPageSize) {
        this.engineServiceName = engineServiceName;
        this.governanceEngineName = engineConfig.getEngineQualifiedName();
        this.serverName = serverName;
        this.serverUserId = serverUserId;
        this.engineUserId = engineConfig.getEngineUserId();
        if (this.engineUserId == null) {
            this.engineUserId = serverUserId;
        }
        this.configurationClient = configurationClient;
        this.serverClient = serverClient;
        this.auditLog = auditLog;
        this.maxPageSize = maxPageSize;
    }

    public String getGovernanceEngineName() {
        return this.governanceEngineName;
    }

    public synchronized GovernanceEngineSummary getSummary() {
        GovernanceEngineSummary mySummary = new GovernanceEngineSummary();
        mySummary.setGovernanceEngineName(this.governanceEngineName);
        mySummary.setGovernanceEngineTypeName(this.governanceEngineTypeName);
        mySummary.setGovernanceEngineService(this.engineServiceName);
        mySummary.setGovernanceEngineGUID(this.governanceEngineGUID);
        if (this.governanceEngineProperties != null) {
            mySummary.setGovernanceEngineDescription(this.governanceEngineProperties.getDescription());
        }
        mySummary.setGovernanceRequestTypes(this.governanceServiceLookupTable.getGovernanceRequestTypes());
        mySummary.setGovernanceEngineStatus(GovernanceEngineStatus.ASSIGNED);
        if (this.governanceEngineGUID != null) {
            mySummary.setGovernanceEngineStatus(GovernanceEngineStatus.CONFIGURING);
        }
        if (this.governanceServiceLookupTable.getGovernanceRequestTypes() != null) {
            mySummary.setGovernanceEngineStatus(GovernanceEngineStatus.RUNNING);
        }
        return mySummary;
    }

    public synchronized void refreshConfig() throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "refreshConfig";
        this.governanceEngineElement = this.configurationClient.getGovernanceEngineByName(this.serverUserId, this.governanceEngineName);
        if (this.governanceEngineElement == null || this.governanceEngineElement.getElementHeader() == null || this.governanceEngineElement.getElementHeader().getType() == null || this.governanceEngineElement.getProperties() == null) {
            this.governanceEngineGUID = null;
            this.governanceEngineTypeName = null;
            this.governanceEngineSuperTypeNames = null;
            this.governanceEngineProperties = null;
            throw new PropertyServerException(EngineHostServicesErrorCode.UNKNOWN_GOVERNANCE_ENGINE_CONFIG.getMessageDefinition(new String[]{this.governanceEngineName, this.configurationClient.getConfigurationServerName(), this.serverName}), this.getClass().getName(), "refreshConfig");
        }
        this.governanceEngineGUID = this.governanceEngineElement.getElementHeader().getGUID();
        this.governanceEngineTypeName = this.governanceEngineElement.getElementHeader().getType().getTypeName();
        this.governanceEngineSuperTypeNames = this.governanceEngineElement.getElementHeader().getType().getSuperTypeNames();
        this.governanceEngineProperties = this.governanceEngineElement.getProperties();
        this.refreshAllServiceConfig();
    }

    private void refreshAllServiceConfig() throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "refreshAllServiceConfig";
        String actionDescription = "Retrieve all governance service configuration";
        this.auditLog.logMessage("Retrieve all governance service configuration", EngineHostServicesAuditCode.CLEARING_ALL_GOVERNANCE_SERVICE_CONFIG.getMessageDefinition(new String[]{this.governanceEngineName}));
        this.governanceServiceLookupTable.clear();
        int startingFrom = 0;
        boolean moreToReceive = true;
        while (moreToReceive) {
            List registeredGovernanceServices = this.configurationClient.getRegisteredGovernanceServices(this.serverUserId, this.governanceEngineGUID, startingFrom, this.maxPageSize);
            if (registeredGovernanceServices != null && !registeredGovernanceServices.isEmpty()) {
                for (RegisteredGovernanceServiceElement registeredGovernanceService : registeredGovernanceServices) {
                    this.refreshRegisteredGovernanceService(registeredGovernanceService, null, "refreshAllServiceConfig");
                }
                startingFrom += this.maxPageSize;
                continue;
            }
            moreToReceive = false;
        }
        this.auditLog.logMessage("Retrieve all governance service configuration", EngineHostServicesAuditCode.FINISHED_ALL_GOVERNANCE_SERVICE_CONFIG.getMessageDefinition(new String[]{this.governanceEngineName}));
    }

    public synchronized void refreshServiceConfig(String registeredGovernanceServiceGUID, String specificRequestType) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "refreshServiceConfig";
        if (registeredGovernanceServiceGUID != null) {
            RegisteredGovernanceServiceElement registeredGovernanceServiceElement = this.configurationClient.getRegisteredGovernanceService(this.serverUserId, this.governanceEngineGUID, registeredGovernanceServiceGUID);
            this.refreshRegisteredGovernanceService(registeredGovernanceServiceElement, specificRequestType, "refreshServiceConfig");
        }
    }

    private void refreshRegisteredGovernanceService(RegisteredGovernanceServiceElement registeredGovernanceServiceElement, String specificRequestType, String methodName) throws InvalidParameterException, PropertyServerException {
        RegisteredGovernanceService registeredGovernanceService;
        if (registeredGovernanceServiceElement != null && registeredGovernanceServiceElement.getElementHeader() != null && registeredGovernanceServiceElement.getProperties() != null && (registeredGovernanceService = registeredGovernanceServiceElement.getProperties()).getRequestTypes() != null) {
            Set governanceRequestTypes;
            if (specificRequestType == null) {
                governanceRequestTypes = registeredGovernanceService.getRequestTypes().keySet();
            } else {
                governanceRequestTypes = new HashSet();
                governanceRequestTypes.add(specificRequestType);
            }
            for (String governanceRequestType : governanceRequestTypes) {
                GovernanceServiceCache governanceServiceCache = new GovernanceServiceCache(this.serverName, this.governanceEngineName, registeredGovernanceServiceElement, governanceRequestType, this.auditLog);
                this.governanceServiceLookupTable.put(governanceRequestType, governanceServiceCache);
                this.auditLog.logMessage(methodName, EngineHostServicesAuditCode.SUPPORTED_REQUEST_TYPE.getMessageDefinition(new String[]{this.governanceEngineName, this.serverName, governanceRequestType}));
            }
        }
    }

    protected void validateGovernanceEngineInitialized(String expectedTypeName, String methodName) throws PropertyServerException {
        if (this.governanceEngineProperties == null) {
            throw new PropertyServerException(EngineHostServicesErrorCode.GOVERNANCE_ENGINE_NOT_INITIALIZED.getMessageDefinition(new String[]{this.serverName, this.governanceEngineName}), this.getClass().getName(), methodName);
        }
        if (expectedTypeName.equals(this.governanceEngineTypeName)) {
            return;
        }
        if (this.governanceEngineSuperTypeNames != null && this.governanceEngineSuperTypeNames.contains(expectedTypeName)) {
            return;
        }
        throw new PropertyServerException(EngineHostServicesErrorCode.WRONG_TYPE_OF_GOVERNANCE_ENGINE.getMessageDefinition(new String[]{this.governanceEngineName, this.configurationClient.getConfigurationServerName(), expectedTypeName, this.governanceEngineTypeName, this.serverName}), this.getClass().getName(), methodName);
    }

    protected synchronized GovernanceServiceCache getServiceCache(String governanceRequestType) {
        return this.governanceServiceLookupTable.get(governanceRequestType);
    }

    public void executeGovernanceAction(String governanceActionGUID) {
        String methodName = "executeGovernanceAction";
        try {
            GovernanceActionElement latestGovernanceActionElement = this.serverClient.getGovernanceAction(this.serverUserId, governanceActionGUID);
            GovernanceActionProperties properties = latestGovernanceActionElement.getProperties();
            if (properties.getActionStatus() == GovernanceActionStatus.APPROVED) {
                this.serverClient.claimGovernanceAction(this.serverUserId, governanceActionGUID);
                this.serverClient.updateGovernanceActionStatus(this.serverUserId, governanceActionGUID, GovernanceActionStatus.IN_PROGRESS);
                this.runGovernanceService(governanceActionGUID, properties.getRequestType(), properties.getRequestParameters(), properties.getRequestSourceElements(), properties.getActionTargetElements());
            }
        }
        catch (Exception error) {
            this.auditLog.logException("executeGovernanceAction", EngineHostServicesAuditCode.ACTION_PROCESSING_ERROR.getMessageDefinition(new String[]{"executeGovernanceAction", error.getClass().getName(), governanceActionGUID, error.getMessage()}), (Throwable)error);
        }
    }

    public abstract GovernanceServiceHandler runGovernanceService(String var1, String var2, Map<String, String> var3, List<RequestSourceElement> var4, List<ActionTargetElement> var5) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException;

    public void publishWatchdogEvent(WatchdogGovernanceEvent watchdogGovernanceEvent) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    public void terminate() {
        String actionDescription = "terminate";
        this.auditLog.logMessage("terminate", EngineHostServicesAuditCode.ENGINE_SHUTDOWN.getMessageDefinition(new String[]{this.governanceEngineName, this.serverName}));
        this.governanceEngineElement = null;
        this.governanceEngineGUID = null;
        this.governanceEngineProperties = null;
        this.governanceServiceLookupTable.clear();
    }

    private static class GovernanceServiceCacheMap {
        private volatile Map<String, GovernanceServiceCache> governanceServiceLookupTable = new HashMap<String, GovernanceServiceCache>();

        private GovernanceServiceCacheMap() {
        }

        synchronized void clear() {
            this.governanceServiceLookupTable = new HashMap<String, GovernanceServiceCache>();
        }

        synchronized void put(String governanceRequestType, GovernanceServiceCache governanceServiceCache) {
            this.governanceServiceLookupTable.put(governanceRequestType, governanceServiceCache);
        }

        protected synchronized GovernanceServiceCache get(String governanceRequestType) {
            return this.governanceServiceLookupTable.get(governanceRequestType);
        }

        synchronized List<String> getGovernanceRequestTypes() {
            if (this.governanceServiceLookupTable.isEmpty()) {
                return null;
            }
            return new ArrayList<String>(this.governanceServiceLookupTable.keySet());
        }
    }
}

