/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.enginehostservices.admin;

import java.util.HashMap;
import java.util.Map;
import org.odpi.openmetadata.accessservices.governanceengine.metadataelements.RegisteredGovernanceServiceElement;
import org.odpi.openmetadata.accessservices.governanceengine.properties.RegisteredGovernanceServiceProperties;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBroker;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.governanceservers.enginehostservices.ffdc.EngineHostServicesErrorCode;

public class GovernanceServiceCache {
    private final String governanceServiceGUID;
    private final String governanceServiceName;
    private final String serviceRequestType;
    private final Map<String, String> requestParameters;
    private final Connection serviceConnection;
    private final AuditLog auditLog;
    private Connector nextGovernanceService;

    GovernanceServiceCache(String governanceServerName, String governanceEngineName, RegisteredGovernanceServiceElement element, String requestType, AuditLog auditLog) throws InvalidParameterException, PropertyServerException {
        String methodName = "GovernanceServiceCache constructor";
        this.auditLog = auditLog;
        if (requestType == null || element == null || element.getElementHeader() == null || element.getProperties() == null || element.getProperties().getRequestTypes() == null || element.getProperties().getRequestTypes().isEmpty()) {
            String elementString = "<null>";
            if (element != null) {
                elementString = element.toString();
            }
            throw new PropertyServerException(EngineHostServicesErrorCode.NULL_GOVERNANCE_SERVICE.getMessageDefinition(new String[]{"GovernanceServiceCache constructor", governanceEngineName, governanceServerName, elementString}), this.getClass().getName(), "GovernanceServiceCache constructor");
        }
        this.governanceServiceGUID = element.getElementHeader().getGUID();
        this.governanceServiceName = element.getProperties().getQualifiedName();
        this.serviceConnection = element.getProperties().getConnection();
        RegisteredGovernanceServiceProperties registeredGovernanceServiceProperties = (RegisteredGovernanceServiceProperties)element.getProperties().getRequestTypes().get(requestType);
        this.serviceRequestType = registeredGovernanceServiceProperties.getServiceRequestType() != null ? registeredGovernanceServiceProperties.getServiceRequestType() : requestType;
        this.requestParameters = registeredGovernanceServiceProperties.getRequestParameters();
        this.getNextGovernanceService();
    }

    public String getGovernanceServiceName() {
        return this.governanceServiceName;
    }

    public String getGovernanceServiceGUID() {
        return this.governanceServiceGUID;
    }

    public String getServiceRequestType() {
        return this.serviceRequestType;
    }

    public Map<String, String> getRequestParameters(Map<String, String> suppliedRequestParameters) {
        HashMap<Object, Object> runRequestParameters = this.requestParameters == null ? new HashMap() : new HashMap<String, String>(this.requestParameters);
        if (suppliedRequestParameters != null) {
            runRequestParameters.putAll(suppliedRequestParameters);
        }
        if (runRequestParameters.isEmpty()) {
            runRequestParameters = null;
        }
        return runRequestParameters;
    }

    public synchronized Connector getNextGovernanceService() throws InvalidParameterException, PropertyServerException {
        Connector returnValue = this.nextGovernanceService;
        try {
            ConnectorBroker connectorBroker = new ConnectorBroker(this.auditLog);
            this.nextGovernanceService = connectorBroker.getConnector(this.serviceConnection);
        }
        catch (ConnectionCheckedException error) {
            throw new InvalidParameterException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error, this.governanceServiceName + "GovernanceService Connection");
        }
        catch (ConnectorCheckedException error) {
            throw new PropertyServerException((OCFCheckedExceptionBase)error);
        }
        return returnValue;
    }
}

