/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.enginehostservices.admin;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.governanceengine.client.GovernanceEngineClient;
import org.odpi.openmetadata.accessservices.governanceengine.client.GovernanceEngineConfigurationClient;
import org.odpi.openmetadata.adminservices.configuration.properties.EngineConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.EngineServiceConfig;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.governanceservers.enginehostservices.admin.GovernanceEngineHandler;
import org.odpi.openmetadata.governanceservers.enginehostservices.ffdc.EngineHostServicesAuditCode;
import org.odpi.openmetadata.governanceservers.enginehostservices.ffdc.EngineHostServicesErrorCode;

public abstract class EngineServiceAdmin {
    protected String localServerName = null;
    protected AuditLog auditLog = null;
    protected InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();

    public abstract Map<String, GovernanceEngineHandler> initialize(String var1, String var2, AuditLog var3, String var4, String var5, int var6, GovernanceEngineConfigurationClient var7, GovernanceEngineClient var8, EngineServiceConfig var9) throws OMAGConfigurationErrorException;

    public abstract void shutdown();

    protected String getPartnerServiceRootURL(EngineServiceConfig engineServicesConfig) throws OMAGConfigurationErrorException {
        String accessServiceRootURL = engineServicesConfig.getOMAGServerPlatformRootURL();
        if (accessServiceRootURL == null) {
            String actionDescription = "Validate engine services configuration.";
            String methodName = "getPartnerServiceRootURL";
            this.auditLog.logMessage("Validate engine services configuration.", EngineHostServicesAuditCode.NO_OMAS_SERVER_URL.getMessageDefinition(new String[]{engineServicesConfig.getEngineServiceFullName(), this.localServerName, engineServicesConfig.getEngineServicePartnerOMAS()}));
            throw new OMAGConfigurationErrorException(EngineHostServicesErrorCode.NO_OMAS_SERVER_URL.getMessageDefinition(new String[]{engineServicesConfig.getEngineServiceFullName(), this.localServerName, engineServicesConfig.getEngineServicePartnerOMAS()}), this.getClass().getName(), "getPartnerServiceRootURL");
        }
        return accessServiceRootURL;
    }

    protected void validateConfigDocument(EngineServiceConfig engineServiceConfig) throws InvalidParameterException {
        String methodName = "validateConfigDocument";
        String configPropertyName = "engineServiceConfig";
        String fullServiceNamePropertyName = "engineServiceConfig.engineServiceFullName";
        String serviceNamePropertyName = "engineServiceConfig.engineServiceName";
        String partnerOMASPropertyName = "engineServiceConfig.engineServicePartnerOMAS";
        if (engineServiceConfig == null) {
            throw new InvalidParameterException(EngineHostServicesErrorCode.NULL_SERVICE_CONFIG_VALUE.getMessageDefinition(new String[]{this.localServerName}), this.getClass().getName(), "validateConfigDocument", "engineServiceConfig");
        }
        this.invalidParameterHandler.validateName(engineServiceConfig.getEngineServiceFullName(), "engineServiceConfig.engineServiceFullName", "validateConfigDocument");
        this.invalidParameterHandler.validateName(engineServiceConfig.getEngineServiceName(), "engineServiceConfig.engineServiceName", "validateConfigDocument");
        this.invalidParameterHandler.validateName(engineServiceConfig.getEngineServicePartnerOMAS(), "engineServiceConfig.engineServicePartnerOMAS", "validateConfigDocument");
    }

    protected String getPartnerServiceServerName(EngineServiceConfig engineServiceConfig) throws OMAGConfigurationErrorException {
        String accessServiceServerName = engineServiceConfig.getOMAGServerName();
        if (accessServiceServerName == null) {
            String actionDescription = "Validate engine service configuration.";
            String methodName = "getPartnerServiceServerName";
            this.auditLog.logMessage("Validate engine service configuration.", EngineHostServicesAuditCode.NO_OMAS_SERVER_NAME.getMessageDefinition(new String[]{engineServiceConfig.getEngineServiceFullName(), this.localServerName, engineServiceConfig.getEngineServicePartnerOMAS()}));
            throw new OMAGConfigurationErrorException(EngineHostServicesErrorCode.NO_OMAS_SERVER_NAME.getMessageDefinition(new String[]{engineServiceConfig.getEngineServiceFullName(), this.localServerName, engineServiceConfig.getEngineServicePartnerOMAS()}), this.getClass().getName(), "getPartnerServiceServerName");
        }
        return accessServiceServerName;
    }

    protected List<EngineConfig> getEngines(EngineServiceConfig engineServiceConfig) throws OMAGConfigurationErrorException {
        List engineNames = engineServiceConfig.getEngines();
        if (engineNames == null || engineNames.isEmpty()) {
            String actionDescription = "Validate engine services configuration.";
            String methodName = "getEngines";
            this.auditLog.logMessage("Validate engine services configuration.", EngineHostServicesAuditCode.NO_ENGINES.getMessageDefinition(new String[]{engineServiceConfig.getEngineServiceFullName(), this.localServerName}));
            throw new OMAGConfigurationErrorException(EngineHostServicesErrorCode.NO_ENGINES.getMessageDefinition(new String[]{engineServiceConfig.getEngineServiceFullName(), this.localServerName}), this.getClass().getName(), "getEngines");
        }
        return engineNames;
    }
}

