/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.enginehostservices.admin;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.governanceengine.client.GovernanceEngineClient;
import org.odpi.openmetadata.accessservices.governanceengine.properties.GovernanceEngineProperties;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CompletionStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceActionStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.NewActionTarget;
import org.odpi.openmetadata.governanceservers.enginehostservices.ffdc.EngineHostServicesAuditCode;

public abstract class GovernanceServiceHandler
implements Runnable {
    protected GovernanceEngineProperties governanceEngineProperties;
    protected String governanceEngineGUID;
    protected String engineHostUserId;
    protected String governanceServiceGUID;
    protected String governanceServiceName;
    private final GovernanceEngineClient governanceActionClient;
    protected Connector governanceService;
    protected String governanceActionGUID;
    protected String serviceRequestType;
    protected AuditLog auditLog;

    protected GovernanceServiceHandler(GovernanceEngineProperties governanceEngineProperties, String governanceEngineGUID, String engineHostUserId, String governanceActionGUID, GovernanceEngineClient governanceActionClient, String serviceRequestType, String governanceServiceGUID, String governanceServiceName, Connector governanceService, AuditLog auditLog) {
        this.governanceEngineProperties = governanceEngineProperties;
        this.governanceEngineGUID = governanceEngineGUID;
        this.engineHostUserId = engineHostUserId;
        this.governanceServiceGUID = governanceServiceGUID;
        this.governanceServiceName = governanceServiceName;
        this.governanceActionGUID = governanceActionGUID;
        this.governanceActionClient = governanceActionClient;
        this.serviceRequestType = serviceRequestType;
        this.governanceService = governanceService;
        this.auditLog = auditLog;
    }

    public String getGovernanceServiceName() {
        return this.governanceServiceName;
    }

    public String getGovernanceServiceGUID() {
        return this.governanceServiceGUID;
    }

    public String getGovernanceEngineName() {
        return this.governanceEngineProperties.getQualifiedName();
    }

    public void updateActionTargetStatus(String actionTargetGUID, GovernanceActionStatus status, Date startDate, Date completionDate, String completionMessage) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateActionTargetStatus";
        if (this.auditLog != null) {
            String statusString = "<null>";
            String startTime = "<null>";
            String completionTime = "<null>";
            if (status != null) {
                statusString = status.getName();
            }
            if (startDate != null) {
                startTime = startDate.toString();
            }
            if (completionDate != null) {
                completionTime = completionDate.toString();
            }
            this.auditLog.logMessage("updateActionTargetStatus", EngineHostServicesAuditCode.GOVERNANCE_ACTION_TARGET_COMPLETION.getMessageDefinition(new String[]{this.governanceActionGUID, this.governanceServiceName, this.getGovernanceEngineName(), this.serviceRequestType, actionTargetGUID, statusString, startTime, completionTime, completionMessage}));
        }
        this.governanceActionClient.updateActionTargetStatus(this.engineHostUserId, actionTargetGUID, status, startDate, completionDate, completionMessage);
    }

    public void recordCompletionStatus(CompletionStatus status, List<String> outputGuards, Map<String, String> requestParameters, List<NewActionTarget> newActionTargets, String completionMessage) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "recordCompletionStatus";
        if (this.auditLog != null) {
            String statusString = "<null>";
            String guardsString = "<null>";
            String requestParameterNames = "<null>";
            if (status != null) {
                statusString = status.getName();
            }
            if (outputGuards != null) {
                guardsString = outputGuards.toString();
            }
            if (requestParameters != null) {
                requestParameterNames = requestParameters.keySet().toString();
            }
            HashMap<String, String> actionTargetMap = new HashMap<String, String>();
            if (newActionTargets != null) {
                for (NewActionTarget newActionTarget : newActionTargets) {
                    if (newActionTarget == null) continue;
                    actionTargetMap.put(newActionTarget.getActionTargetName(), newActionTarget.getActionTargetGUID());
                }
            }
            this.auditLog.logMessage("recordCompletionStatus", EngineHostServicesAuditCode.GOVERNANCE_ACTION_RECORD_COMPLETION.getMessageDefinition(new String[]{this.governanceActionGUID, this.governanceServiceName, this.getGovernanceEngineName(), this.serviceRequestType, statusString, guardsString, requestParameterNames, ((Object)actionTargetMap).toString(), completionMessage}));
        }
        this.governanceActionClient.recordCompletionStatus(this.engineHostUserId, this.governanceActionGUID, requestParameters, status, outputGuards, newActionTargets, completionMessage);
    }

    public void disconnect() throws ConnectorCheckedException {
        if (this.governanceService != null) {
            this.governanceService.disconnect();
        }
    }
}

