/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.enginehostservices.registration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adminservices.configuration.registration.EngineServiceRegistrationEntry;

public class OMAGEngineServiceRegistration {
    private static final Map<String, EngineServiceRegistrationEntry> engineServiceRegistrationMap = new HashMap<String, EngineServiceRegistrationEntry>();

    public static synchronized void registerEngineService(EngineServiceRegistrationEntry registration) {
        String serviceName;
        if (registration != null && (serviceName = registration.getEngineServiceName()) != null) {
            engineServiceRegistrationMap.put(serviceName, registration);
        }
    }

    public static synchronized List<EngineServiceRegistrationEntry> getEngineServiceRegistrationList() {
        ArrayList<EngineServiceRegistrationEntry> registrationList = new ArrayList<EngineServiceRegistrationEntry>();
        for (EngineServiceRegistrationEntry engineServiceRegistration : engineServiceRegistrationMap.values()) {
            if (engineServiceRegistration == null) continue;
            registrationList.add(engineServiceRegistration);
        }
        return registrationList;
    }

    public static synchronized EngineServiceRegistrationEntry getEngineServiceRegistration(String urlMarker) {
        if (urlMarker != null) {
            for (EngineServiceRegistrationEntry engineServiceRegistration : engineServiceRegistrationMap.values()) {
                if (engineServiceRegistration == null || !urlMarker.equals(engineServiceRegistration.getEngineServiceURLMarker())) continue;
                return engineServiceRegistration;
            }
        }
        return null;
    }
}

