/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.enginehostservices.admin;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.odpi.openmetadata.accessservices.governanceserver.client.GovernanceConfigurationClient;
import org.odpi.openmetadata.accessservices.governanceserver.client.GovernanceContextClient;
import org.odpi.openmetadata.adminservices.configuration.properties.EngineConfig;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ActionTargetElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.EngineActionElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceEngineElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceEngineProperties;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RegisteredGovernanceService;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RegisteredGovernanceServiceElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RequestSourceElement;
import org.odpi.openmetadata.frameworks.openmetadata.enums.EngineActionStatus;
import org.odpi.openmetadata.governanceservers.enginehostservices.admin.GovernanceServiceCache;
import org.odpi.openmetadata.governanceservers.enginehostservices.admin.GovernanceServiceHandler;
import org.odpi.openmetadata.governanceservers.enginehostservices.ffdc.EngineHostServicesAuditCode;
import org.odpi.openmetadata.governanceservers.enginehostservices.ffdc.EngineHostServicesErrorCode;
import org.odpi.openmetadata.governanceservers.enginehostservices.properties.GovernanceEngineStatus;
import org.odpi.openmetadata.governanceservers.enginehostservices.properties.GovernanceEngineSummary;

public abstract class GovernanceEngineHandler {
    protected String serverName;
    protected String serverUserId;
    protected GovernanceContextClient engineActionClient;
    protected String engineUserId;
    protected AuditLog auditLog;
    protected int maxPageSize;
    private final String engineServiceName;
    protected String governanceEngineName;
    protected String governanceEngineGUID = null;
    protected GovernanceEngineProperties governanceEngineProperties = null;
    private GovernanceEngineElement governanceEngineElement = null;
    private boolean servicesToRestart = true;
    private String governanceEngineTypeName = null;
    private List<String> governanceEngineSuperTypeNames = null;
    private final Map<String, EngineActionExecution> engineActionThreadMap = new HashMap<String, EngineActionExecution>();
    protected final GovernanceConfigurationClient configurationClient;
    private final GovernanceServiceCacheMap governanceServiceLookupTable = new GovernanceServiceCacheMap();

    public GovernanceEngineHandler(EngineConfig engineConfig, String serverName, String serverUserId, String engineServiceName, GovernanceConfigurationClient configurationClient, GovernanceContextClient engineActionClient, AuditLog auditLog, int maxPageSize) {
        this.engineServiceName = engineServiceName;
        this.governanceEngineName = engineConfig.getEngineQualifiedName();
        this.serverName = serverName;
        this.serverUserId = serverUserId;
        this.engineUserId = engineConfig.getEngineUserId();
        if (this.engineUserId == null) {
            this.engineUserId = serverUserId;
        }
        this.configurationClient = configurationClient;
        this.engineActionClient = engineActionClient;
        this.auditLog = auditLog;
        this.maxPageSize = maxPageSize;
    }

    public String getGovernanceEngineName() {
        return this.governanceEngineName;
    }

    public GovernanceEngineElement getGovernanceEngineElement() {
        return this.governanceEngineElement;
    }

    public synchronized GovernanceEngineSummary getSummary() {
        GovernanceEngineSummary mySummary = new GovernanceEngineSummary();
        mySummary.setGovernanceEngineName(this.governanceEngineName);
        mySummary.setGovernanceEngineTypeName(this.governanceEngineTypeName);
        mySummary.setGovernanceEngineService(this.engineServiceName);
        mySummary.setGovernanceEngineGUID(this.governanceEngineGUID);
        if (this.governanceEngineProperties != null) {
            mySummary.setGovernanceEngineDescription(this.governanceEngineProperties.getDescription());
        }
        mySummary.setGovernanceRequestTypes(this.governanceServiceLookupTable.getGovernanceRequestTypes());
        mySummary.setGovernanceEngineStatus(GovernanceEngineStatus.ASSIGNED);
        if (this.governanceEngineGUID != null) {
            mySummary.setGovernanceEngineStatus(GovernanceEngineStatus.CONFIGURING);
        }
        if (this.governanceServiceLookupTable.getGovernanceRequestTypes() != null) {
            mySummary.setGovernanceEngineStatus(GovernanceEngineStatus.RUNNING);
        }
        return mySummary;
    }

    public synchronized void refreshConfig() throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "refreshConfig";
        this.governanceEngineElement = this.configurationClient.getGovernanceEngineByName(this.serverUserId, this.governanceEngineName);
        if (this.governanceEngineElement == null || this.governanceEngineElement.getElementHeader() == null || this.governanceEngineElement.getElementHeader().getType() == null || this.governanceEngineElement.getProperties() == null) {
            this.governanceEngineGUID = null;
            this.governanceEngineTypeName = null;
            this.governanceEngineSuperTypeNames = null;
            this.governanceEngineProperties = null;
            throw new PropertyServerException(EngineHostServicesErrorCode.UNKNOWN_GOVERNANCE_ENGINE_CONFIG.getMessageDefinition(new String[]{this.governanceEngineName, this.configurationClient.getConfigurationServerName(), this.serverName}), this.getClass().getName(), "refreshConfig");
        }
        this.governanceEngineGUID = this.governanceEngineElement.getElementHeader().getGUID();
        this.governanceEngineTypeName = this.governanceEngineElement.getElementHeader().getType().getTypeName();
        this.governanceEngineSuperTypeNames = this.governanceEngineElement.getElementHeader().getType().getSuperTypeNames();
        this.governanceEngineProperties = this.governanceEngineElement.getProperties();
        this.refreshAllServiceConfig();
    }

    private void refreshAllServiceConfig() throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "refreshAllServiceConfig";
        String actionDescription = "Retrieve all governance service configuration";
        this.auditLog.logMessage("Retrieve all governance service configuration", EngineHostServicesAuditCode.CLEARING_ALL_GOVERNANCE_SERVICE_CONFIG.getMessageDefinition(new String[]{this.governanceEngineName}));
        this.governanceServiceLookupTable.clear();
        int startingFrom = 0;
        boolean moreToReceive = true;
        while (moreToReceive) {
            List registeredGovernanceServices = this.configurationClient.getRegisteredGovernanceServices(this.serverUserId, this.governanceEngineGUID, startingFrom, this.maxPageSize);
            if (registeredGovernanceServices != null && !registeredGovernanceServices.isEmpty()) {
                for (RegisteredGovernanceServiceElement registeredGovernanceService : registeredGovernanceServices) {
                    this.refreshRegisteredGovernanceService(registeredGovernanceService, null, "refreshAllServiceConfig");
                }
                startingFrom += this.maxPageSize;
                continue;
            }
            moreToReceive = false;
        }
        this.auditLog.logMessage("Retrieve all governance service configuration", EngineHostServicesAuditCode.FINISHED_ALL_GOVERNANCE_SERVICE_CONFIG.getMessageDefinition(new String[]{this.governanceEngineName}));
    }

    public synchronized void refreshServiceConfig(String registeredGovernanceServiceGUID, String specificRequestType) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "refreshServiceConfig";
        if (registeredGovernanceServiceGUID != null) {
            RegisteredGovernanceServiceElement registeredGovernanceServiceElement = this.configurationClient.getRegisteredGovernanceService(this.serverUserId, this.governanceEngineGUID, registeredGovernanceServiceGUID);
            this.refreshRegisteredGovernanceService(registeredGovernanceServiceElement, specificRequestType, "refreshServiceConfig");
        }
    }

    private void refreshRegisteredGovernanceService(RegisteredGovernanceServiceElement registeredGovernanceServiceElement, String specificRequestType, String methodName) throws InvalidParameterException, PropertyServerException {
        RegisteredGovernanceService registeredGovernanceService;
        if (registeredGovernanceServiceElement != null && registeredGovernanceServiceElement.getElementHeader() != null && registeredGovernanceServiceElement.getProperties() != null && (registeredGovernanceService = registeredGovernanceServiceElement.getProperties()).getRequestTypes() != null) {
            Set governanceRequestTypes;
            if (specificRequestType == null) {
                governanceRequestTypes = registeredGovernanceService.getRequestTypes().keySet();
            } else {
                governanceRequestTypes = new HashSet();
                governanceRequestTypes.add(specificRequestType);
            }
            for (String governanceRequestType : governanceRequestTypes) {
                GovernanceServiceCache governanceServiceCache = new GovernanceServiceCache(this.serverName, this.governanceEngineName, registeredGovernanceServiceElement, governanceRequestType, this.auditLog);
                this.governanceServiceLookupTable.put(governanceRequestType, governanceServiceCache);
                this.auditLog.logMessage(methodName, EngineHostServicesAuditCode.SUPPORTED_REQUEST_TYPE.getMessageDefinition(new String[]{this.governanceEngineName, this.serverName, governanceRequestType}));
            }
        }
    }

    protected void validateGovernanceEngineInitialized(String expectedTypeName, String methodName) throws PropertyServerException {
        if (this.governanceEngineProperties == null) {
            throw new PropertyServerException(EngineHostServicesErrorCode.GOVERNANCE_ENGINE_NOT_INITIALIZED.getMessageDefinition(new String[]{this.serverName, this.governanceEngineName}), this.getClass().getName(), methodName);
        }
        if (expectedTypeName.equals(this.governanceEngineTypeName)) {
            return;
        }
        if (this.governanceEngineSuperTypeNames != null && this.governanceEngineSuperTypeNames.contains(expectedTypeName)) {
            return;
        }
        throw new PropertyServerException(EngineHostServicesErrorCode.WRONG_TYPE_OF_GOVERNANCE_ENGINE.getMessageDefinition(new String[]{this.governanceEngineName, this.configurationClient.getConfigurationServerName(), expectedTypeName, this.governanceEngineTypeName, this.serverName}), this.getClass().getName(), methodName);
    }

    public void restartServices(GovernanceEngineElement governanceEngineElement) {
        String methodName = "restartServices";
        if (this.servicesToRestart && governanceEngineElement != null) {
            try {
                int startFrom = 0;
                List engineActionElements = this.engineActionClient.getActiveClaimedEngineActions(this.serverUserId, governanceEngineElement.getElementHeader().getGUID(), startFrom, this.maxPageSize);
                this.servicesToRestart = false;
                while (engineActionElements != null) {
                    for (EngineActionElement engineActionElement : engineActionElements) {
                        if (engineActionElement == null) continue;
                        this.restartGovernanceService(engineActionElement);
                    }
                    engineActionElements = this.engineActionClient.getActiveClaimedEngineActions(this.serverUserId, governanceEngineElement.getElementHeader().getGUID(), startFrom += this.maxPageSize, this.maxPageSize);
                }
            }
            catch (Exception error) {
                this.auditLog.logException("restartServices", EngineHostServicesAuditCode.UNEXPECTED_EXCEPTION_DURING_RESTART.getMessageDefinition(new String[]{"restartServices", error.getClass().getName(), error.getMessage()}), (Throwable)error);
            }
        }
    }

    protected synchronized GovernanceServiceCache getServiceCache(String governanceRequestType) {
        return this.governanceServiceLookupTable.get(governanceRequestType);
    }

    public void executeEngineAction(String engineActionGUID) {
        String methodName = "executeEngineAction";
        try {
            EngineActionElement latestEngineActionElement = this.engineActionClient.getEngineAction(this.serverUserId, engineActionGUID);
            if (latestEngineActionElement.getActionStatus() == EngineActionStatus.APPROVED) {
                this.engineActionClient.claimEngineAction(this.serverUserId, engineActionGUID);
                this.runGovernanceService(engineActionGUID, latestEngineActionElement.getRequestType(), latestEngineActionElement.getRequesterUserId(), latestEngineActionElement.getRequestedStartTime(), latestEngineActionElement.getRequestParameters(), latestEngineActionElement.getRequestSourceElements(), latestEngineActionElement.getActionTargetElements());
            } else if (latestEngineActionElement.getActionStatus() == EngineActionStatus.CANCELLED && this.serverUserId.equals(latestEngineActionElement.getProcessingEngineUserId())) {
                this.cancelGovernanceService(engineActionGUID);
            }
        }
        catch (Exception error) {
            this.auditLog.logException("executeEngineAction", EngineHostServicesAuditCode.ACTION_PROCESSING_ERROR.getMessageDefinition(new String[]{"executeEngineAction", error.getClass().getName(), engineActionGUID, error.getMessage()}), (Throwable)error);
        }
    }

    public abstract void runGovernanceService(String var1, String var2, String var3, Date var4, Map<String, String> var5, List<RequestSourceElement> var6, List<ActionTargetElement> var7) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException;

    public void restartGovernanceService(EngineActionElement engineActionElement) {
        String methodName = "restartGovernanceService";
        try {
            this.runGovernanceService(engineActionElement.getElementHeader().getGUID(), engineActionElement.getRequestType(), engineActionElement.getRequesterUserId(), engineActionElement.getRequestedStartTime(), engineActionElement.getRequestParameters(), engineActionElement.getRequestSourceElements(), engineActionElement.getActionTargetElements());
        }
        catch (Exception error) {
            this.auditLog.logException("restartGovernanceService", EngineHostServicesAuditCode.ACTION_PROCESSING_ERROR.getMessageDefinition(new String[]{"restartGovernanceService", error.getClass().getName(), engineActionElement.getElementHeader().getGUID(), error.getMessage()}), (Throwable)error);
        }
    }

    protected synchronized void startServiceExecutionThread(String engineActionGUID, GovernanceServiceHandler serviceToRun, String threadName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Thread thread = new Thread((Runnable)serviceToRun, threadName);
        EngineActionExecution engineActionExecution = new EngineActionExecution();
        engineActionExecution.executionThread = thread;
        engineActionExecution.governanceServiceHandler = serviceToRun;
        this.engineActionThreadMap.put(engineActionGUID, engineActionExecution);
        thread.start();
    }

    private synchronized void cancelGovernanceService(String engineActionGUID) throws ConnectorCheckedException {
        String methodName = "cancelGovernanceService";
        EngineActionExecution engineActionExecution = this.engineActionThreadMap.get(engineActionGUID);
        if (engineActionExecution.executionThread != null) {
            this.auditLog.logMessage("cancelGovernanceService", EngineHostServicesAuditCode.ENGINE_ACTION_CANCELLED.getMessageDefinition(new String[]{this.governanceEngineName, engineActionGUID, engineActionExecution.executionThread.getName()}));
            engineActionExecution.governanceServiceHandler.disconnect();
            engineActionExecution.executionThread.interrupt();
        }
    }

    public void terminate() {
        String actionDescription = "terminate";
        this.auditLog.logMessage("terminate", EngineHostServicesAuditCode.ENGINE_SHUTDOWN.getMessageDefinition(new String[]{this.governanceEngineName, this.serverName}));
        this.governanceEngineElement = null;
        this.governanceEngineGUID = null;
        this.governanceEngineProperties = null;
        this.governanceServiceLookupTable.clear();
    }

    private static class GovernanceServiceCacheMap {
        private volatile Map<String, GovernanceServiceCache> governanceServiceLookupTable = new HashMap<String, GovernanceServiceCache>();

        private GovernanceServiceCacheMap() {
        }

        synchronized void clear() {
            this.governanceServiceLookupTable = new HashMap<String, GovernanceServiceCache>();
        }

        synchronized void put(String governanceRequestType, GovernanceServiceCache governanceServiceCache) {
            this.governanceServiceLookupTable.put(governanceRequestType, governanceServiceCache);
        }

        protected synchronized GovernanceServiceCache get(String governanceRequestType) {
            return this.governanceServiceLookupTable.get(governanceRequestType);
        }

        synchronized List<String> getGovernanceRequestTypes() {
            if (this.governanceServiceLookupTable.isEmpty()) {
                return null;
            }
            return new ArrayList<String>(this.governanceServiceLookupTable.keySet());
        }
    }

    static class EngineActionExecution {
        GovernanceServiceHandler governanceServiceHandler;
        Thread executionThread;

        EngineActionExecution() {
        }
    }
}

