/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.enginehostservices.enginemap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.governanceserver.client.GovernanceConfigurationClient;
import org.odpi.openmetadata.accessservices.governanceserver.client.GovernanceContextClient;
import org.odpi.openmetadata.adminservices.configuration.properties.EngineConfig;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceEngineElement;
import org.odpi.openmetadata.governanceservers.enginehostservices.admin.GovernanceEngineHandler;
import org.odpi.openmetadata.governanceservers.enginehostservices.ffdc.EngineHostServicesAuditCode;
import org.odpi.openmetadata.governanceservers.enginehostservices.registration.GovernanceEngineHandlerFactory;
import org.odpi.openmetadata.governanceservers.enginehostservices.registration.OMAGEngineServiceRegistration;

public class GovernanceEngineMap {
    private final Map<String, GovernanceEngineHandlerFactory> governanceEngineHandlerFactoryMap;
    private final Map<String, GovernanceEngineHandlerProperties> governanceEngineHandlerMap = new HashMap<String, GovernanceEngineHandlerProperties>();
    private final String localServerName;
    private final String localServerUserId;
    private final String localServerPassword;
    private final GovernanceConfigurationClient configurationClient;
    private final GovernanceContextClient engineActionClient;
    private final AuditLog auditLog;
    private final int maxPageSize;

    public GovernanceEngineMap(String localServerName, String localServerUserId, String localServerPassword, GovernanceConfigurationClient configurationClient, GovernanceContextClient engineActionClient, AuditLog auditLog, int maxPageSize) {
        this.governanceEngineHandlerFactoryMap = OMAGEngineServiceRegistration.getGovernanceEngineHandlerFactoryMap();
        this.localServerName = localServerName;
        this.localServerUserId = localServerUserId;
        this.localServerPassword = localServerPassword;
        this.configurationClient = configurationClient;
        this.engineActionClient = engineActionClient;
        this.auditLog = auditLog;
        this.maxPageSize = maxPageSize;
    }

    public synchronized GovernanceEngineHandler getGovernanceEngineHandler(String governanceEngineGUID, String governanceEngineName) {
        String methodName = "getGovernanceEngineHandler(guid, name)";
        GovernanceEngineHandlerProperties engineHandlerProperties = this.governanceEngineHandlerMap.get(governanceEngineName);
        if (engineHandlerProperties != null) {
            GovernanceEngineHandler governanceEngineHandler = engineHandlerProperties.getGovernanceEngineHandler();
            if (governanceEngineHandler == null) {
                try {
                    GovernanceEngineElement governanceEngineElement = this.configurationClient.getGovernanceEngineByGUID(this.localServerUserId, governanceEngineGUID);
                    governanceEngineHandler = this.createGovernanceEngineHandler(governanceEngineElement);
                }
                catch (Exception error) {
                    this.auditLog.logException("getGovernanceEngineHandler(guid, name)", EngineHostServicesAuditCode.GOVERNANCE_ENGINE_NO_CONFIG.getMessageDefinition(new String[]{governanceEngineGUID, governanceEngineName, error.getClass().getName(), error.getMessage()}), (Throwable)error);
                }
            }
            return governanceEngineHandler;
        }
        return null;
    }

    public synchronized GovernanceEngineHandler getGovernanceEngineHandler(String governanceEngineName) {
        String methodName = "getGovernanceEngineHandler(name)";
        GovernanceEngineHandlerProperties engineHandlerProperties = this.governanceEngineHandlerMap.get(governanceEngineName);
        if (engineHandlerProperties != null) {
            GovernanceEngineHandler governanceEngineHandler = engineHandlerProperties.getGovernanceEngineHandler();
            if (governanceEngineHandler == null) {
                try {
                    GovernanceEngineElement governanceEngineElement = this.configurationClient.getGovernanceEngineByName(this.localServerUserId, governanceEngineName);
                    governanceEngineHandler = this.createGovernanceEngineHandler(governanceEngineElement);
                }
                catch (Exception error) {
                    this.auditLog.logException("getGovernanceEngineHandler(name)", EngineHostServicesAuditCode.GOVERNANCE_ENGINE_NO_CONFIG.getMessageDefinition(new String[]{governanceEngineName, error.getClass().getName(), error.getMessage()}), (Throwable)error);
                }
            }
            return governanceEngineHandler;
        }
        return null;
    }

    private GovernanceEngineHandler createGovernanceEngineHandler(GovernanceEngineElement governanceEngineElement) throws InvalidParameterException {
        String governanceEngineTypeName;
        GovernanceEngineHandlerFactory governanceEngineHandlerFactory;
        GovernanceEngineHandlerProperties engineHandlerProperties;
        GovernanceEngineHandler governanceEngineHandler = null;
        if (governanceEngineElement != null && (engineHandlerProperties = this.governanceEngineHandlerMap.get(governanceEngineElement.getProperties().getQualifiedName())) != null && (governanceEngineHandlerFactory = this.governanceEngineHandlerFactoryMap.get(governanceEngineTypeName = governanceEngineElement.getElementHeader().getType().getTypeName())) != null) {
            governanceEngineHandler = governanceEngineHandlerFactory.createGovernanceEngineHandler(engineHandlerProperties.getEngineConfig(), this.localServerName, this.localServerUserId, this.localServerPassword, engineHandlerProperties.getPartnerServerName(), engineHandlerProperties.getPartnerURLRoot(), this.configurationClient, this.engineActionClient, this.auditLog, this.maxPageSize);
            engineHandlerProperties.setGovernanceEngineHandler(governanceEngineHandler, governanceEngineTypeName);
        }
        return governanceEngineHandler;
    }

    public synchronized List<GovernanceEngineHandler> getGovernanceEngineHandlers() {
        ArrayList<GovernanceEngineHandler> governanceEngineHandlers = new ArrayList<GovernanceEngineHandler>();
        for (String governanceEngineName : this.governanceEngineHandlerMap.keySet()) {
            GovernanceEngineHandler governanceEngineHandler = this.governanceEngineHandlerMap.get(governanceEngineName).getGovernanceEngineHandler();
            if (governanceEngineHandler == null) continue;
            governanceEngineHandlers.add(governanceEngineHandler);
        }
        return governanceEngineHandlers;
    }

    public synchronized List<String> getGovernanceEngineNames() {
        return new ArrayList<String>(this.governanceEngineHandlerMap.keySet());
    }

    public synchronized List<String> getGovernanceEngineNames(String serviceURLMarker) {
        String governanceEngineTypeName = OMAGEngineServiceRegistration.getGovernanceEngineTypeName(serviceURLMarker);
        if (governanceEngineTypeName != null) {
            ArrayList<String> governanceEngineNames = new ArrayList<String>();
            for (GovernanceEngineHandlerProperties engineHandlerProperties : this.governanceEngineHandlerMap.values()) {
                if (!governanceEngineTypeName.equals(engineHandlerProperties.getGovernanceEngineTypeName())) continue;
                governanceEngineNames.add(engineHandlerProperties.getEngineConfig().getEngineQualifiedName());
            }
            if (!governanceEngineNames.isEmpty()) {
                return governanceEngineNames;
            }
        }
        return null;
    }

    public synchronized void setGovernanceEngineProperties(List<EngineConfig> engineConfigs, String partnerServerName, String partnerURLRoot) {
        if (engineConfigs != null) {
            for (EngineConfig engineConfig : engineConfigs) {
                this.setGovernanceEngineProperties(engineConfig, partnerServerName, partnerURLRoot);
            }
        }
    }

    public synchronized void setGovernanceEngineProperties(EngineConfig engineConfig, String partnerServerName, String partnerURLRoot) {
        if (engineConfig != null && engineConfig.getEngineQualifiedName() != null && this.governanceEngineHandlerMap.get(engineConfig.getEngineQualifiedName()) == null) {
            GovernanceEngineHandlerProperties engineHandlerProperties = new GovernanceEngineHandlerProperties(engineConfig, partnerServerName, partnerURLRoot);
            this.governanceEngineHandlerMap.put(engineConfig.getEngineQualifiedName(), engineHandlerProperties);
        }
    }

    static class GovernanceEngineHandlerProperties {
        private final EngineConfig engineConfig;
        private final String partnerServerName;
        private final String partnerURLRoot;
        private String governanceEngineTypeName = null;
        GovernanceEngineHandler governanceEngineHandler = null;

        public GovernanceEngineHandlerProperties(EngineConfig engineConfig, String partnerServerName, String partnerURLRoot) {
            this.engineConfig = engineConfig;
            this.partnerServerName = partnerServerName;
            this.partnerURLRoot = partnerURLRoot;
        }

        public EngineConfig getEngineConfig() {
            return this.engineConfig;
        }

        public String getPartnerServerName() {
            return this.partnerServerName;
        }

        public String getPartnerURLRoot() {
            return this.partnerURLRoot;
        }

        public void setGovernanceEngineHandler(GovernanceEngineHandler governanceEngineHandler, String governanceEngineTypeName) {
            this.governanceEngineHandler = governanceEngineHandler;
            this.governanceEngineTypeName = governanceEngineTypeName;
        }

        public GovernanceEngineHandler getGovernanceEngineHandler() {
            return this.governanceEngineHandler;
        }

        public String getGovernanceEngineTypeName() {
            return this.governanceEngineTypeName;
        }
    }
}

