/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.enginehostservices.registration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adminservices.configuration.registration.EngineServiceRegistrationEntry;
import org.odpi.openmetadata.governanceservers.enginehostservices.registration.GovernanceEngineHandlerFactory;

public class OMAGEngineServiceRegistration {
    private static final Map<String, EngineServiceRegistrationEntry> engineServiceRegistrationMap = new HashMap<String, EngineServiceRegistrationEntry>();
    private static final Map<String, GovernanceEngineHandlerFactory> engineHandlerFactoryMap = new HashMap<String, GovernanceEngineHandlerFactory>();
    private static final Map<String, String> engineServiceToTypeNameMap = new HashMap<String, String>();

    public static synchronized void registerEngineService(EngineServiceRegistrationEntry registration, GovernanceEngineHandlerFactory engineHandlerFactory) {
        if (registration != null) {
            String governanceEngineTypeName;
            String serviceName = registration.getEngineServiceName();
            if (serviceName != null) {
                engineServiceRegistrationMap.put(serviceName, registration);
            }
            if ((governanceEngineTypeName = registration.getHostedGovernanceEngineType()) != null) {
                engineHandlerFactoryMap.put(governanceEngineTypeName, engineHandlerFactory);
                engineServiceToTypeNameMap.put(registration.getEngineServiceURLMarker(), governanceEngineTypeName);
            }
        }
    }

    public static synchronized List<EngineServiceRegistrationEntry> getEngineServiceRegistrationList() {
        ArrayList<EngineServiceRegistrationEntry> registrationList = new ArrayList<EngineServiceRegistrationEntry>();
        for (EngineServiceRegistrationEntry engineServiceRegistration : engineServiceRegistrationMap.values()) {
            if (engineServiceRegistration == null) continue;
            registrationList.add(engineServiceRegistration);
        }
        return registrationList;
    }

    public static synchronized EngineServiceRegistrationEntry getEngineServiceRegistration(String urlMarker) {
        if (urlMarker != null) {
            for (EngineServiceRegistrationEntry engineServiceRegistration : engineServiceRegistrationMap.values()) {
                if (engineServiceRegistration == null || !urlMarker.equals(engineServiceRegistration.getEngineServiceURLMarker())) continue;
                return engineServiceRegistration;
            }
        }
        return null;
    }

    public static String getGovernanceEngineTypeName(String serviceURLMarker) {
        return engineServiceToTypeNameMap.get(serviceURLMarker);
    }

    public static synchronized Map<String, GovernanceEngineHandlerFactory> getGovernanceEngineHandlerFactoryMap() {
        return new HashMap<String, GovernanceEngineHandlerFactory>(engineHandlerFactoryMap);
    }
}

