/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.enginehostservices.admin;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.governanceserver.client.GovernanceContextClient;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CompletionStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceEngineProperties;
import org.odpi.openmetadata.frameworks.governanceaction.properties.NewActionTarget;
import org.odpi.openmetadata.frameworks.openmetadata.enums.EngineActionStatus;
import org.odpi.openmetadata.governanceservers.enginehostservices.ffdc.EngineHostServicesAuditCode;

public abstract class GovernanceServiceHandler
implements Runnable {
    protected final GovernanceEngineProperties governanceEngineProperties;
    protected final String governanceEngineGUID;
    protected final String engineHostUserId;
    protected final String governanceServiceGUID;
    protected final String governanceServiceName;
    protected final Connector governanceService;
    protected final String engineActionGUID;
    protected final String serviceRequestType;
    protected final AuditLog auditLog;
    private final GovernanceContextClient engineActionClient;
    private final Date requestedStartDate;

    protected GovernanceServiceHandler(GovernanceEngineProperties governanceEngineProperties, String governanceEngineGUID, String engineHostUserId, String engineActionGUID, GovernanceContextClient engineActionClient, String serviceRequestType, String governanceServiceGUID, String governanceServiceName, Connector governanceService, Date requestedStartDate, AuditLog auditLog) {
        this.governanceEngineProperties = governanceEngineProperties;
        this.governanceEngineGUID = governanceEngineGUID;
        this.engineHostUserId = engineHostUserId;
        this.governanceServiceGUID = governanceServiceGUID;
        this.governanceServiceName = governanceServiceName;
        this.engineActionGUID = engineActionGUID;
        this.engineActionClient = engineActionClient;
        this.serviceRequestType = serviceRequestType;
        this.governanceService = governanceService;
        this.requestedStartDate = requestedStartDate;
        this.auditLog = auditLog;
    }

    public String getGovernanceServiceName() {
        return this.governanceServiceName;
    }

    public String getGovernanceServiceGUID() {
        return this.governanceServiceGUID;
    }

    public String getGovernanceEngineName() {
        return this.governanceEngineProperties.getQualifiedName();
    }

    protected void waitForStartDate(String serverUserId) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Date now = new Date();
        while (this.requestedStartDate != null && this.requestedStartDate.after(now)) {
            try {
                Thread.sleep(this.requestedStartDate.getTime() - now.getTime());
            }
            catch (InterruptedException interruptedException) {
                now = new Date();
            }
        }
        this.engineActionClient.updateEngineActionStatus(serverUserId, this.engineActionGUID, EngineActionStatus.IN_PROGRESS);
    }

    public void updateActionTargetStatus(String actionTargetGUID, EngineActionStatus status, Date startDate, Date completionDate, String completionMessage) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateActionTargetStatus";
        if (this.auditLog != null) {
            String statusString = "<null>";
            String startTime = "<null>";
            String completionTime = "<null>";
            if (status != null) {
                statusString = status.getName();
            }
            if (startDate != null) {
                startTime = startDate.toString();
            }
            if (completionDate != null) {
                completionTime = completionDate.toString();
            }
            this.auditLog.logMessage("updateActionTargetStatus", EngineHostServicesAuditCode.ENGINE_ACTION_TARGET_COMPLETION.getMessageDefinition(new String[]{this.engineActionGUID, this.governanceServiceName, this.getGovernanceEngineName(), this.serviceRequestType, actionTargetGUID, statusString, startTime, completionTime, completionMessage}));
        }
        this.engineActionClient.updateActionTargetStatus(this.engineHostUserId, actionTargetGUID, status, startDate, completionDate, completionMessage);
    }

    public void recordCompletionStatus(CompletionStatus status, List<String> outputGuards, Map<String, String> requestParameters, List<NewActionTarget> newActionTargets, String completionMessage) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "recordCompletionStatus";
        if (this.auditLog != null) {
            String statusString = "<null>";
            String guardsString = "<null>";
            String requestParameterNames = "<null>";
            if (status != null) {
                statusString = status.getName();
            }
            if (outputGuards != null) {
                guardsString = outputGuards.toString();
            }
            if (requestParameters != null) {
                requestParameterNames = requestParameters.keySet().toString();
            }
            HashMap<String, String> actionTargetMap = new HashMap<String, String>();
            if (newActionTargets != null) {
                for (NewActionTarget newActionTarget : newActionTargets) {
                    if (newActionTarget == null) continue;
                    actionTargetMap.put(newActionTarget.getActionTargetName(), newActionTarget.getActionTargetGUID());
                }
            }
            this.auditLog.logMessage("recordCompletionStatus", EngineHostServicesAuditCode.ENGINE_ACTION_RECORD_COMPLETION.getMessageDefinition(new String[]{this.engineActionGUID, this.governanceServiceName, this.getGovernanceEngineName(), this.serviceRequestType, statusString, guardsString, requestParameterNames, ((Object)actionTargetMap).toString(), completionMessage}));
        }
        this.engineActionClient.recordCompletionStatus(this.engineHostUserId, this.engineActionGUID, requestParameters, status, outputGuards, newActionTargets, completionMessage);
    }

    public void disconnect() throws ConnectorCheckedException {
        if (this.governanceService != null) {
            this.governanceService.disconnect();
        }
    }
}

