/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.enginehostservices.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.governanceengine.client.GovernanceEngineClient;
import org.odpi.openmetadata.accessservices.governanceengine.client.GovernanceEngineConfigurationClient;
import org.odpi.openmetadata.accessservices.governanceengine.client.GovernanceEngineEventClient;
import org.odpi.openmetadata.accessservices.governanceengine.client.rest.GovernanceEngineRESTClient;
import org.odpi.openmetadata.adminservices.configuration.properties.EngineConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.EngineHostServicesConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.EngineServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.adminservices.configuration.registration.GovernanceServicesDescription;
import org.odpi.openmetadata.adminservices.configuration.registration.ServiceOperationalStatus;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.governanceservers.enginehostservices.admin.EngineServiceAdmin;
import org.odpi.openmetadata.governanceservers.enginehostservices.admin.GovernanceEngineHandler;
import org.odpi.openmetadata.governanceservers.enginehostservices.ffdc.EngineHostServicesAuditCode;
import org.odpi.openmetadata.governanceservers.enginehostservices.ffdc.EngineHostServicesErrorCode;
import org.odpi.openmetadata.governanceservers.enginehostservices.server.EngineHostInstance;
import org.odpi.openmetadata.governanceservers.enginehostservices.threads.EngineConfigurationRefreshThread;

public class EngineHostOperationalServices {
    private String localServerName;
    private String localServerId;
    private String localServerUserId;
    private String localServerPassword;
    private int maxPageSize;
    private AuditLog auditLog = null;
    private EngineHostInstance engineHostInstance = null;
    private InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private List<EngineServiceAdmin> engineServiceAdminList = null;

    public EngineHostOperationalServices(String localServerName, String localServerId, String localServerUserId, String localServerPassword, int maxPageSize) {
        this.localServerName = localServerName;
        this.localServerId = localServerId;
        this.localServerUserId = localServerUserId;
        this.localServerPassword = localServerPassword;
        this.maxPageSize = maxPageSize;
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
    }

    public List<String> initialize(EngineHostServicesConfig configuration, AuditLog auditLog) throws OMAGConfigurationErrorException {
        String actionDescription = "initialize engine host services";
        String methodName = "initialize";
        this.auditLog = auditLog;
        auditLog.logMessage("initialize engine host services", EngineHostServicesAuditCode.SERVER_INITIALIZING.getMessageDefinition(new String[]{this.localServerName}));
        try {
            this.invalidParameterHandler.validateUserId(this.localServerUserId, "initialize");
            if (configuration == null) {
                throw new OMAGConfigurationErrorException(EngineHostServicesErrorCode.NO_CONFIG_DOC.getMessageDefinition(new String[]{this.localServerName}), this.getClass().getName(), "initialize");
            }
            if (configuration.getEngineServiceConfigs() == null || configuration.getEngineServiceConfigs().isEmpty()) {
                throw new OMAGConfigurationErrorException(EngineHostServicesErrorCode.NO_ENGINE_SERVICES_CONFIGURED.getMessageDefinition(new String[]{this.localServerName}), this.getClass().getName(), "initialize");
            }
            String accessServiceRootURL = this.getAccessServiceRootURL(configuration);
            String accessServiceServerName = this.getAccessServiceServerName(configuration);
            GovernanceEngineRESTClient restClient = this.localServerPassword == null ? new GovernanceEngineRESTClient(accessServiceServerName, accessServiceRootURL, auditLog) : new GovernanceEngineRESTClient(accessServiceServerName, accessServiceRootURL, this.localServerUserId, this.localServerUserId, auditLog);
            GovernanceEngineEventClient eventClient = new GovernanceEngineEventClient(accessServiceServerName, accessServiceRootURL, restClient, this.maxPageSize, auditLog, this.localServerId);
            GovernanceEngineConfigurationClient configurationClient = new GovernanceEngineConfigurationClient(accessServiceServerName, accessServiceRootURL, restClient, this.maxPageSize, auditLog);
            GovernanceEngineClient serverClient = new GovernanceEngineClient(accessServiceServerName, accessServiceRootURL, restClient, this.maxPageSize);
            HashMap<String, List<String>> serviceEngineLists = new HashMap<String, List<String>>();
            HashMap<String, GovernanceEngineHandler> governanceEngineHandlers = new HashMap<String, GovernanceEngineHandler>();
            List<String> activatedServiceList = this.initializeEngineServices(configuration.getEngineServiceConfigs(), configurationClient, serverClient, serviceEngineLists, governanceEngineHandlers);
            EngineConfigurationRefreshThread configurationRefreshThread = new EngineConfigurationRefreshThread(governanceEngineHandlers, configurationClient, eventClient, auditLog, this.localServerUserId, this.localServerName, accessServiceServerName, accessServiceRootURL);
            Thread thread = new Thread((Runnable)configurationRefreshThread, configurationRefreshThread.getClass().getName());
            thread.start();
            this.engineHostInstance = new EngineHostInstance(this.localServerName, GovernanceServicesDescription.ENGINE_HOST_SERVICES.getServiceName(), auditLog, this.localServerUserId, this.maxPageSize, configurationRefreshThread, governanceEngineHandlers, serviceEngineLists);
            auditLog.logMessage("initialize engine host services", EngineHostServicesAuditCode.SERVER_INITIALIZED.getMessageDefinition(new String[]{this.localServerName}));
            return activatedServiceList;
        }
        catch (InvalidParameterException error) {
            throw new OMAGConfigurationErrorException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error);
        }
        catch (OMAGConfigurationErrorException error) {
            throw error;
        }
        catch (Throwable error) {
            auditLog.logException("initialize engine host services", EngineHostServicesAuditCode.SERVICE_INSTANCE_FAILURE.getMessageDefinition(new String[]{this.localServerName, error.getClass().getName(), error.getMessage()}), error.toString(), error);
            throw new OMAGConfigurationErrorException(EngineHostServicesErrorCode.SERVICE_INSTANCE_FAILURE.getMessageDefinition(new String[]{this.localServerName, error.getClass().getName(), error.getMessage()}), this.getClass().getName(), "initialize", error);
        }
    }

    private List<String> initializeEngineServices(List<EngineServiceConfig> engineServiceConfigList, GovernanceEngineConfigurationClient configurationClient, GovernanceEngineClient serverClient, Map<String, List<String>> serviceEngineLists, Map<String, GovernanceEngineHandler> governanceEngineHandlers) throws OMAGConfigurationErrorException {
        String methodName = "initializeEngineServices";
        String actionDescription = "Initialize Engine Services";
        ArrayList<String> activatedEngineServices = new ArrayList<String>();
        this.engineServiceAdminList = new ArrayList<EngineServiceAdmin>();
        if (engineServiceConfigList != null) {
            this.auditLog.logMessage("Initialize Engine Services", EngineHostServicesAuditCode.STARTING_ENGINE_SERVICES.getMessageDefinition(new String[]{this.localServerName}));
            int configuredEngineServiceCount = 0;
            int enabledEngineServiceCount = 0;
            for (EngineServiceConfig engineServiceConfig : engineServiceConfigList) {
                ++configuredEngineServiceCount;
                if (ServiceOperationalStatus.ENABLED.equals((Object)engineServiceConfig.getEngineServiceOperationalStatus())) {
                    ++enabledEngineServiceCount;
                    serviceEngineLists.put(engineServiceConfig.getEngineServiceURLMarker(), this.getEngineNames(engineServiceConfig));
                    try {
                        EngineServiceAdmin engineServiceAdmin = this.getEngineServiceAdminClass(engineServiceConfig);
                        AuditLog engineServicesAuditLog = this.auditLog.createNewAuditLog(engineServiceConfig.getEngineServiceId(), engineServiceConfig.getEngineServiceFullName(), engineServiceConfig.getEngineServiceDescription(), engineServiceConfig.getEngineServiceWiki());
                        Map serviceEngineHandlers = engineServiceAdmin.initialize(this.localServerId, this.localServerName, engineServicesAuditLog, this.localServerUserId, this.localServerPassword, this.maxPageSize, configurationClient, serverClient, engineServiceConfig);
                        if (serviceEngineHandlers == null || serviceEngineHandlers.isEmpty()) {
                            this.auditLog.logMessage("initializeEngineServices", EngineHostServicesAuditCode.ENGINE_SERVICE_NULL_HANDLERS.getMessageDefinition(new String[]{engineServiceConfig.getEngineServiceName(), this.localServerName}), engineServiceConfig.toString());
                            throw new OMAGConfigurationErrorException(EngineHostServicesErrorCode.ENGINE_SERVICE_NULL_HANDLERS.getMessageDefinition(new String[]{engineServiceConfig.getEngineServiceName(), this.localServerName}), this.getClass().getName(), "initializeEngineServices");
                        }
                        governanceEngineHandlers.putAll(serviceEngineHandlers);
                        this.engineServiceAdminList.add(engineServiceAdmin);
                        activatedEngineServices.add(engineServiceConfig.getEngineServiceFullName());
                        continue;
                    }
                    catch (OMAGConfigurationErrorException error) {
                        this.auditLog.logException("initializeEngineServices", EngineHostServicesAuditCode.ENGINE_SERVICE_INSTANCE_FAILURE.getMessageDefinition(new String[]{engineServiceConfig.getEngineServiceName(), ((Object)((Object)error)).getClass().getName(), error.getMessage()}), engineServiceConfig.toString(), (Throwable)error);
                        throw error;
                    }
                    catch (Throwable error) {
                        this.auditLog.logException("initializeEngineServices", EngineHostServicesAuditCode.ENGINE_SERVICE_INSTANCE_FAILURE.getMessageDefinition(new String[]{engineServiceConfig.getEngineServiceName(), error.getClass().getName(), error.getMessage()}), engineServiceConfig.toString(), error);
                        throw new OMAGConfigurationErrorException(EngineHostServicesErrorCode.UNEXPECTED_INITIALIZATION_EXCEPTION.getMessageDefinition(new String[]{this.localServerName, engineServiceConfig.getEngineServiceName(), error.getClass().getName(), error.getMessage()}), this.getClass().getName(), "initializeEngineServices", error);
                    }
                }
                this.auditLog.logMessage("Initialize Engine Services", EngineHostServicesAuditCode.SKIPPING_ENGINE_SERVICE.getMessageDefinition(new String[]{engineServiceConfig.getEngineServiceFullName(), this.localServerName}));
            }
            this.auditLog.logMessage("Initialize Engine Services", EngineHostServicesAuditCode.ALL_ENGINE_SERVICES_STARTED.getMessageDefinition(new String[]{Integer.toString(enabledEngineServiceCount), Integer.toString(configuredEngineServiceCount), this.localServerName}));
        }
        return activatedEngineServices;
    }

    public void terminate() {
        String actionDescription = "terminate";
        this.auditLog.logMessage("terminate", EngineHostServicesAuditCode.SERVER_SHUTTING_DOWN.getMessageDefinition(new String[]{this.localServerName}));
        this.engineHostInstance.shutdown();
        if (this.engineServiceAdminList != null) {
            for (EngineServiceAdmin engineServiceAdmin : this.engineServiceAdminList) {
                if (engineServiceAdmin == null) continue;
                engineServiceAdmin.shutdown();
            }
        }
        this.auditLog.logMessage("terminate", EngineHostServicesAuditCode.SERVER_SHUTDOWN.getMessageDefinition(new String[]{this.localServerName}));
    }

    private EngineServiceAdmin getEngineServiceAdminClass(EngineServiceConfig engineServiceConfig) throws OMAGConfigurationErrorException {
        String methodName = "getEngineServiceAdminClass";
        String engineServiceAdminClassName = engineServiceConfig.getEngineServiceAdminClass();
        if (engineServiceAdminClassName != null) {
            try {
                return (EngineServiceAdmin)Class.forName(engineServiceAdminClassName).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException error) {
                this.auditLog.logException("getEngineServiceAdminClass", EngineHostServicesAuditCode.BAD_ENGINE_SERVICE_ADMIN_CLASS.getMessageDefinition(new String[]{engineServiceConfig.getEngineServiceName(), engineServiceAdminClassName, error.getMessage()}), engineServiceConfig.toString(), (Throwable)error);
                throw new OMAGConfigurationErrorException(EngineHostServicesErrorCode.BAD_ENGINE_SERVICE_ADMIN_CLASS.getMessageDefinition(new String[]{this.localServerName, engineServiceAdminClassName, engineServiceConfig.getEngineServiceName()}), this.getClass().getName(), "getEngineServiceAdminClass", (Throwable)error);
            }
            catch (Throwable error) {
                this.auditLog.logException("getEngineServiceAdminClass", EngineHostServicesAuditCode.BAD_ENGINE_SERVICE_ADMIN_CLASS.getMessageDefinition(new String[]{engineServiceConfig.getEngineServiceName(), engineServiceAdminClassName, error.getMessage()}), engineServiceConfig.toString(), error);
                throw error;
            }
        }
        this.auditLog.logMessage("getEngineServiceAdminClass", EngineHostServicesAuditCode.NULL_ENGINE_SERVICE_ADMIN_CLASS.getMessageDefinition(new String[]{this.localServerName, engineServiceConfig.getEngineServiceFullName()}), engineServiceConfig.toString());
        throw new OMAGConfigurationErrorException(EngineHostServicesErrorCode.NULL_ENGINE_SERVICE_ADMIN_CLASS.getMessageDefinition(new String[]{this.localServerName, engineServiceConfig.getEngineServiceName()}), this.getClass().getName(), "getEngineServiceAdminClass");
    }

    private String getAccessServiceRootURL(EngineHostServicesConfig config) throws OMAGConfigurationErrorException {
        String accessServiceRootURL = config.getOMAGServerPlatformRootURL();
        if (accessServiceRootURL == null) {
            String actionDescription = "Validate engine services configuration.";
            String methodName = "getAccessServiceRootURL";
            this.auditLog.logMessage("Validate engine services configuration.", EngineHostServicesAuditCode.NO_CONFIG_OMAS_SERVER_URL.getMessageDefinition(new String[]{this.localServerName, AccessServiceDescription.GOVERNANCE_ENGINE_OMAS.getAccessServiceName()}));
            throw new OMAGConfigurationErrorException(EngineHostServicesErrorCode.NO_CONFIG_OMAS_SERVER_URL.getMessageDefinition(new String[]{this.localServerName, AccessServiceDescription.GOVERNANCE_ENGINE_OMAS.getAccessServiceFullName()}), this.getClass().getName(), "getAccessServiceRootURL");
        }
        return accessServiceRootURL;
    }

    private String getAccessServiceServerName(EngineHostServicesConfig config) throws OMAGConfigurationErrorException {
        String accessServiceServerName = config.getOMAGServerName();
        if (accessServiceServerName == null) {
            String actionDescription = "Validate engine service configuration.";
            String methodName = "getAccessServiceServerName";
            this.auditLog.logMessage("Validate engine service configuration.", EngineHostServicesAuditCode.NO_CONFIG_OMAS_SERVER_NAME.getMessageDefinition(new String[]{this.localServerName, AccessServiceDescription.GOVERNANCE_ENGINE_OMAS.getAccessServiceName()}));
            throw new OMAGConfigurationErrorException(EngineHostServicesErrorCode.NO_CONFIG_OMAS_SERVER_NAME.getMessageDefinition(new String[]{this.localServerName, AccessServiceDescription.GOVERNANCE_ENGINE_OMAS.getAccessServiceFullName()}), this.getClass().getName(), "getAccessServiceServerName");
        }
        return accessServiceServerName;
    }

    private List<String> getEngineNames(EngineServiceConfig engineServiceConfig) throws OMAGConfigurationErrorException {
        String actionDescription = "Validate engine services configuration.";
        String methodName = "getEngineNames";
        List engineConfigList = engineServiceConfig.getEngines();
        if (engineConfigList == null || engineConfigList.isEmpty()) {
            this.auditLog.logMessage("Validate engine services configuration.", EngineHostServicesAuditCode.NO_ENGINES_FOR_SERVICE.getMessageDefinition(new String[]{engineServiceConfig.getEngineServiceFullName(), this.localServerName}));
            throw new OMAGConfigurationErrorException(EngineHostServicesErrorCode.NO_ENGINES_FOR_SERVICE.getMessageDefinition(new String[]{engineServiceConfig.getEngineServiceFullName(), this.localServerName}), this.getClass().getName(), "getEngineNames");
        }
        ArrayList<String> engineNames = new ArrayList<String>();
        for (EngineConfig engineConfig : engineConfigList) {
            if (engineConfig == null) continue;
            if (engineConfig.getEngineQualifiedName() == null) {
                this.auditLog.logMessage("Validate engine services configuration.", EngineHostServicesAuditCode.NULL_ENGINE_NAME.getMessageDefinition(new String[]{engineServiceConfig.getEngineServiceFullName(), this.localServerName}));
                throw new OMAGConfigurationErrorException(EngineHostServicesErrorCode.NULL_ENGINE_NAME.getMessageDefinition(new String[]{engineServiceConfig.getEngineServiceFullName(), this.localServerName}), this.getClass().getName(), "getEngineNames");
            }
            engineNames.add(engineConfig.getEngineQualifiedName());
        }
        if (engineNames.isEmpty()) {
            return null;
        }
        return engineNames;
    }
}

