/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.enginehostservices.listener;

import java.util.Map;
import org.odpi.openmetadata.accessservices.governanceengine.api.GovernanceEngineEventListener;
import org.odpi.openmetadata.accessservices.governanceengine.events.GovernanceEngineConfigurationEvent;
import org.odpi.openmetadata.accessservices.governanceengine.events.GovernanceEngineEvent;
import org.odpi.openmetadata.accessservices.governanceengine.events.GovernanceServiceConfigurationEvent;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.governanceservers.enginehostservices.admin.GovernanceEngineHandler;
import org.odpi.openmetadata.governanceservers.enginehostservices.ffdc.EngineHostServicesAuditCode;

public class EngineConfigurationRefreshListener
extends GovernanceEngineEventListener {
    private Map<String, GovernanceEngineHandler> governanceEngineHandlers;
    private AuditLog auditLog;

    public EngineConfigurationRefreshListener(Map<String, GovernanceEngineHandler> governanceEngineHandlers, AuditLog auditLog) {
        this.governanceEngineHandlers = governanceEngineHandlers;
        this.auditLog = auditLog;
    }

    public void processEvent(GovernanceEngineEvent event) {
        String actionDescription = "Process configuration event";
        if (event != null) {
            GovernanceEngineConfigurationEvent governanceEngineEvent;
            GovernanceEngineHandler governanceEngineHandler;
            if (event instanceof GovernanceServiceConfigurationEvent) {
                GovernanceServiceConfigurationEvent governanceServiceEvent = (GovernanceServiceConfigurationEvent)event;
                GovernanceEngineHandler governanceEngineHandler2 = this.governanceEngineHandlers.get(governanceServiceEvent.getGovernanceEngineName());
                if (governanceEngineHandler2 != null) {
                    try {
                        governanceEngineHandler2.refreshServiceConfig(governanceServiceEvent.getRegisteredGovernanceServiceGUID());
                    }
                    catch (Exception error) {
                        this.auditLog.logException("Process configuration event", EngineHostServicesAuditCode.GOVERNANCE_SERVICE_NO_CONFIG.getMessageDefinition(new String[]{governanceServiceEvent.getRegisteredGovernanceServiceGUID(), governanceServiceEvent.getRequestType(), error.getClass().getName(), error.getMessage()}), governanceServiceEvent.toString(), (Throwable)error);
                    }
                }
            } else if (event instanceof GovernanceEngineConfigurationEvent && (governanceEngineHandler = this.governanceEngineHandlers.get((governanceEngineEvent = (GovernanceEngineConfigurationEvent)event).getGovernanceEngineName())) != null) {
                try {
                    governanceEngineHandler.refreshConfig();
                }
                catch (Exception error) {
                    this.auditLog.logException("Process configuration event", EngineHostServicesAuditCode.GOVERNANCE_ENGINE_NO_CONFIG.getMessageDefinition(new String[]{governanceEngineEvent.getGovernanceEngineName(), error.getClass().getName(), error.getMessage()}), governanceEngineEvent.toString(), (Throwable)error);
                }
            }
        }
    }
}

