/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.enginehostservices.listener;

import java.util.Map;
import org.odpi.openmetadata.accessservices.governanceengine.api.GovernanceEngineEventListener;
import org.odpi.openmetadata.accessservices.governanceengine.events.GovernanceActionEvent;
import org.odpi.openmetadata.accessservices.governanceengine.events.GovernanceEngineConfigurationEvent;
import org.odpi.openmetadata.accessservices.governanceengine.events.GovernanceEngineEvent;
import org.odpi.openmetadata.accessservices.governanceengine.events.GovernanceServiceConfigurationEvent;
import org.odpi.openmetadata.accessservices.governanceengine.events.WatchdogGovernanceServiceEvent;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.governanceservers.enginehostservices.admin.GovernanceEngineHandler;
import org.odpi.openmetadata.governanceservers.enginehostservices.ffdc.EngineHostServicesAuditCode;

public class GovernanceEngineOutTopicListener
extends GovernanceEngineEventListener {
    private Map<String, GovernanceEngineHandler> governanceEngineHandlers;
    private AuditLog auditLog;

    public GovernanceEngineOutTopicListener(Map<String, GovernanceEngineHandler> governanceEngineHandlers, AuditLog auditLog) {
        this.governanceEngineHandlers = governanceEngineHandlers;
        this.auditLog = auditLog;
    }

    public void processEvent(GovernanceEngineEvent event) {
        String actionDescription = "Process OutTopic event";
        if (event != null) {
            WatchdogGovernanceServiceEvent watchdogGovernanceServiceEvent;
            GovernanceEngineHandler governanceEngineHandler;
            if (event instanceof GovernanceServiceConfigurationEvent) {
                GovernanceServiceConfigurationEvent governanceServiceEvent = (GovernanceServiceConfigurationEvent)event;
                GovernanceEngineHandler governanceEngineHandler2 = this.governanceEngineHandlers.get(governanceServiceEvent.getGovernanceEngineName());
                if (governanceEngineHandler2 != null) {
                    try {
                        governanceEngineHandler2.refreshServiceConfig(governanceServiceEvent.getRegisteredGovernanceServiceGUID());
                    }
                    catch (Exception error) {
                        this.auditLog.logException("Process OutTopic event", EngineHostServicesAuditCode.GOVERNANCE_SERVICE_NO_CONFIG.getMessageDefinition(new String[]{governanceServiceEvent.getRegisteredGovernanceServiceGUID(), governanceServiceEvent.getRequestType(), error.getClass().getName(), error.getMessage()}), governanceServiceEvent.toString(), (Throwable)error);
                    }
                }
            } else if (event instanceof GovernanceEngineConfigurationEvent) {
                GovernanceEngineConfigurationEvent governanceEngineEvent = (GovernanceEngineConfigurationEvent)event;
                GovernanceEngineHandler governanceEngineHandler3 = this.governanceEngineHandlers.get(governanceEngineEvent.getGovernanceEngineName());
                if (governanceEngineHandler3 != null) {
                    try {
                        governanceEngineHandler3.refreshConfig();
                    }
                    catch (Exception error) {
                        this.auditLog.logException("Process OutTopic event", EngineHostServicesAuditCode.GOVERNANCE_ENGINE_NO_CONFIG.getMessageDefinition(new String[]{governanceEngineEvent.getGovernanceEngineName(), error.getClass().getName(), error.getMessage()}), governanceEngineEvent.toString(), (Throwable)error);
                    }
                }
            } else if (event instanceof GovernanceActionEvent) {
                GovernanceActionEvent governanceActionEvent = (GovernanceActionEvent)event;
                GovernanceEngineHandler governanceEngineHandler4 = this.governanceEngineHandlers.get(governanceActionEvent.getGovernanceEngineName());
                if (governanceEngineHandler4 != null) {
                    try {
                        governanceEngineHandler4.executeGovernanceAction(governanceActionEvent.getGovernanceActionElement());
                    }
                    catch (Exception error) {
                        this.auditLog.logException("Process OutTopic event", EngineHostServicesAuditCode.GOVERNANCE_ACTION_FAILED.getMessageDefinition(new String[]{governanceActionEvent.getGovernanceEngineName(), error.getClass().getName(), error.getMessage()}), governanceActionEvent.toString(), (Throwable)error);
                    }
                }
            } else if (event instanceof WatchdogGovernanceServiceEvent && (governanceEngineHandler = this.governanceEngineHandlers.get((watchdogGovernanceServiceEvent = (WatchdogGovernanceServiceEvent)event).getGovernanceEngineName())) != null) {
                try {
                    governanceEngineHandler.publishWatchdogEvent(watchdogGovernanceServiceEvent.getWatchdogGovernanceEvent());
                }
                catch (Exception error) {
                    this.auditLog.logException("Process OutTopic event", EngineHostServicesAuditCode.GOVERNANCE_ACTION_FAILED.getMessageDefinition(new String[]{watchdogGovernanceServiceEvent.getGovernanceEngineName(), error.getClass().getName(), error.getMessage()}), watchdogGovernanceServiceEvent.toString(), (Throwable)error);
                }
            }
        }
    }
}

