/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.enginehostservices.threads;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.odpi.openmetadata.accessservices.governanceengine.api.GovernanceEngineEventListener;
import org.odpi.openmetadata.accessservices.governanceengine.client.GovernanceEngineConfigurationClient;
import org.odpi.openmetadata.accessservices.governanceengine.client.GovernanceEngineEventClient;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.governanceservers.enginehostservices.admin.GovernanceEngineHandler;
import org.odpi.openmetadata.governanceservers.enginehostservices.ffdc.EngineHostServicesAuditCode;
import org.odpi.openmetadata.governanceservers.enginehostservices.listener.GovernanceEngineOutTopicListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EngineConfigurationRefreshThread
implements Runnable {
    private Map<String, GovernanceEngineHandler> engineHandlers;
    private GovernanceEngineConfigurationClient configurationClient;
    private GovernanceEngineEventClient eventClient;
    private AuditLog auditLog;
    private String localServerUserId;
    private String localServerName;
    private String accessServiceServerName;
    private String accessServiceRootURL;
    private volatile boolean keepTrying = true;
    private static final Logger log = LoggerFactory.getLogger(EngineConfigurationRefreshThread.class);

    public EngineConfigurationRefreshThread(Map<String, GovernanceEngineHandler> engineHandlers, GovernanceEngineConfigurationClient configurationClient, GovernanceEngineEventClient eventClient, AuditLog auditLog, String localServerUserId, String localServerName, String accessServiceServerName, String accessServiceRootURL) {
        this.engineHandlers = new HashMap<String, GovernanceEngineHandler>(engineHandlers);
        this.configurationClient = configurationClient;
        this.eventClient = eventClient;
        this.auditLog = auditLog;
        this.localServerUserId = localServerUserId;
        this.localServerName = localServerName;
        this.accessServiceServerName = accessServiceServerName;
        this.accessServiceRootURL = accessServiceRootURL;
    }

    @Override
    public void run() {
        String actionDescription = "Register configuration listener";
        boolean listenerRegistered = false;
        ArrayList<Object> configToRetrieve = this.engineHandlers != null ? new ArrayList<GovernanceEngineHandler>(this.engineHandlers.values()) : new ArrayList();
        while (!listenerRegistered && configToRetrieve.size() != 0 && this.keepTrying) {
            while (!listenerRegistered && this.keepTrying) {
                try {
                    this.eventClient.registerListener(this.localServerUserId, (GovernanceEngineEventListener)new GovernanceEngineOutTopicListener(this.engineHandlers, this.auditLog));
                    listenerRegistered = true;
                    this.auditLog.logMessage("Register configuration listener", EngineHostServicesAuditCode.CONFIGURATION_LISTENER_REGISTERED.getMessageDefinition(new String[]{this.localServerName, this.accessServiceServerName}));
                }
                catch (UserNotAuthorizedException error) {
                    this.auditLog.logException("Register configuration listener", EngineHostServicesAuditCode.SERVER_NOT_AUTHORIZED.getMessageDefinition(new String[]{this.localServerName, this.accessServiceServerName, this.accessServiceRootURL, this.localServerUserId, error.getReportedErrorMessage()}), (Throwable)error);
                    this.waitToRetry();
                }
                catch (Throwable error) {
                    this.auditLog.logException("Register configuration listener", EngineHostServicesAuditCode.NO_CONFIGURATION_LISTENER.getMessageDefinition(new String[]{this.localServerName, this.accessServiceServerName, error.getClass().getName(), error.getMessage()}), error);
                    this.waitToRetry();
                }
            }
            while (configToRetrieve.size() != 0 && this.keepTrying) {
                ArrayList<GovernanceEngineHandler> configFailed = new ArrayList<GovernanceEngineHandler>();
                for (GovernanceEngineHandler engineHandler : configToRetrieve) {
                    if (engineHandler == null) continue;
                    try {
                        engineHandler.refreshConfig();
                    }
                    catch (Throwable error) {
                        this.auditLog.logException("Register configuration listener", EngineHostServicesAuditCode.GOVERNANCE_ENGINE_NO_CONFIG.getMessageDefinition(new String[]{engineHandler.getGovernanceEngineName(), error.getClass().getName(), error.getMessage()}), error.toString(), error);
                        configFailed.add(engineHandler);
                    }
                }
                configToRetrieve = configFailed;
                this.waitToRetry();
            }
        }
    }

    private void waitToRetry() {
        int sleepTime = 2000000;
        if (this.keepTrying) {
            try {
                Thread.sleep(2000000L);
            }
            catch (Exception error) {
                log.error("Ignored exception from sleep - probably ok", (Throwable)error);
            }
        }
    }

    public void stop() {
        this.keepTrying = false;
    }
}

