/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.enginehostservices.listener;

import java.util.Map;
import org.odpi.openmetadata.accessservices.governanceengine.api.GovernanceEngineEventListener;
import org.odpi.openmetadata.accessservices.governanceengine.events.GovernanceActionEvent;
import org.odpi.openmetadata.accessservices.governanceengine.events.GovernanceEngineConfigurationEvent;
import org.odpi.openmetadata.accessservices.governanceengine.events.GovernanceEngineEvent;
import org.odpi.openmetadata.accessservices.governanceengine.events.GovernanceServiceConfigurationEvent;
import org.odpi.openmetadata.accessservices.governanceengine.events.WatchdogGovernanceServiceEvent;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.governanceservers.enginehostservices.admin.GovernanceEngineHandler;
import org.odpi.openmetadata.governanceservers.enginehostservices.ffdc.EngineHostServicesAuditCode;

public class GovernanceEngineOutTopicListener
extends GovernanceEngineEventListener {
    private final Map<String, GovernanceEngineHandler> governanceEngineHandlers;
    private final AuditLog auditLog;

    public GovernanceEngineOutTopicListener(Map<String, GovernanceEngineHandler> governanceEngineHandlers, AuditLog auditLog) {
        this.governanceEngineHandlers = governanceEngineHandlers;
        this.auditLog = auditLog;
    }

    public void processEvent(GovernanceEngineEvent event) {
        String actionDescription = "Process OutTopic event";
        if (event != null) {
            if (event instanceof GovernanceServiceConfigurationEvent) {
                GovernanceServiceConfigurationEvent governanceServiceEvent = (GovernanceServiceConfigurationEvent)event;
                GovernanceEngineHandler governanceEngineHandler = this.governanceEngineHandlers.get(governanceServiceEvent.getGovernanceEngineName());
                if (governanceEngineHandler != null) {
                    try {
                        governanceEngineHandler.refreshServiceConfig(governanceServiceEvent.getRegisteredGovernanceServiceGUID(), governanceServiceEvent.getRequestType());
                    }
                    catch (Exception error) {
                        this.auditLog.logException("Process OutTopic event", EngineHostServicesAuditCode.GOVERNANCE_SERVICE_NO_CONFIG.getMessageDefinition(new String[]{governanceServiceEvent.getRegisteredGovernanceServiceGUID(), governanceServiceEvent.getRequestType(), error.getClass().getName(), error.getMessage()}), governanceServiceEvent.toString(), (Throwable)error);
                    }
                }
            } else if (event instanceof GovernanceEngineConfigurationEvent) {
                GovernanceEngineConfigurationEvent governanceEngineEvent = (GovernanceEngineConfigurationEvent)event;
                GovernanceEngineHandler governanceEngineHandler = this.governanceEngineHandlers.get(governanceEngineEvent.getGovernanceEngineName());
                if (governanceEngineHandler != null) {
                    try {
                        governanceEngineHandler.refreshConfig();
                    }
                    catch (Exception error) {
                        this.auditLog.logException("Process OutTopic event", EngineHostServicesAuditCode.GOVERNANCE_ENGINE_NO_CONFIG.getMessageDefinition(new String[]{governanceEngineEvent.getGovernanceEngineName(), error.getClass().getName(), error.getMessage()}), governanceEngineEvent.toString(), (Throwable)error);
                    }
                }
            } else if (event instanceof GovernanceActionEvent) {
                GovernanceActionEvent governanceActionEvent = (GovernanceActionEvent)event;
                GovernanceEngineHandler governanceEngineHandler = this.governanceEngineHandlers.get(governanceActionEvent.getGovernanceEngineName());
                if (governanceEngineHandler != null) {
                    try {
                        governanceEngineHandler.executeGovernanceAction(governanceActionEvent.getGovernanceActionGUID());
                    }
                    catch (Exception error) {
                        this.auditLog.logException("Process OutTopic event", EngineHostServicesAuditCode.GOVERNANCE_ACTION_FAILED.getMessageDefinition(new String[]{governanceActionEvent.getGovernanceEngineName(), error.getClass().getName(), error.getMessage()}), governanceActionEvent.toString(), (Throwable)error);
                    }
                }
            } else if (event instanceof WatchdogGovernanceServiceEvent) {
                WatchdogGovernanceServiceEvent watchdogGovernanceServiceEvent = (WatchdogGovernanceServiceEvent)event;
                for (GovernanceEngineHandler governanceEngineHandler : this.governanceEngineHandlers.values()) {
                    if (governanceEngineHandler == null) continue;
                    try {
                        governanceEngineHandler.publishWatchdogEvent(watchdogGovernanceServiceEvent.getWatchdogGovernanceEvent());
                    }
                    catch (Exception error) {
                        this.auditLog.logException("Process OutTopic event", EngineHostServicesAuditCode.GOVERNANCE_ACTION_FAILED.getMessageDefinition(new String[]{watchdogGovernanceServiceEvent.getGovernanceEngineName(), error.getClass().getName(), error.getMessage()}), watchdogGovernanceServiceEvent.toString(), (Throwable)error);
                    }
                }
            }
        }
    }
}

