/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.enginehostservices.listener;

import org.odpi.openmetadata.accessservices.governanceserver.api.GovernanceServerEventListener;
import org.odpi.openmetadata.accessservices.governanceserver.events.EngineActionEvent;
import org.odpi.openmetadata.accessservices.governanceserver.events.GovernanceEngineConfigurationEvent;
import org.odpi.openmetadata.accessservices.governanceserver.events.GovernanceServerEvent;
import org.odpi.openmetadata.accessservices.governanceserver.events.GovernanceServiceConfigurationEvent;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.governanceservers.enginehostservices.admin.GovernanceEngineHandler;
import org.odpi.openmetadata.governanceservers.enginehostservices.enginemap.GovernanceEngineMap;
import org.odpi.openmetadata.governanceservers.enginehostservices.ffdc.EngineHostServicesAuditCode;

public class GovernanceServerOutTopicListener
extends GovernanceServerEventListener {
    private final GovernanceEngineMap governanceEngineHandlers;
    private final AuditLog auditLog;

    public GovernanceServerOutTopicListener(GovernanceEngineMap governanceEngineHandlers, AuditLog auditLog) {
        this.governanceEngineHandlers = governanceEngineHandlers;
        this.auditLog = auditLog;
    }

    public void processEvent(GovernanceServerEvent event) {
        String actionDescription = "Process OutTopic event";
        if (event != null) {
            GovernanceEngineConfigurationEvent governanceEngineEvent;
            GovernanceEngineHandler governanceEngineHandler;
            if (event instanceof EngineActionEvent) {
                EngineActionEvent engineActionEvent = (EngineActionEvent)event;
                GovernanceEngineHandler governanceEngineHandler2 = this.governanceEngineHandlers.getGovernanceEngineHandler(engineActionEvent.getGovernanceEngineName());
                if (governanceEngineHandler2 != null) {
                    try {
                        governanceEngineHandler2.executeEngineAction(engineActionEvent.getEngineActionGUID());
                    }
                    catch (Exception error) {
                        this.auditLog.logException("Process OutTopic event", EngineHostServicesAuditCode.ENGINE_ACTION_FAILED.getMessageDefinition(new String[]{engineActionEvent.getGovernanceEngineName(), error.getClass().getName(), error.getMessage()}), engineActionEvent.toString(), (Throwable)error);
                    }
                }
            } else if (event instanceof GovernanceServiceConfigurationEvent) {
                GovernanceServiceConfigurationEvent governanceServiceEvent = (GovernanceServiceConfigurationEvent)event;
                GovernanceEngineHandler governanceEngineHandler3 = this.governanceEngineHandlers.getGovernanceEngineHandler(governanceServiceEvent.getGovernanceEngineName());
                if (governanceEngineHandler3 != null) {
                    try {
                        governanceEngineHandler3.refreshServiceConfig(governanceServiceEvent.getRegisteredGovernanceServiceGUID(), governanceServiceEvent.getRequestType());
                    }
                    catch (Exception error) {
                        this.auditLog.logException("Process OutTopic event", EngineHostServicesAuditCode.GOVERNANCE_SERVICE_NO_CONFIG.getMessageDefinition(new String[]{governanceServiceEvent.getRegisteredGovernanceServiceGUID(), governanceServiceEvent.getRequestType(), error.getClass().getName(), error.getMessage()}), governanceServiceEvent.toString(), (Throwable)error);
                    }
                }
            } else if (event instanceof GovernanceEngineConfigurationEvent && (governanceEngineHandler = this.governanceEngineHandlers.getGovernanceEngineHandler((governanceEngineEvent = (GovernanceEngineConfigurationEvent)event).getGovernanceEngineGUID(), governanceEngineEvent.getGovernanceEngineName())) != null) {
                try {
                    governanceEngineHandler.refreshConfig();
                }
                catch (Exception error) {
                    this.auditLog.logException("Process OutTopic event", EngineHostServicesAuditCode.GOVERNANCE_ENGINE_NO_CONFIG.getMessageDefinition(new String[]{governanceEngineEvent.getGovernanceEngineName(), error.getClass().getName(), error.getMessage()}), governanceEngineEvent.toString(), (Throwable)error);
                }
            }
        }
    }
}

