/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.enginehostservices.server;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.commonservices.multitenant.GovernanceServerServiceInstance;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.governanceservers.enginehostservices.admin.GovernanceEngineHandler;
import org.odpi.openmetadata.governanceservers.enginehostservices.enginemap.GovernanceEngineMap;
import org.odpi.openmetadata.governanceservers.enginehostservices.ffdc.EngineHostServicesErrorCode;
import org.odpi.openmetadata.governanceservers.enginehostservices.properties.GovernanceEngineSummary;
import org.odpi.openmetadata.governanceservers.enginehostservices.threads.EngineConfigurationRefreshThread;

public class EngineHostInstance
extends GovernanceServerServiceInstance {
    private final EngineConfigurationRefreshThread configurationRefreshThread;
    private final GovernanceEngineMap governanceEngineHandlers;

    EngineHostInstance(String serverName, String serviceName, AuditLog auditLog, String localServerUserId, int maxPageSize, EngineConfigurationRefreshThread configurationRefreshThread, GovernanceEngineMap governanceEngineHandlers) {
        super(serverName, serviceName, auditLog, localServerUserId, maxPageSize);
        this.configurationRefreshThread = configurationRefreshThread;
        this.governanceEngineHandlers = governanceEngineHandlers;
    }

    void refreshConfig(String governanceEngineName, String serviceOperationName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String governanceEngineParameterName = "governanceEngineName";
        this.invalidParameterHandler.validateName(governanceEngineName, "governanceEngineName", serviceOperationName);
        if (this.governanceEngineHandlers == null) {
            throw new PropertyServerException(EngineHostServicesErrorCode.NO_GOVERNANCE_ENGINES.getMessageDefinition(new String[]{this.serverName}), ((Object)((Object)this)).getClass().getName(), serviceOperationName);
        }
        GovernanceEngineHandler handler = this.governanceEngineHandlers.getGovernanceEngineHandler(governanceEngineName);
        if (handler == null) {
            throw new InvalidParameterException(EngineHostServicesErrorCode.UNKNOWN_ENGINE_NAME.getMessageDefinition(new String[]{this.serverName, governanceEngineName}), ((Object)((Object)this)).getClass().getName(), serviceOperationName, "governanceEngineName");
        }
        handler.refreshConfig();
    }

    GovernanceEngineSummary getGovernanceEngineSummary(String governanceEngineName, String serviceOperationName) throws InvalidParameterException, PropertyServerException {
        String governanceEngineParameterName = "governanceEngineName";
        this.invalidParameterHandler.validateName(governanceEngineName, "governanceEngineName", serviceOperationName);
        if (this.governanceEngineHandlers == null) {
            throw new PropertyServerException(EngineHostServicesErrorCode.NO_GOVERNANCE_ENGINES.getMessageDefinition(new String[]{this.serverName}), ((Object)((Object)this)).getClass().getName(), serviceOperationName);
        }
        GovernanceEngineHandler handler = this.governanceEngineHandlers.getGovernanceEngineHandler(governanceEngineName);
        if (handler == null) {
            throw new InvalidParameterException(EngineHostServicesErrorCode.UNKNOWN_ENGINE_NAME.getMessageDefinition(new String[]{this.serverName, governanceEngineName}), ((Object)((Object)this)).getClass().getName(), serviceOperationName, "governanceEngineName");
        }
        return handler.getSummary();
    }

    List<GovernanceEngineSummary> getGovernanceEngineSummaries(String serviceURLMarker, String serviceOperationName) throws InvalidParameterException, PropertyServerException {
        String nameParameterName = "serviceURLMarker";
        this.invalidParameterHandler.validateName(serviceURLMarker, "serviceURLMarker", serviceOperationName);
        List governanceEngineNames = this.governanceEngineHandlers.getGovernanceEngineNames(serviceURLMarker);
        if (governanceEngineNames == null) {
            throw new InvalidParameterException(EngineHostServicesErrorCode.UNKNOWN_ENGINE_SERVICE.getMessageDefinition(new String[]{this.serverName, serviceURLMarker}), ((Object)((Object)this)).getClass().getName(), serviceOperationName, "serviceURLMarker");
        }
        if (governanceEngineNames.isEmpty()) {
            throw new PropertyServerException(EngineHostServicesErrorCode.NO_ENGINES_FOR_SERVICE.getMessageDefinition(new String[]{serviceOperationName, this.serverName}), ((Object)((Object)this)).getClass().getName(), serviceOperationName);
        }
        ArrayList<GovernanceEngineSummary> summaries = new ArrayList<GovernanceEngineSummary>();
        for (String governanceEngineName : governanceEngineNames) {
            if (governanceEngineName == null) continue;
            summaries.add(this.getGovernanceEngineSummary(governanceEngineName, serviceOperationName));
        }
        if (summaries.isEmpty()) {
            return null;
        }
        return summaries;
    }

    List<GovernanceEngineSummary> getGovernanceEngineSummaries(String serviceOperationName) throws InvalidParameterException, PropertyServerException {
        if (this.governanceEngineHandlers == null) {
            throw new PropertyServerException(EngineHostServicesErrorCode.NO_GOVERNANCE_ENGINES.getMessageDefinition(new String[]{this.serverName}), ((Object)((Object)this)).getClass().getName(), serviceOperationName);
        }
        ArrayList<GovernanceEngineSummary> summaries = new ArrayList<GovernanceEngineSummary>();
        for (String governanceEngineName : this.governanceEngineHandlers.getGovernanceEngineNames()) {
            if (governanceEngineName == null) continue;
            summaries.add(this.getGovernanceEngineSummary(governanceEngineName, serviceOperationName));
        }
        if (summaries.isEmpty()) {
            return null;
        }
        return summaries;
    }

    public void shutdown() {
        if (this.governanceEngineHandlers != null && !this.governanceEngineHandlers.getGovernanceEngineHandlers().isEmpty()) {
            for (GovernanceEngineHandler handler : this.governanceEngineHandlers.getGovernanceEngineHandlers()) {
                if (handler == null) continue;
                handler.terminate();
            }
        }
        this.configurationRefreshThread.stop();
        super.shutdown();
    }
}

