/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.enginehostservices.server;

import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.governanceservers.enginehostservices.rest.GovernanceEngineSummariesResponse;
import org.odpi.openmetadata.governanceservers.enginehostservices.rest.GovernanceEngineSummaryResponse;
import org.odpi.openmetadata.governanceservers.enginehostservices.server.EngineHostInstanceHandler;
import org.slf4j.LoggerFactory;

public class EngineHostRESTServices {
    private static final EngineHostInstanceHandler instanceHandler = new EngineHostInstanceHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(EngineHostRESTServices.class), instanceHandler.getServiceName());
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public VoidResponse refreshConfig(String serverName, String userId, String governanceEngineName) {
        String methodName = "refreshConfig";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "refreshConfig");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "refreshConfig");
            instanceHandler.refreshConfig(userId, serverName, governanceEngineName, "refreshConfig");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "refreshConfig", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse refreshConfig(String serverName, String userId) {
        String methodName = "refreshConfig";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "refreshConfig");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "refreshConfig");
            instanceHandler.refreshConfig(userId, serverName, null, "refreshConfig");
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "refreshConfig", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceEngineSummaryResponse getGovernanceEngineSummary(String serverName, String userId, String governanceEngineName) {
        String methodName = "getGovernanceEngineSummary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceEngineSummary");
        GovernanceEngineSummaryResponse response = new GovernanceEngineSummaryResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceEngineSummary");
            response.setGovernanceEngineSummary(instanceHandler.getGovernanceEngineSummary(userId, serverName, governanceEngineName, "getGovernanceEngineSummary"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceEngineSummary", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceEngineSummariesResponse getGovernanceEngineSummaries(String serverName, String userId, String serviceURLMarker) {
        String methodName = "getGovernanceEngineSummaries";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceEngineSummaries");
        GovernanceEngineSummariesResponse response = new GovernanceEngineSummariesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceEngineSummaries");
            response.setGovernanceEngineSummaries(instanceHandler.getGovernanceEngineSummaries(userId, serverName, serviceURLMarker, "getGovernanceEngineSummaries"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceEngineSummaries", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceEngineSummariesResponse getGovernanceEngineSummaries(String serverName, String userId) {
        String methodName = "getGovernanceEngineSummaries";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernanceEngineSummaries");
        GovernanceEngineSummariesResponse response = new GovernanceEngineSummariesResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceEngineSummaries");
            response.setGovernanceEngineSummaries(instanceHandler.getGovernanceEngineSummaries(userId, serverName, "getGovernanceEngineSummaries"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceEngineSummaries", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

