/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.enginehostservices.server;

import java.util.List;
import org.odpi.openmetadata.adminservices.configuration.registration.GovernanceServicesDescription;
import org.odpi.openmetadata.commonservices.multitenant.GovernanceServerServiceInstanceHandler;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.governanceservers.enginehostservices.properties.GovernanceEngineSummary;
import org.odpi.openmetadata.governanceservers.enginehostservices.server.EngineHostInstance;

class EngineHostInstanceHandler
extends GovernanceServerServiceInstanceHandler {
    EngineHostInstanceHandler() {
        super(GovernanceServicesDescription.ENGINE_HOST_SERVICES.getServiceName());
    }

    void refreshConfig(String userId, String serverName, String governanceEngineName, String serviceOperationName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        EngineHostInstance instance = (EngineHostInstance)super.getServerServiceInstance(userId, serverName, serviceOperationName);
        if (instance != null) {
            instance.refreshConfig(governanceEngineName, serviceOperationName);
        }
    }

    GovernanceEngineSummary getGovernanceEngineSummary(String userId, String serverName, String governanceEngineName, String serviceOperationName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        EngineHostInstance instance = (EngineHostInstance)super.getServerServiceInstance(userId, serverName, serviceOperationName);
        if (instance != null) {
            return instance.getGovernanceEngineSummary(governanceEngineName, serviceOperationName);
        }
        return null;
    }

    List<GovernanceEngineSummary> getGovernanceEngineSummaries(String userId, String serverName, String serviceURLMarker, String serviceOperationName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        EngineHostInstance instance = (EngineHostInstance)super.getServerServiceInstance(userId, serverName, serviceOperationName);
        if (instance != null) {
            return instance.getGovernanceEngineSummaries(serviceURLMarker, serviceOperationName);
        }
        return null;
    }

    List<GovernanceEngineSummary> getGovernanceEngineSummaries(String userId, String serverName, String serviceOperationName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        EngineHostInstance instance = (EngineHostInstance)super.getServerServiceInstance(userId, serverName, serviceOperationName);
        if (instance != null) {
            return instance.getGovernanceEngineSummaries(serviceOperationName);
        }
        return null;
    }
}

