/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.enginehostservices.threads;

import java.util.ArrayList;
import org.odpi.openmetadata.accessservices.governanceserver.api.GovernanceServerEventListener;
import org.odpi.openmetadata.accessservices.governanceserver.client.GovernanceServerEventClient;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.governanceservers.enginehostservices.admin.GovernanceEngineHandler;
import org.odpi.openmetadata.governanceservers.enginehostservices.enginemap.GovernanceEngineMap;
import org.odpi.openmetadata.governanceservers.enginehostservices.ffdc.EngineHostServicesAuditCode;
import org.odpi.openmetadata.governanceservers.enginehostservices.listener.GovernanceServerOutTopicListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EngineConfigurationRefreshThread
implements Runnable {
    private final GovernanceEngineMap engineHandlers;
    private final GovernanceServerEventClient eventClient;
    private final AuditLog auditLog;
    private final String localServerUserId;
    private final String localServerName;
    private final String accessServiceServerName;
    private final String accessServiceRootURL;
    private volatile boolean keepTrying = true;
    private static final Logger log = LoggerFactory.getLogger(EngineConfigurationRefreshThread.class);

    public EngineConfigurationRefreshThread(GovernanceEngineMap engineHandlers, GovernanceServerEventClient eventClient, AuditLog auditLog, String localServerUserId, String localServerName, String accessServiceServerName, String accessServiceRootURL) {
        this.engineHandlers = engineHandlers;
        this.eventClient = eventClient;
        this.auditLog = auditLog;
        this.localServerUserId = localServerUserId;
        this.localServerName = localServerName;
        this.accessServiceServerName = accessServiceServerName;
        this.accessServiceRootURL = accessServiceRootURL;
    }

    @Override
    public void run() {
        String actionDescription = "Register configuration listener";
        boolean listenerRegistered = false;
        while (this.keepTrying) {
            ArrayList configToRetrieve = new ArrayList(this.engineHandlers.getGovernanceEngineNames());
            while (!listenerRegistered && this.keepTrying) {
                try {
                    this.eventClient.registerListener(this.localServerUserId, (GovernanceServerEventListener)new GovernanceServerOutTopicListener(this.engineHandlers, this.auditLog));
                    listenerRegistered = true;
                    this.auditLog.logMessage("Register configuration listener", EngineHostServicesAuditCode.CONFIGURATION_LISTENER_REGISTERED.getMessageDefinition(new String[]{this.localServerName, this.accessServiceServerName}));
                }
                catch (UserNotAuthorizedException error) {
                    this.auditLog.logException("Register configuration listener", EngineHostServicesAuditCode.SERVER_NOT_AUTHORIZED.getMessageDefinition(new String[]{this.localServerName, this.accessServiceServerName, this.accessServiceRootURL, this.localServerUserId, error.getReportedErrorMessage()}), (Throwable)error);
                    this.waitToRetry();
                }
                catch (Exception error) {
                    this.auditLog.logException("Register configuration listener", EngineHostServicesAuditCode.NO_CONFIGURATION_LISTENER.getMessageDefinition(new String[]{this.localServerName, this.accessServiceServerName, error.getClass().getName(), error.getMessage()}), (Throwable)error);
                    this.waitToRetry();
                }
            }
            while (!configToRetrieve.isEmpty() && this.keepTrying) {
                ArrayList<String> configFailed = new ArrayList<String>();
                for (String governanceEngineName : configToRetrieve) {
                    if (governanceEngineName == null) continue;
                    try {
                        GovernanceEngineHandler governanceEngineHandler = this.engineHandlers.getGovernanceEngineHandler(governanceEngineName);
                        if (governanceEngineHandler == null) continue;
                        governanceEngineHandler.refreshConfig();
                        governanceEngineHandler.restartServices(governanceEngineHandler.getGovernanceEngineElement());
                        governanceEngineHandler.startMissedEngineActions();
                    }
                    catch (Exception error) {
                        this.auditLog.logException("Register configuration listener", EngineHostServicesAuditCode.GOVERNANCE_ENGINE_NO_CONFIG.getMessageDefinition(new String[]{governanceEngineName, error.getClass().getName(), error.getMessage()}), error.toString(), (Throwable)error);
                        configFailed.add(governanceEngineName);
                    }
                }
                configToRetrieve = configFailed;
                this.waitToRetry();
            }
            this.waitToRetry();
        }
    }

    private void waitToRetry() {
        int sleepTime = 2000000;
        if (this.keepTrying) {
            try {
                Thread.sleep(2000000L);
            }
            catch (Exception error) {
                log.error("Ignored exception from sleep - probably ok", (Throwable)error);
            }
        }
    }

    public void stop() {
        this.keepTrying = false;
    }
}

