/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.engineservices.assetanalysis.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.governanceservers.enginehostservices.rest.GovernanceEngineSummariesResponse;
import org.odpi.openmetadata.governanceservers.enginehostservices.rest.GovernanceEngineSummaryResponse;
import org.odpi.openmetadata.governanceservers.enginehostservices.server.EngineHostRESTServices;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/engine-host-services/users/{userId}"})
@Tag(name="Engine Host Services", description="The Engine Host Services provide the core subsystem for the Engine Host OMAG Server.", externalDocs=@ExternalDocumentation(description="Engine Host Services", url="https://egeria.odpi.org/open-metadata-implementation/governance-servers/engine-host-services/"))
public class EngineHostServicesResource {
    private EngineHostRESTServices restAPI = new EngineHostRESTServices();

    @GetMapping(path={"/governance-engines/{governanceEngineName}/summary"})
    public GovernanceEngineSummaryResponse getGovernanceEngineSummary(@PathVariable String serverName, @PathVariable String userId, @PathVariable String governanceEngineName) {
        return this.restAPI.getGovernanceEngineSummary(serverName, userId, governanceEngineName);
    }

    @GetMapping(path={"/governance-engines/summary"})
    public GovernanceEngineSummariesResponse getGovernanceEngineSummaries(@PathVariable String serverName, @PathVariable String userId) {
        return this.restAPI.getGovernanceEngineSummaries(serverName, userId);
    }

    @GetMapping(path={"/engine-service/{serviceURLMarker}/governance-engines/summary"})
    public GovernanceEngineSummariesResponse getGovernanceEngineSummaries(@PathVariable String serverName, @PathVariable String userId, @PathVariable String serviceURLMarker) {
        return this.restAPI.getGovernanceEngineSummaries(serverName, userId, serviceURLMarker);
    }

    @GetMapping(path={"/governance-engines/{governanceEngineName}/refresh-config"})
    public VoidResponse refreshConfig(@PathVariable String serverName, @PathVariable String userId, @PathVariable String governanceEngineName) {
        return this.restAPI.refreshConfig(serverName, userId, governanceEngineName);
    }
}

