/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.engineservices.assetanalysis.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.governanceservers.enginehostservices.rest.GovernanceEngineSummariesResponse;
import org.odpi.openmetadata.governanceservers.enginehostservices.rest.GovernanceEngineSummaryResponse;
import org.odpi.openmetadata.governanceservers.enginehostservices.server.EngineHostRESTServices;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/engine-host/users/{userId}"})
@Tag(name="Engine Host Services", description="The Engine Host Services provide the core subsystem for the Engine Host OMAG Server.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/engine-host-services/"))
public class EngineHostServicesResource {
    private final EngineHostRESTServices restAPI = new EngineHostRESTServices();

    @GetMapping(path={"/governance-engines/{governanceEngineName}/summary"})
    @Operation(summary="getGovernanceEngineSummary", description="Retrieve the description and status of the requested governance engine.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-engine/"))
    public GovernanceEngineSummaryResponse getGovernanceEngineSummary(@PathVariable String serverName, @PathVariable String userId, @PathVariable String governanceEngineName) {
        return this.restAPI.getGovernanceEngineSummary(serverName, userId, governanceEngineName);
    }

    @GetMapping(path={"/governance-engines/summary"})
    @Operation(summary="getGovernanceEngineSummaries", description="Return a summary of each of the governance engines running in the Engine Host.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-engine/"))
    public GovernanceEngineSummariesResponse getGovernanceEngineSummaries(@PathVariable String serverName, @PathVariable String userId) {
        return this.restAPI.getGovernanceEngineSummaries(serverName, userId);
    }

    @GetMapping(path={"/engine-service/{serviceURLMarker}/governance-engines/summary"})
    @Operation(summary="getGovernanceServiceSummary", description="Retrieve the description and status of each governance engine assigned to a specific Open Metadata Engine Service (OMES).", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-engine/"))
    public GovernanceEngineSummariesResponse getGovernanceServiceSummary(@PathVariable String serverName, @PathVariable String userId, @PathVariable String serviceURLMarker) {
        return this.restAPI.getGovernanceEngineSummaries(serverName, userId, serviceURLMarker);
    }

    @GetMapping(path={"/governance-engines/{governanceEngineName}/refresh-config"})
    @Operation(summary="refreshConfig", description="Request that the governance engine refresh its configuration by calling the metadata server. This request is useful if the metadata server has an outage, particularly while the governance server is initializing.  This request just ensures that the latest configuration is in use.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-engine-definition/"))
    public VoidResponse refreshConfig(@PathVariable String serverName, @PathVariable String userId, @PathVariable String governanceEngineName) {
        return this.restAPI.refreshConfig(serverName, userId, governanceEngineName);
    }
}

