/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.feedbackmanager.converters;

import java.lang.reflect.InvocationTargetException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyHelper;
import org.odpi.openmetadata.viewservices.feedbackmanager.converters.FeedbackManagerConverterBase;
import org.odpi.openmetadata.viewservices.feedbackmanager.metadataelements.LikeElement;
import org.odpi.openmetadata.viewservices.feedbackmanager.properties.LikeProperties;

public class LikeConverter<B>
extends FeedbackManagerConverterBase<B> {
    public LikeConverter(PropertyHelper propertyHelper, String serviceName, String serverName) {
        super(propertyHelper, serviceName, serverName);
    }

    public B getNewBean(Class<B> beanClass, OpenMetadataElement openMetadataElement, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof LikeElement) {
                LikeElement bean = (LikeElement)returnBean;
                LikeProperties properties = new LikeProperties();
                bean.setElementHeader(super.getMetadataElementHeader(beanClass, openMetadataElement, methodName));
                if (openMetadataElement != null) {
                    properties.setUser(openMetadataElement.getVersions().getCreatedBy());
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), OpenMetadataElement.class.getName(), methodName);
                }
                bean.setProperties(properties);
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }
}

