/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.feedbackmanager.converters;

import java.lang.reflect.InvocationTargetException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyHelper;
import org.odpi.openmetadata.frameworks.openmetadata.enums.StarRating;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.viewservices.feedbackmanager.converters.FeedbackManagerConverterBase;
import org.odpi.openmetadata.viewservices.feedbackmanager.metadataelements.RatingElement;
import org.odpi.openmetadata.viewservices.feedbackmanager.properties.RatingProperties;

public class RatingConverter<B>
extends FeedbackManagerConverterBase<B> {
    public RatingConverter(PropertyHelper propertyHelper, String serviceName, String serverName) {
        super(propertyHelper, serviceName, serverName);
    }

    public B getNewBean(Class<B> beanClass, OpenMetadataElement openMetadataElement, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof RatingElement) {
                RatingElement bean = (RatingElement)returnBean;
                RatingProperties properties = new RatingProperties();
                bean.setElementHeader(super.getMetadataElementHeader(beanClass, openMetadataElement, methodName));
                if (openMetadataElement != null) {
                    ElementProperties elementProperties = new ElementProperties(openMetadataElement.getElementProperties());
                    properties.setReview(this.removeReview(elementProperties));
                    properties.setStarRating(this.removeStarRating(elementProperties));
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), OpenMetadataElement.class.getName(), methodName);
                }
                bean.setProperties(properties);
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    StarRating removeStarRating(ElementProperties elementProperties) {
        String methodName = "removeStarRating";
        if (elementProperties != null) {
            String retrievedProperty = this.propertyHelper.removeEnumProperty(this.serviceName, OpenMetadataProperty.STARS.name, elementProperties, "removeStarRating");
            for (StarRating starRating : StarRating.values()) {
                if (!starRating.getName().equals(retrievedProperty)) continue;
                return starRating;
            }
        }
        return null;
    }
}

