/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.feedbackmanager.handler;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.adminservices.configuration.registration.ViewServiceDescription;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElementStub;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElements;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyHelper;
import org.odpi.openmetadata.frameworks.openmetadata.enums.StarRating;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.viewservices.feedbackmanager.converters.CommentConverter;
import org.odpi.openmetadata.viewservices.feedbackmanager.converters.InformalTagConverter;
import org.odpi.openmetadata.viewservices.feedbackmanager.converters.LikeConverter;
import org.odpi.openmetadata.viewservices.feedbackmanager.converters.NoteConverter;
import org.odpi.openmetadata.viewservices.feedbackmanager.converters.NoteLogConverter;
import org.odpi.openmetadata.viewservices.feedbackmanager.converters.RatingConverter;
import org.odpi.openmetadata.viewservices.feedbackmanager.handler.OpenMetadataStoreHandler;
import org.odpi.openmetadata.viewservices.feedbackmanager.metadataelements.CommentElement;
import org.odpi.openmetadata.viewservices.feedbackmanager.metadataelements.InformalTagElement;
import org.odpi.openmetadata.viewservices.feedbackmanager.metadataelements.LikeElement;
import org.odpi.openmetadata.viewservices.feedbackmanager.metadataelements.NoteElement;
import org.odpi.openmetadata.viewservices.feedbackmanager.metadataelements.NoteLogElement;
import org.odpi.openmetadata.viewservices.feedbackmanager.metadataelements.RatingElement;
import org.odpi.openmetadata.viewservices.feedbackmanager.properties.CommentProperties;
import org.odpi.openmetadata.viewservices.feedbackmanager.properties.NoteLogProperties;
import org.odpi.openmetadata.viewservices.feedbackmanager.properties.NoteProperties;
import org.odpi.openmetadata.viewservices.feedbackmanager.properties.RatingProperties;
import org.odpi.openmetadata.viewservices.feedbackmanager.properties.TagProperties;

public class CollaborationManagerHandler {
    private final OpenMetadataStoreHandler client;
    private final InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private final AuditLog auditLog;
    private final PropertyHelper propertyHelper = new PropertyHelper();
    private final CommentConverter<CommentElement> commentConverter;
    private final InformalTagConverter<InformalTagElement> tagConverter;
    private final LikeConverter<LikeElement> likeConverter;
    private final NoteLogConverter<NoteLogElement> noteLogConverter;
    private final NoteConverter<NoteElement> noteConverter;
    private final RatingConverter<RatingElement> ratingConverter;

    public CollaborationManagerHandler(String localServerName, String serverName, String serverPlatformURLRoot, AuditLog auditLog, String accessServiceURLMarker, int maxPageSize) throws InvalidParameterException {
        this.client = new OpenMetadataStoreHandler(serverName, serverPlatformURLRoot, accessServiceURLMarker, maxPageSize);
        this.auditLog = auditLog;
        String serviceName = ViewServiceDescription.FEEDBACK_MANAGER.getViewServiceFullName();
        this.commentConverter = new CommentConverter(this.propertyHelper, serviceName, localServerName);
        this.tagConverter = new InformalTagConverter(this.propertyHelper, serviceName, localServerName);
        this.likeConverter = new LikeConverter(this.propertyHelper, serviceName, localServerName);
        this.noteLogConverter = new NoteLogConverter(this.propertyHelper, serviceName, localServerName);
        this.noteConverter = new NoteConverter(this.propertyHelper, serviceName, localServerName);
        this.ratingConverter = new RatingConverter(this.propertyHelper, serviceName, localServerName);
    }

    private void addFeedbackToElement(String userId, String elementGUID, String elementTypeName, String relationshipTypeName, boolean isPublic, ElementProperties elementProperties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        RelatedMetadataElement existingFeedback = this.getFeedbackForUser(userId, elementGUID, relationshipTypeName);
        ElementProperties relationshipProperties = this.propertyHelper.addBooleanProperty(null, OpenMetadataProperty.IS_PUBLIC.name, isPublic);
        if (existingFeedback == null) {
            this.client.createMetadataElementInStore(userId, elementTypeName, ElementStatus.ACTIVE, null, elementGUID, false, null, null, elementProperties, elementGUID, relationshipTypeName, relationshipProperties, true);
        } else {
            this.client.updateMetadataElementInStore(userId, existingFeedback.getElement().getElementGUID(), false, false, false, elementProperties, new Date());
            this.client.updateRelatedElementsInStore(userId, existingFeedback.getRelationshipGUID(), false, false, false, relationshipProperties, new Date());
        }
    }

    private RelatedMetadataElement getFeedbackForUser(String userId, String elementGUID, String relationshipTypeName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        int startFrom = 0;
        List attachedFeedbacks = this.client.getRelatedMetadataElements(userId, elementGUID, 1, relationshipTypeName, false, false, new Date(), startFrom, this.invalidParameterHandler.getMaxPagingSize());
        RelatedMetadataElement existingFeedback = null;
        while (existingFeedback == null && attachedFeedbacks != null) {
            for (RelatedMetadataElement attachedFeedback : attachedFeedbacks) {
                if (attachedFeedback == null || !userId.equals(attachedFeedback.getVersions().getCreatedBy())) continue;
                existingFeedback = attachedFeedback;
                break;
            }
            attachedFeedbacks = this.client.getRelatedMetadataElements(userId, elementGUID, 1, relationshipTypeName, false, false, new Date(), startFrom += this.invalidParameterHandler.getMaxPagingSize(), this.invalidParameterHandler.getMaxPagingSize());
        }
        return existingFeedback;
    }

    public void addRatingToElement(String userId, String elementGUID, boolean isPublic, RatingProperties properties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addRatingToElement";
        String propertiesParameterName = "properties";
        String starRatingParameterName = "properties.starRating";
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "addRatingToElement");
        this.invalidParameterHandler.validateObject((Object)properties.getStarRating(), "properties.starRating", "addRatingToElement");
        ElementProperties elementProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.REVIEW.name, properties.getReview());
        if (properties.getStarRating() != null) {
            elementProperties = this.propertyHelper.addEnumProperty(elementProperties, OpenMetadataProperty.STARS.name, StarRating.getOpenTypeName(), properties.getStarRating().getName());
        }
        this.addFeedbackToElement(userId, elementGUID, OpenMetadataType.RATING.typeName, OpenMetadataType.ATTACHED_RATING_RELATIONSHIP.typeName, isPublic, elementProperties);
    }

    public void removeRatingFromElement(String userId, String elementGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        RelatedMetadataElement existingRating = this.getFeedbackForUser(userId, elementGUID, OpenMetadataType.ATTACHED_RATING_RELATIONSHIP.typeName);
        if (existingRating != null) {
            this.client.deleteMetadataElementInStore(userId, existingRating.getElement().getElementGUID(), false, false, new Date());
        }
    }

    public void addLikeToElement(String userId, String elementGUID, boolean isPublic) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.addFeedbackToElement(userId, elementGUID, OpenMetadataType.LIKE.typeName, OpenMetadataType.ATTACHED_LIKE_RELATIONSHIP.typeName, isPublic, null);
    }

    public void removeLikeFromElement(String userId, String elementGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        RelatedMetadataElement existingLike = this.getFeedbackForUser(userId, elementGUID, OpenMetadataType.ATTACHED_LIKE_RELATIONSHIP.typeName);
        if (existingLike != null) {
            this.client.deleteMetadataElementInStore(userId, existingLike.getElement().getElementGUID(), false, false, new Date());
        }
    }

    public String addCommentToElement(String userId, String elementGUID, boolean isPublic, CommentProperties properties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addCommentToElement";
        ElementProperties elementProperties = this.getElementPropertiesForComment(properties, "addCommentToElement");
        ElementProperties relationshipProperties = this.propertyHelper.addBooleanProperty(null, OpenMetadataProperty.IS_PUBLIC.name, isPublic);
        return this.client.createMetadataElementInStore(userId, OpenMetadataType.COMMENT.typeName, ElementStatus.ACTIVE, null, elementGUID, false, properties.getEffectiveFrom(), properties.getEffectiveTo(), elementProperties, elementGUID, OpenMetadataType.ATTACHED_COMMENT_RELATIONSHIP.typeName, relationshipProperties, true);
    }

    private ElementProperties getElementPropertiesForComment(CommentProperties properties, String methodName) throws InvalidParameterException {
        String propertiesParameterName = "properties";
        String commentTextParameterName = "properties.commentText";
        this.invalidParameterHandler.validateObject((Object)properties, "properties", methodName);
        this.invalidParameterHandler.validateObject((Object)properties.getCommentText(), "properties.commentText", methodName);
        ElementProperties elementProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.TEXT.name, properties.getCommentText());
        if (properties.getCommentType() != null) {
            elementProperties = this.propertyHelper.addEnumProperty(elementProperties, OpenMetadataProperty.COMMENT_TYPE.name, StarRating.getOpenTypeName(), properties.getCommentType().getName());
        }
        return elementProperties;
    }

    public String addCommentReply(String userId, String elementGUID, String commentGUID, boolean isPublic, CommentProperties properties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addCommentToElement";
        ElementProperties elementProperties = this.getElementPropertiesForComment(properties, "addCommentToElement");
        ElementProperties relationshipProperties = this.propertyHelper.addBooleanProperty(null, OpenMetadataProperty.IS_PUBLIC.name, isPublic);
        return this.client.createMetadataElementInStore(userId, OpenMetadataType.COMMENT.typeName, ElementStatus.ACTIVE, null, elementGUID, false, properties.getEffectiveFrom(), properties.getEffectiveTo(), elementProperties, commentGUID, OpenMetadataType.ATTACHED_COMMENT_RELATIONSHIP.typeName, relationshipProperties, true);
    }

    public void updateComment(String userId, String commentGUID, boolean isMergeUpdate, CommentProperties properties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "updateComment";
        ElementProperties elementProperties = this.getElementPropertiesForComment(properties, "updateComment");
        this.client.updateMetadataElementInStore(userId, commentGUID, !isMergeUpdate, false, false, elementProperties, new Date());
    }

    public void updateCommentVisibility(String userId, String parentGUID, String commentGUID, boolean isPublic) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ElementProperties relationshipProperties = this.propertyHelper.addBooleanProperty(null, OpenMetadataProperty.IS_PUBLIC.name, isPublic);
        List relationships = this.client.getMetadataElementRelationships(userId, parentGUID, commentGUID, OpenMetadataType.ATTACHED_COMMENT_RELATIONSHIP.typeName, false, false, null, 0, 0);
        if (relationships != null) {
            for (RelatedMetadataElements relationship : relationships) {
                if (relationship == null) continue;
                this.client.updateRelatedElementsInStore(userId, relationship.getRelationshipGUID(), false, false, false, relationshipProperties, new Date());
                break;
            }
        }
    }

    public void setupAcceptedAnswer(String userId, String questionCommentGUID, String answerCommentGUID, boolean isPublic) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ElementProperties relationshipProperties = this.propertyHelper.addBooleanProperty(null, OpenMetadataProperty.IS_PUBLIC.name, isPublic);
        this.client.createRelatedElementsInStore(userId, OpenMetadataType.ACCEPTED_ANSWER_RELATIONSHIP.typeName, questionCommentGUID, answerCommentGUID, false, false, null, null, relationshipProperties, new Date());
    }

    public void clearAcceptedAnswer(String userId, String questionCommentGUID, String answerCommentGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List relationships = this.client.getMetadataElementRelationships(userId, questionCommentGUID, answerCommentGUID, OpenMetadataType.ACCEPTED_ANSWER_RELATIONSHIP.typeName, false, false, null, 0, 0);
        if (relationships != null) {
            for (RelatedMetadataElements relationship : relationships) {
                if (relationship == null) continue;
                this.client.deleteRelatedElementsInStore(userId, relationship.getRelationshipGUID(), false, false, new Date());
                break;
            }
        }
    }

    public void removeComment(String userId, String commentGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.client.deleteMetadataElementInStore(userId, commentGUID, false, false, new Date());
    }

    public CommentElement getComment(String userId, String commentGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getComment";
        OpenMetadataElement commentElement = this.client.getMetadataElementByGUID(userId, commentGUID, false, false, new Date());
        if (commentElement != null) {
            return this.commentConverter.getNewBean(CommentElement.class, commentElement, "getComment");
        }
        return null;
    }

    public List<CommentElement> getAttachedComments(String userId, String elementGUID, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getAttachedComments";
        List relatedMetadataElements = this.client.getRelatedMetadataElements(userId, elementGUID, 1, OpenMetadataType.ATTACHED_COMMENT_RELATIONSHIP.typeName, false, false, new Date(), startFrom, pageSize);
        return this.getCommentsFromRelatedMetadataElement(relatedMetadataElements, "getAttachedComments");
    }

    private List<CommentElement> getCommentsFromRelatedMetadataElement(List<RelatedMetadataElement> relatedMetadataElements, String methodName) throws PropertyServerException {
        if (relatedMetadataElements != null) {
            ArrayList<CommentElement> results = new ArrayList<CommentElement>();
            for (RelatedMetadataElement relatedMetadataElement : relatedMetadataElements) {
                if (relatedMetadataElement == null) continue;
                results.add(this.commentConverter.getNewBean(CommentElement.class, relatedMetadataElement.getElement(), methodName));
            }
            return results;
        }
        return null;
    }

    public List<CommentElement> findComments(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findComments";
        List openMetadataElements = this.client.findMetadataElementsWithString(userId, searchString, OpenMetadataType.COMMENT.typeName, false, false, new Date(), startFrom, pageSize);
        return this.getCommentsFromOpenMetadataElement(openMetadataElements, "findComments");
    }

    private List<CommentElement> getCommentsFromOpenMetadataElement(List<OpenMetadataElement> openMetadataElements, String methodName) throws PropertyServerException {
        if (openMetadataElements != null) {
            ArrayList<CommentElement> results = new ArrayList<CommentElement>();
            for (OpenMetadataElement openMetadataElement : openMetadataElements) {
                if (openMetadataElement == null) continue;
                results.add(this.commentConverter.getNewBean(CommentElement.class, openMetadataElement, methodName));
            }
            return results;
        }
        return null;
    }

    public String createInformalTag(String userId, TagProperties properties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "createInformalTag";
        String propertiesParameterName = "properties";
        String nameParameterName = "properties.name";
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "createInformalTag");
        this.invalidParameterHandler.validateName(properties.getName(), "properties.name", "createInformalTag");
        ElementProperties elementProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.TAG_NAME.name, properties.getName());
        elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.TAG_DESCRIPTION.name, properties.getDescription());
        elementProperties = this.propertyHelper.addBooleanProperty(elementProperties, OpenMetadataProperty.IS_PUBLIC.name, !properties.getIsPrivateTag());
        return this.client.createMetadataElementInStore(userId, OpenMetadataType.INFORMAL_TAG.typeName, ElementStatus.ACTIVE, null, null, true, null, null, elementProperties, null, null, null, true);
    }

    public void updateTagDescription(String userId, String tagGUID, String tagDescription) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.client.updateMetadataElementInStore(userId, tagGUID, false, false, false, this.propertyHelper.addStringProperty(null, OpenMetadataProperty.TAG_DESCRIPTION.name, tagDescription), new Date());
    }

    public void deleteTag(String userId, String tagGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.client.deleteMetadataElementInStore(userId, tagGUID, false, false, new Date());
    }

    public InformalTagElement getTag(String userId, String tagGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getTag";
        OpenMetadataElement openMetadataElement = this.client.getMetadataElementByGUID(userId, tagGUID, false, false, new Date());
        if (openMetadataElement != null) {
            return this.tagConverter.getNewBean(InformalTagElement.class, openMetadataElement, "getTag");
        }
        return null;
    }

    public List<InformalTagElement> getTagsByName(String userId, String tag, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return null;
    }

    public List<InformalTagElement> getMyTagsByName(String userId, String tag, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return null;
    }

    public List<InformalTagElement> findTags(String userId, String tag, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return null;
    }

    public List<InformalTagElement> findMyTags(String userId, String tag, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return null;
    }

    public void addTagToElement(String userId, String elementGUID, String tagGUID, boolean isPublic) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
    }

    public void removeTagFromElement(String userId, String elementGUID, String tagGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
    }

    public List<RelatedMetadataElementStub> getElementsByTag(String userId, String tagGUID, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return null;
    }

    public String createNoteLog(String userId, String elementGUID, NoteLogProperties noteLogProperties, boolean isPublic) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    public void updateNoteLog(String userId, String noteLogGUID, boolean isMergeUpdate, boolean isPublic, NoteLogProperties noteLogProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    public void removeNoteLog(String userId, String noteLogGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.deleteMetadataElementInStore(userId, noteLogGUID, false, false, new Date());
    }

    public List<NoteLogElement> findNoteLogs(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    public List<NoteLogElement> getNoteLogsByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    public List<NoteLogElement> getNoteLogsForElement(String userId, String elementGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    public NoteLogElement getNoteLogByGUID(String userId, String noteLogGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getNoteLogByGUID";
        OpenMetadataElement openMetadataElement = this.client.getMetadataElementByGUID(userId, noteLogGUID, false, false, new Date());
        if (openMetadataElement != null) {
            return this.noteLogConverter.getNewBean(NoteLogElement.class, openMetadataElement, "getNoteLogByGUID");
        }
        return null;
    }

    public String createNote(String userId, String noteLogGUID, NoteProperties noteProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    public void updateNote(String userId, String noteGUID, boolean isMergeUpdate, NoteProperties noteProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    public void removeNote(String userId, String noteGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.client.deleteMetadataElementInStore(userId, noteGUID, false, false, new Date());
    }

    public List<NoteElement> findNotes(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    public List<NoteElement> getNotesForNoteLog(String userId, String noteLogGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    public NoteElement getNoteByGUID(String userId, String noteGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getNoteByGUID";
        OpenMetadataElement openMetadataElement = this.client.getMetadataElementByGUID(userId, noteGUID, false, false, new Date());
        if (openMetadataElement != null) {
            return this.noteConverter.getNewBean(NoteElement.class, openMetadataElement, "getNoteByGUID");
        }
        return null;
    }
}

