/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.feedbackmanager.server;

import java.util.HashMap;
import java.util.Map;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.adminservices.configuration.registration.ViewServiceDescription;
import org.odpi.openmetadata.commonservices.multitenant.OMVSServiceInstance;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.viewservices.feedbackmanager.handler.CollaborationManagerHandler;

public class FeedbackManagerInstance
extends OMVSServiceInstance {
    private static final ViewServiceDescription myDescription = ViewServiceDescription.FEEDBACK_MANAGER;
    private final Map<String, CollaborationManagerHandler> collaborationManagerHandlerMap = new HashMap<String, CollaborationManagerHandler>();

    public FeedbackManagerInstance(String serverName, AuditLog auditLog, String localServerUserId, int maxPageSize, String remoteServerName, String remoteServerURL) throws InvalidParameterException {
        super(serverName, myDescription.getViewServiceName(), auditLog, localServerUserId, maxPageSize, remoteServerName, remoteServerURL);
        CollaborationManagerHandler collaborationManagerHandler = new CollaborationManagerHandler(serverName, remoteServerName, remoteServerURL, auditLog, AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceURLMarker(), maxPageSize);
        this.collaborationManagerHandlerMap.put(AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceURLMarker(), collaborationManagerHandler);
        this.collaborationManagerHandlerMap.put(ViewServiceDescription.FEEDBACK_MANAGER.getViewServiceURLMarker(), collaborationManagerHandler);
    }

    public CollaborationManagerHandler getCollaborationManagerHandler(String viewServiceURLMarker, String accessServiceURLMarker) throws InvalidParameterException {
        CollaborationManagerHandler collaborationManagerHandler = null;
        if (viewServiceURLMarker != null) {
            collaborationManagerHandler = this.collaborationManagerHandlerMap.get(viewServiceURLMarker);
            for (ViewServiceDescription viewServiceDescription : ViewServiceDescription.values()) {
                String viewServicePartnerService;
                if (!viewServiceDescription.getViewServiceURLMarker().equals(viewServiceURLMarker) || (viewServicePartnerService = viewServiceDescription.getViewServicePartnerService()) == null) continue;
                for (AccessServiceDescription accessServiceDescription : AccessServiceDescription.values()) {
                    if (!accessServiceDescription.getAccessServiceFullName().equals(viewServicePartnerService)) continue;
                    collaborationManagerHandler = new CollaborationManagerHandler(this.serverName, this.remoteServerName, this.remoteServerURL, this.auditLog, accessServiceDescription.getAccessServiceURLMarker(), this.maxPageSize);
                    this.collaborationManagerHandlerMap.put(accessServiceDescription.getAccessServiceURLMarker(), collaborationManagerHandler);
                    this.collaborationManagerHandlerMap.put(viewServiceURLMarker, collaborationManagerHandler);
                }
            }
        }
        if (collaborationManagerHandler == null && (collaborationManagerHandler = this.collaborationManagerHandlerMap.get(accessServiceURLMarker)) == null) {
            for (ViewServiceDescription viewServiceDescription : AccessServiceDescription.values()) {
                if (!viewServiceDescription.getAccessServiceURLMarker().equals(accessServiceURLMarker)) continue;
                collaborationManagerHandler = new CollaborationManagerHandler(this.serverName, this.remoteServerName, this.remoteServerURL, this.auditLog, accessServiceURLMarker, this.maxPageSize);
                this.collaborationManagerHandlerMap.put(accessServiceURLMarker, collaborationManagerHandler);
            }
        }
        return collaborationManagerHandler;
    }
}

