/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.feedbackmanager.server;

import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.tokencontroller.TokenController;
import org.odpi.openmetadata.viewservices.feedbackmanager.handler.CollaborationManagerHandler;
import org.odpi.openmetadata.viewservices.feedbackmanager.properties.CommentProperties;
import org.odpi.openmetadata.viewservices.feedbackmanager.properties.FeedbackProperties;
import org.odpi.openmetadata.viewservices.feedbackmanager.properties.RatingProperties;
import org.odpi.openmetadata.viewservices.feedbackmanager.properties.ReferenceableProperties;
import org.odpi.openmetadata.viewservices.feedbackmanager.properties.RelationshipProperties;
import org.odpi.openmetadata.viewservices.feedbackmanager.properties.TagProperties;
import org.odpi.openmetadata.viewservices.feedbackmanager.rest.CommentElementsResponse;
import org.odpi.openmetadata.viewservices.feedbackmanager.rest.CommentResponse;
import org.odpi.openmetadata.viewservices.feedbackmanager.rest.InformalTagResponse;
import org.odpi.openmetadata.viewservices.feedbackmanager.rest.InformalTagUpdateRequestBody;
import org.odpi.openmetadata.viewservices.feedbackmanager.rest.InformalTagsResponse;
import org.odpi.openmetadata.viewservices.feedbackmanager.rest.NoteLogResponse;
import org.odpi.openmetadata.viewservices.feedbackmanager.rest.NoteLogsResponse;
import org.odpi.openmetadata.viewservices.feedbackmanager.rest.NoteResponse;
import org.odpi.openmetadata.viewservices.feedbackmanager.rest.NotesResponse;
import org.odpi.openmetadata.viewservices.feedbackmanager.rest.ReferenceableUpdateRequestBody;
import org.odpi.openmetadata.viewservices.feedbackmanager.rest.RelatedElementsResponse;
import org.odpi.openmetadata.viewservices.feedbackmanager.rest.RelationshipRequestBody;
import org.odpi.openmetadata.viewservices.feedbackmanager.server.FeedbackManagerInstanceHandler;
import org.slf4j.LoggerFactory;

public class FeedbackManagerRESTServices
extends TokenController {
    private static final FeedbackManagerInstanceHandler instanceHandler = new FeedbackManagerInstanceHandler();
    private static final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(FeedbackManagerRESTServices.class), instanceHandler.getServiceName());

    public VoidResponse addRatingToElement(String serverName, String guid, boolean isPublic, String viewServiceURLMarker, String accessServiceURLMarker, RatingProperties requestBody) {
        String methodName = "addRatingToElement";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "addRatingToElement");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "addRatingToElement");
            restCallLogger.setUserId(token, userId);
            if (requestBody != null) {
                CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "addRatingToElement");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addRatingToElement");
                handler.addRatingToElement(userId, guid, isPublic, requestBody);
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "addRatingToElement", serverName, RatingProperties.class.getName());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addRatingToElement", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeRatingFromElement(String serverName, String guid, String viewServiceURLMarker, String accessServiceURLMarker, NullRequestBody requestBody) {
        String methodName = "removeRatingFromElement";
        String guidParameterName = "guid";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "removeRatingFromElement");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "removeRatingFromElement");
            restCallLogger.setUserId(token, userId);
            CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "removeRatingFromElement");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeRatingFromElement");
            handler.removeRatingFromElement(userId, guid);
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeRatingFromElement", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addLikeToElement(String serverName, String guid, boolean isPublic, String viewServiceURLMarker, String accessServiceURLMarker, NullRequestBody requestBody) {
        String methodName = "addLikeToElement";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "addLikeToElement");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "addLikeToElement");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addLikeToElement");
            CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "addLikeToElement");
            handler.addLikeToElement(userId, guid, isPublic);
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addLikeToElement", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeLikeFromElement(String serverName, String guid, String viewServiceURLMarker, String accessServiceURLMarker, NullRequestBody requestBody) {
        String methodName = "removeLikeFromElement";
        String guidParameterName = "guid";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "removeLikeFromElement");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "removeLikeFromElement");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeLikeFromElement");
            CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "removeLikeFromElement");
            handler.removeLikeFromElement(userId, guid);
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeLikeFromElement", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse addCommentToElement(String serverName, String elementGUID, boolean isPublic, String viewServiceURLMarker, String accessServiceURLMarker, ReferenceableUpdateRequestBody requestBody) {
        String methodName = "addCommentToElement";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "addCommentToElement");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "addCommentToElement");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addCommentToElement");
            CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "addCommentToElement");
            if (requestBody != null) {
                ReferenceableProperties referenceableProperties = requestBody.getElementProperties();
                if (referenceableProperties instanceof CommentProperties) {
                    CommentProperties commentProperties = (CommentProperties)referenceableProperties;
                    response.setGUID(handler.addCommentToElement(userId, elementGUID, isPublic, commentProperties));
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(CommentProperties.class.getName(), "addCommentToElement");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "addCommentToElement", serverName, ReferenceableUpdateRequestBody.class.getName());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addCommentToElement", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse addCommentReply(String serverName, String elementGUID, String commentGUID, boolean isPublic, String viewServiceURLMarker, String accessServiceURLMarker, ReferenceableUpdateRequestBody requestBody) {
        String methodName = "addCommentReply";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "addCommentReply");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "addCommentReply");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addCommentReply");
            if (requestBody != null) {
                ReferenceableProperties referenceableProperties = requestBody.getElementProperties();
                if (referenceableProperties instanceof CommentProperties) {
                    CommentProperties commentProperties = (CommentProperties)referenceableProperties;
                    CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "addCommentReply");
                    response.setGUID(handler.addCommentReply(userId, elementGUID, commentGUID, isPublic, commentProperties));
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(CommentProperties.class.getName(), "addCommentReply");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "addCommentReply", serverName, ReferenceableUpdateRequestBody.class.getName());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addCommentReply", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateComment(String serverName, String commentGUID, boolean isMergeUpdate, String viewServiceURLMarker, String accessServiceURLMarker, ReferenceableUpdateRequestBody requestBody) {
        String methodName = "updateComment";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "updateComment");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "updateComment");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateComment");
            if (requestBody != null) {
                ReferenceableProperties referenceableProperties = requestBody.getElementProperties();
                if (referenceableProperties instanceof CommentProperties) {
                    CommentProperties commentProperties = (CommentProperties)referenceableProperties;
                    CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "updateComment");
                    handler.updateComment(userId, commentGUID, isMergeUpdate, commentProperties);
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(CommentProperties.class.getName(), "updateComment");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateComment", serverName, ReferenceableUpdateRequestBody.class.getName());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateComment", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateCommentVisibility(String serverName, String parentGUID, String commentGUID, boolean isPublic, String viewServiceURLMarker, String accessServiceURLMarker, NullRequestBody requestBody) {
        String methodName = "updateCommentVisibility";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "updateCommentVisibility");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "updateCommentVisibility");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateCommentVisibility");
            CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "updateCommentVisibility");
            handler.updateCommentVisibility(userId, parentGUID, commentGUID, isPublic);
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateCommentVisibility", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupAcceptedAnswer(String serverName, String questionCommentGUID, String answerCommentGUID, String viewServiceURLMarker, String accessServiceURLMarker, RelationshipRequestBody requestBody) {
        String methodName = "setupAcceptedAnswer";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "setupAcceptedAnswer");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "setupAcceptedAnswer");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupAcceptedAnswer");
            CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "setupAcceptedAnswer");
            if (requestBody != null) {
                RelationshipProperties relationshipProperties = requestBody.getProperties();
                if (relationshipProperties instanceof FeedbackProperties) {
                    FeedbackProperties feedbackProperties = (FeedbackProperties)relationshipProperties;
                    handler.setupAcceptedAnswer(userId, questionCommentGUID, answerCommentGUID, feedbackProperties.getIsPublic());
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(CommentProperties.class.getName(), "setupAcceptedAnswer");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setupAcceptedAnswer", serverName, RelationshipRequestBody.class.getName());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupAcceptedAnswer", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearAcceptedAnswer(String serverName, String questionCommentGUID, String answerCommentGUID, String viewServiceURLMarker, String accessServiceURLMarker, NullRequestBody requestBody) {
        String methodName = "clearAcceptedAnswer";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "clearAcceptedAnswer");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "clearAcceptedAnswer");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearAcceptedAnswer");
            CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "clearAcceptedAnswer");
            handler.clearAcceptedAnswer(userId, questionCommentGUID, answerCommentGUID);
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearAcceptedAnswer", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeCommentFromElement(String serverName, String elementGUID, String commentGUID, String viewServiceURLMarker, String accessServiceURLMarker, ReferenceableUpdateRequestBody requestBody) {
        String guidParameterName = "commentGUID";
        String methodName = "removeElementComment";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "removeElementComment");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "removeElementComment");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeElementComment");
            CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "removeElementComment");
            handler.removeComment(userId, commentGUID);
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeElementComment", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public CommentResponse getCommentByGUID(String serverName, String commentGUID, String viewServiceURLMarker, String accessServiceURLMarker) {
        String methodName = "getComment";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getComment");
        CommentResponse response = new CommentResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getComment");
            restCallLogger.setUserId(token, userId);
            CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "getComment");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getComment");
            response.setElement(handler.getComment(userId, commentGUID));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getComment", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public CommentElementsResponse getAttachedComments(String serverName, String elementGUID, int startFrom, int pageSize, String viewServiceURLMarker, String accessServiceURLMarker) {
        String methodName = "getAttachedComments";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getAttachedComments");
        CommentElementsResponse response = new CommentElementsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getAttachedComments");
            restCallLogger.setUserId(token, userId);
            CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "getAttachedComments");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAttachedComments");
            response.setElementList(handler.getAttachedComments(userId, elementGUID, startFrom, pageSize));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getAttachedComments", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public CommentElementsResponse findComments(String serverName, int startFrom, int pageSize, boolean startsWith, boolean endsWith, boolean ignoreCase, String viewServiceURLMarker, String accessServiceURLMarker, SearchStringRequestBody requestBody) {
        String methodName = "findComments";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "findComments");
        CommentElementsResponse response = new CommentElementsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "findComments");
            restCallLogger.setUserId(token, userId);
            CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "findComments");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findComments");
            if (requestBody != null) {
                response.setElementList(handler.findComments(userId, instanceHandler.getSearchString(requestBody.getSearchString(), startsWith, endsWith, ignoreCase), startFrom, pageSize));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "findComments", serverName, SearchStringRequestBody.class.getName());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findComments", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createInformalTag(String serverName, String viewServiceURLMarker, String accessServiceURLMarker, TagProperties requestBody) {
        String methodName = "createTag";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "createTag");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "createTag");
            restCallLogger.setUserId(token, userId);
            if (requestBody != null) {
                CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "createTag");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "createTag");
                response.setGUID(handler.createInformalTag(userId, requestBody));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createTag", serverName, TagProperties.class.getName());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createTag", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateTagDescription(String serverName, String tagGUID, String viewServiceURLMarker, String accessServiceURLMarker, InformalTagUpdateRequestBody requestBody) {
        String methodName = "updateTagDescription";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "updateTagDescription");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "updateTagDescription");
            restCallLogger.setUserId(token, userId);
            if (requestBody != null) {
                CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "updateTagDescription");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "updateTagDescription");
                handler.updateTagDescription(userId, tagGUID, requestBody.getDescription());
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateTagDescription", serverName, InformalTagUpdateRequestBody.class.getName());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateTagDescription", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteTag(String serverName, String tagGUID, String viewServiceURLMarker, String accessServiceURLMarker, NullRequestBody requestBody) {
        String methodName = "deleteTag";
        String tagGUIDParameterName = "tagGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "deleteTag");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "deleteTag");
            restCallLogger.setUserId(token, userId);
            CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "deleteTag");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteTag");
            handler.deleteTag(userId, tagGUID);
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "deleteTag", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public InformalTagResponse getTag(String serverName, String viewServiceURLMarker, String accessServiceURLMarker, String guid) {
        String methodName = "getTag";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getTag");
        InformalTagResponse response = new InformalTagResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getTag");
            restCallLogger.setUserId(token, userId);
            CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "getTag");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getTag");
            response.setTag(handler.getTag(userId, guid));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getTag", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public InformalTagsResponse getTagsByName(String serverName, NameRequestBody requestBody, int startFrom, int pageSize, String viewServiceURLMarker, String accessServiceURLMarker) {
        String methodName = "getTagsByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getTagsByName");
        InformalTagsResponse response = new InformalTagsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getTagsByName");
            restCallLogger.setUserId(token, userId);
            CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "getTagsByName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getTagsByName");
            if (requestBody != null) {
                response.setTags(handler.getTagsByName(userId, requestBody.getName(), startFrom, pageSize));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "getTagsByName", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getTagsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public InformalTagsResponse getMyTagsByName(String serverName, NameRequestBody requestBody, int startFrom, int pageSize, String viewServiceURLMarker, String accessServiceURLMarker) {
        String methodName = "getMyTagsByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getMyTagsByName");
        InformalTagsResponse response = new InformalTagsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getMyTagsByName");
            restCallLogger.setUserId(token, userId);
            CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "getMyTagsByName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMyTagsByName");
            if (requestBody != null) {
                response.setTags(handler.getMyTagsByName(userId, requestBody.getName(), startFrom, pageSize));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "getMyTagsByName", serverName, NameRequestBody.class.getName());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getMyTagsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public InformalTagsResponse findTags(String serverName, int startFrom, int pageSize, boolean startsWith, boolean endsWith, boolean ignoreCase, String viewServiceURLMarker, String accessServiceURLMarker, SearchStringRequestBody requestBody) {
        String methodName = "findTags";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "findTags");
        InformalTagsResponse response = new InformalTagsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "findTags");
            restCallLogger.setUserId(token, userId);
            CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "findTags");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findTags");
            if (requestBody != null) {
                response.setTags(handler.findTags(userId, instanceHandler.getSearchString(requestBody.getSearchString(), startsWith, endsWith, ignoreCase), startFrom, pageSize));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "findTags", serverName, SearchStringRequestBody.class.getName());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findTags", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public InformalTagsResponse findMyTags(String serverName, int startFrom, int pageSize, boolean startsWith, boolean endsWith, boolean ignoreCase, String viewServiceURLMarker, String accessServiceURLMarker, SearchStringRequestBody requestBody) {
        String methodName = "findMyTags";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "findMyTags");
        InformalTagsResponse response = new InformalTagsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "findMyTags");
            restCallLogger.setUserId(token, userId);
            CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "findMyTags");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findMyTags");
            if (requestBody != null) {
                response.setTags(handler.findMyTags(userId, instanceHandler.getSearchString(requestBody.getSearchString(), startsWith, endsWith, ignoreCase), startFrom, pageSize));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "findMyTags", serverName, SearchStringRequestBody.class.getName());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findMyTags", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addTagToElement(String serverName, String elementGUID, String tagGUID, String viewServiceURLMarker, String accessServiceURLMarker, FeedbackProperties requestBody) {
        String methodName = "addTagToElement";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "addTagToElement");
        boolean isPublic = false;
        if (requestBody != null) {
            isPublic = requestBody.getIsPublic();
        }
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "addTagToElement");
            restCallLogger.setUserId(token, userId);
            CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "addTagToElement");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addTagToElement");
            handler.addTagToElement(userId, elementGUID, tagGUID, isPublic);
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addTagToElement", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeTagFromElement(String serverName, String elementGUID, String tagGUID, String viewServiceURLMarker, String accessServiceURLMarker, NullRequestBody requestBody) {
        String methodName = "removeTagFromElement";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "removeTagFromElement");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "removeTagFromElement");
            restCallLogger.setUserId(token, userId);
            CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "removeTagFromElement");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeTagFromElement");
            handler.removeTagFromElement(userId, elementGUID, tagGUID);
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeTagFromElement", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementsResponse getElementsByTag(String serverName, String tagGUID, int startFrom, int pageSize, String viewServiceURLMarker, String accessServiceURLMarker) {
        String methodName = "getElementsByTag";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getElementsByTag");
        RelatedElementsResponse response = new RelatedElementsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getElementsByTag");
            restCallLogger.setUserId(token, userId);
            CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "getElementsByTag");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getElementsByTag");
            response.setElementList(handler.getElementsByTag(userId, tagGUID, startFrom, pageSize));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getElementsByTag", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public NoteLogsResponse findNoteLogs(String serverName, int startFrom, int pageSize, boolean startsWith, boolean endsWith, boolean ignoreCase, String viewServiceURLMarker, String accessServiceURLMarker, SearchStringRequestBody requestBody) {
        String methodName = "findNoteLogs";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "findNoteLogs");
        NoteLogsResponse response = new NoteLogsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "findNoteLogs");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findNoteLogs");
            if (requestBody != null) {
                CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "findNoteLogs");
                response.setElementList(handler.findNoteLogs(userId, instanceHandler.getSearchString(requestBody.getSearchString(), startsWith, endsWith, ignoreCase), startFrom, pageSize));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "findNoteLogs", serverName, SearchStringRequestBody.class.getName());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findNoteLogs", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public NoteLogsResponse getNoteLogsByName(String serverName, int startFrom, int pageSize, String viewServiceURLMarker, String accessServiceURLMarker, NameRequestBody requestBody) {
        String methodName = "getNoteLogsByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getNoteLogsByName");
        NoteLogsResponse response = new NoteLogsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getNoteLogsByName");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getNoteLogsByName");
            CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "getNoteLogsByName");
            response.setElementList(handler.getNoteLogsByName(userId, requestBody.getName(), startFrom, pageSize));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getNoteLogsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public NoteLogsResponse getNoteLogsForElement(String serverName, String elementGUID, int startFrom, int pageSize, String viewServiceURLMarker, String accessServiceURLMarker) {
        String methodName = "getNotesForNoteLog";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getNotesForNoteLog");
        NoteLogsResponse response = new NoteLogsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getNotesForNoteLog");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getNotesForNoteLog");
            CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "getNotesForNoteLog");
            response.setElementList(handler.getNoteLogsForElement(userId, elementGUID, startFrom, pageSize));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getNotesForNoteLog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public NoteLogResponse getNoteLogByGUID(String serverName, String noteLogGUID, String viewServiceURLMarker, String accessServiceURLMarker) {
        String methodName = "getNoteLogByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getNoteLogByGUID");
        NoteLogResponse response = new NoteLogResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getNoteLogByGUID");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getNoteLogByGUID");
            CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "getNoteLogByGUID");
            response.setElement(handler.getNoteLogByGUID(userId, noteLogGUID));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getNoteLogByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public NotesResponse findNotes(String serverName, int startFrom, int pageSize, boolean startsWith, boolean endsWith, boolean ignoreCase, String viewServiceURLMarker, String accessServiceURLMarker, SearchStringRequestBody requestBody) {
        String methodName = "findNotes";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "findNotes");
        NotesResponse response = new NotesResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "findNotes");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findNotes");
            if (requestBody != null) {
                CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "findNotes");
                response.setElementList(handler.findNotes(userId, instanceHandler.getSearchString(requestBody.getSearchString(), startsWith, endsWith, ignoreCase), startFrom, pageSize));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "findNotes", serverName, SearchStringRequestBody.class.getName());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findNotes", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public NotesResponse getNotesForNoteLog(String serverName, String noteLogGUID, int startFrom, int pageSize, String viewServiceURLMarker, String accessServiceURLMarker) {
        String methodName = "getNotesForNoteLog";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getNotesForNoteLog");
        NotesResponse response = new NotesResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getNotesForNoteLog");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getNotesForNoteLog");
            CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "getNotesForNoteLog");
            response.setElementList(handler.getNotesForNoteLog(userId, noteLogGUID, startFrom, pageSize));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getNotesForNoteLog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public NoteResponse getNoteByGUID(String serverName, String noteGUID, String viewServiceURLMarker, String accessServiceURLMarker) {
        String methodName = "getNoteByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getNoteByGUID");
        NoteResponse response = new NoteResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getNoteByGUID");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getNoteByGUID");
            CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "getNoteByGUID");
            response.setElement(handler.getNoteByGUID(userId, noteGUID));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getNoteByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

