/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.feedbackmanager.converters;

import java.lang.reflect.InvocationTargetException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyHelper;
import org.odpi.openmetadata.frameworks.openmetadata.properties.feedback.InformalTagProperties;
import org.odpi.openmetadata.viewservices.feedbackmanager.converters.FeedbackManagerConverterBase;
import org.odpi.openmetadata.viewservices.feedbackmanager.metadataelements.InformalTagElement;

public class InformalTagConverter<B>
extends FeedbackManagerConverterBase<B> {
    public InformalTagConverter(PropertyHelper propertyHelper, String serviceName, String serverName) {
        super(propertyHelper, serviceName, serverName);
    }

    public B getNewBean(Class<B> beanClass, OpenMetadataElement openMetadataElement, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof InformalTagElement) {
                InformalTagElement bean = (InformalTagElement)returnBean;
                InformalTagProperties properties = new InformalTagProperties();
                bean.setElementHeader(super.getMetadataElementHeader(beanClass, openMetadataElement, methodName));
                if (openMetadataElement != null) {
                    ElementProperties elementProperties = new ElementProperties(openMetadataElement.getElementProperties());
                    properties.setIsPrivateTag(!this.removeIsPublic(elementProperties));
                    properties.setName(this.removeTagName(elementProperties));
                    properties.setDescription(this.removeTagDescription(elementProperties));
                    properties.setUser(openMetadataElement.getVersions().getCreatedBy());
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), OpenMetadataElement.class.getName(), methodName);
                }
                bean.setProperties(properties);
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }
}

