/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.feedbackmanager.server;

import java.util.Date;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FilterRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.properties.ReferenceableProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.feedback.CommentProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.feedback.NoteLogProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.feedback.NoteProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.feedback.RatingProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.feedback.TagProperties;
import org.odpi.openmetadata.tokencontroller.TokenController;
import org.odpi.openmetadata.viewservices.feedbackmanager.handler.CollaborationManagerHandler;
import org.odpi.openmetadata.viewservices.feedbackmanager.rest.CommentElementsResponse;
import org.odpi.openmetadata.viewservices.feedbackmanager.rest.CommentResponse;
import org.odpi.openmetadata.viewservices.feedbackmanager.rest.EffectiveTimeQueryRequestBody;
import org.odpi.openmetadata.viewservices.feedbackmanager.rest.InformalTagResponse;
import org.odpi.openmetadata.viewservices.feedbackmanager.rest.InformalTagUpdateRequestBody;
import org.odpi.openmetadata.viewservices.feedbackmanager.rest.InformalTagsResponse;
import org.odpi.openmetadata.viewservices.feedbackmanager.rest.LikeElementsResponse;
import org.odpi.openmetadata.viewservices.feedbackmanager.rest.NoteLogResponse;
import org.odpi.openmetadata.viewservices.feedbackmanager.rest.NoteLogsResponse;
import org.odpi.openmetadata.viewservices.feedbackmanager.rest.NoteResponse;
import org.odpi.openmetadata.viewservices.feedbackmanager.rest.NotesResponse;
import org.odpi.openmetadata.viewservices.feedbackmanager.rest.RatingElementsResponse;
import org.odpi.openmetadata.viewservices.feedbackmanager.rest.ReferenceableUpdateRequestBody;
import org.odpi.openmetadata.viewservices.feedbackmanager.rest.RelatedElementsResponse;
import org.odpi.openmetadata.viewservices.feedbackmanager.server.FeedbackManagerInstanceHandler;
import org.slf4j.LoggerFactory;

public class FeedbackManagerRESTServices
extends TokenController {
    private static final FeedbackManagerInstanceHandler instanceHandler = new FeedbackManagerInstanceHandler();
    private static final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(FeedbackManagerRESTServices.class), instanceHandler.getServiceName());

    public VoidResponse addRatingToElement(String serverName, String guid, boolean isPublic, String viewServiceURLMarker, String accessServiceURLMarker, RatingProperties requestBody) {
        String methodName = "addRatingToElement";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "addRatingToElement");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "addRatingToElement");
            restCallLogger.setUserId(token, userId);
            if (requestBody != null) {
                CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "addRatingToElement");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addRatingToElement");
                handler.addRatingToElement(userId, guid, isPublic, requestBody, new Date());
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "addRatingToElement", serverName, RatingProperties.class.getName());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addRatingToElement", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeRatingFromElement(String serverName, String guid, String viewServiceURLMarker, String accessServiceURLMarker, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "removeRatingFromElement";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "removeRatingFromElement");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "removeRatingFromElement");
            restCallLogger.setUserId(token, userId);
            CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "removeRatingFromElement");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeRatingFromElement");
            if (requestBody != null) {
                handler.removeRatingFromElement(userId, guid, requestBody.getEffectiveTime());
            } else {
                handler.removeRatingFromElement(userId, guid, new Date());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeRatingFromElement", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RatingElementsResponse getAttachedRatings(String serverName, String elementGUID, int startFrom, int pageSize, String viewServiceURLMarker, String accessServiceURLMarker, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getAttachedRatings";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getAttachedRatings");
        RatingElementsResponse response = new RatingElementsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getAttachedRatings");
            restCallLogger.setUserId(token, userId);
            CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "getAttachedRatings");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAttachedRatings");
            if (requestBody != null) {
                response.setElementList(handler.getAttachedRatings(userId, elementGUID, startFrom, pageSize, requestBody.getEffectiveTime()));
            } else {
                response.setElementList(handler.getAttachedRatings(userId, elementGUID, startFrom, pageSize, new Date()));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getAttachedRatings", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addLikeToElement(String serverName, String guid, boolean isPublic, String viewServiceURLMarker, String accessServiceURLMarker, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "addLikeToElement";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "addLikeToElement");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "addLikeToElement");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addLikeToElement");
            CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "addLikeToElement");
            if (requestBody != null) {
                handler.addLikeToElement(userId, guid, isPublic, requestBody.getEffectiveTime());
            } else {
                handler.addLikeToElement(userId, guid, isPublic, new Date());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addLikeToElement", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeLikeFromElement(String serverName, String guid, String viewServiceURLMarker, String accessServiceURLMarker, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "removeLikeFromElement";
        String guidParameterName = "guid";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "removeLikeFromElement");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "removeLikeFromElement");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeLikeFromElement");
            CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "removeLikeFromElement");
            if (requestBody != null) {
                handler.removeLikeFromElement(userId, guid, requestBody.getEffectiveTime());
            } else {
                handler.removeLikeFromElement(userId, guid, null);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeLikeFromElement", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public LikeElementsResponse getAttachedLikes(String serverName, String elementGUID, int startFrom, int pageSize, String viewServiceURLMarker, String accessServiceURLMarker, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getAttachedLikes";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getAttachedLikes");
        LikeElementsResponse response = new LikeElementsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getAttachedLikes");
            restCallLogger.setUserId(token, userId);
            CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "getAttachedLikes");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAttachedLikes");
            if (requestBody != null) {
                response.setElementList(handler.getAttachedLikes(userId, elementGUID, startFrom, pageSize, requestBody.getEffectiveTime()));
            } else {
                response.setElementList(handler.getAttachedLikes(userId, elementGUID, startFrom, pageSize, new Date()));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getAttachedLikes", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse addCommentToElement(String serverName, String elementGUID, boolean isPublic, String viewServiceURLMarker, String accessServiceURLMarker, ReferenceableUpdateRequestBody requestBody) {
        String methodName = "addCommentToElement";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "addCommentToElement");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "addCommentToElement");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addCommentToElement");
            CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "addCommentToElement");
            if (requestBody != null) {
                ReferenceableProperties referenceableProperties = requestBody.getElementProperties();
                if (referenceableProperties instanceof CommentProperties) {
                    CommentProperties commentProperties = (CommentProperties)referenceableProperties;
                    response.setGUID(handler.addCommentToElement(userId, elementGUID, isPublic, commentProperties));
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(CommentProperties.class.getName(), "addCommentToElement");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "addCommentToElement", serverName, ReferenceableUpdateRequestBody.class.getName());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addCommentToElement", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse addCommentReply(String serverName, String elementGUID, String commentGUID, boolean isPublic, String viewServiceURLMarker, String accessServiceURLMarker, ReferenceableUpdateRequestBody requestBody) {
        String methodName = "addCommentReply";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "addCommentReply");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "addCommentReply");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addCommentReply");
            if (requestBody != null) {
                ReferenceableProperties referenceableProperties = requestBody.getElementProperties();
                if (referenceableProperties instanceof CommentProperties) {
                    CommentProperties commentProperties = (CommentProperties)referenceableProperties;
                    CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "addCommentReply");
                    response.setGUID(handler.addCommentReply(userId, elementGUID, commentGUID, isPublic, commentProperties));
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(CommentProperties.class.getName(), "addCommentReply");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "addCommentReply", serverName, ReferenceableUpdateRequestBody.class.getName());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addCommentReply", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateComment(String serverName, String commentGUID, boolean isMergeUpdate, String viewServiceURLMarker, String accessServiceURLMarker, ReferenceableUpdateRequestBody requestBody) {
        String methodName = "updateComment";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "updateComment");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "updateComment");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateComment");
            if (requestBody != null) {
                ReferenceableProperties referenceableProperties = requestBody.getElementProperties();
                if (referenceableProperties instanceof CommentProperties) {
                    CommentProperties commentProperties = (CommentProperties)referenceableProperties;
                    CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "updateComment");
                    handler.updateComment(userId, commentGUID, isMergeUpdate, commentProperties, requestBody.getEffectiveTime());
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(CommentProperties.class.getName(), "updateComment");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateComment", serverName, ReferenceableUpdateRequestBody.class.getName());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateComment", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateCommentVisibility(String serverName, String parentGUID, String commentGUID, boolean isPublic, String viewServiceURLMarker, String accessServiceURLMarker, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "updateCommentVisibility";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "updateCommentVisibility");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "updateCommentVisibility");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateCommentVisibility");
            CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "updateCommentVisibility");
            if (requestBody != null) {
                handler.updateCommentVisibility(userId, parentGUID, commentGUID, isPublic, requestBody.getEffectiveTime());
            } else {
                handler.updateCommentVisibility(userId, parentGUID, commentGUID, isPublic, new Date());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateCommentVisibility", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupAcceptedAnswer(String serverName, String questionCommentGUID, String answerCommentGUID, boolean isPublic, String viewServiceURLMarker, String accessServiceURLMarker, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "setupAcceptedAnswer";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "setupAcceptedAnswer");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "setupAcceptedAnswer");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupAcceptedAnswer");
            CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "setupAcceptedAnswer");
            if (requestBody != null) {
                handler.setupAcceptedAnswer(userId, questionCommentGUID, answerCommentGUID, isPublic, requestBody.getEffectiveTime());
            } else {
                handler.setupAcceptedAnswer(userId, questionCommentGUID, answerCommentGUID, isPublic, new Date());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupAcceptedAnswer", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearAcceptedAnswer(String serverName, String questionCommentGUID, String answerCommentGUID, String viewServiceURLMarker, String accessServiceURLMarker, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "clearAcceptedAnswer";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "clearAcceptedAnswer");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "clearAcceptedAnswer");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearAcceptedAnswer");
            CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "clearAcceptedAnswer");
            if (requestBody != null) {
                handler.clearAcceptedAnswer(userId, questionCommentGUID, answerCommentGUID, requestBody.getEffectiveTime());
            } else {
                handler.clearAcceptedAnswer(userId, questionCommentGUID, answerCommentGUID, new Date());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearAcceptedAnswer", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeCommentFromElement(String serverName, String commentGUID, String viewServiceURLMarker, String accessServiceURLMarker, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "removeElementComment";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "removeElementComment");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "removeElementComment");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeElementComment");
            CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "removeElementComment");
            if (requestBody != null) {
                handler.removeComment(userId, commentGUID, requestBody.getEffectiveTime());
            } else {
                handler.removeComment(userId, commentGUID, new Date());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeElementComment", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public CommentResponse getCommentByGUID(String serverName, String commentGUID, String viewServiceURLMarker, String accessServiceURLMarker, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getComment";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getComment");
        CommentResponse response = new CommentResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getComment");
            restCallLogger.setUserId(token, userId);
            CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "getComment");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getComment");
            if (requestBody != null) {
                response.setElement(handler.getComment(userId, commentGUID, requestBody.getEffectiveTime()));
            } else {
                response.setElement(handler.getComment(userId, commentGUID, new Date()));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getComment", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public CommentElementsResponse getAttachedComments(String serverName, String elementGUID, int startFrom, int pageSize, String viewServiceURLMarker, String accessServiceURLMarker, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getAttachedComments";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getAttachedComments");
        CommentElementsResponse response = new CommentElementsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getAttachedComments");
            restCallLogger.setUserId(token, userId);
            CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "getAttachedComments");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAttachedComments");
            if (requestBody != null) {
                response.setElementList(handler.getAttachedComments(userId, elementGUID, startFrom, pageSize, requestBody.getEffectiveTime()));
            } else {
                response.setElementList(handler.getAttachedComments(userId, elementGUID, startFrom, pageSize, new Date()));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getAttachedComments", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public CommentElementsResponse findComments(String serverName, int startFrom, int pageSize, boolean startsWith, boolean endsWith, boolean ignoreCase, String viewServiceURLMarker, String accessServiceURLMarker, FilterRequestBody requestBody) {
        String methodName = "findComments";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "findComments");
        CommentElementsResponse response = new CommentElementsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "findComments");
            restCallLogger.setUserId(token, userId);
            CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "findComments");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findComments");
            if (requestBody != null) {
                response.setElementList(handler.findComments(userId, instanceHandler.getSearchString(requestBody.getFilter(), startsWith, endsWith, ignoreCase), startFrom, pageSize, requestBody.getEffectiveTime()));
            } else {
                response.setElementList(handler.findComments(userId, instanceHandler.getSearchString(null, startsWith, endsWith, ignoreCase), startFrom, pageSize, new Date()));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findComments", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createInformalTag(String serverName, String viewServiceURLMarker, String accessServiceURLMarker, TagProperties requestBody) {
        String methodName = "createTag";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "createTag");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "createTag");
            restCallLogger.setUserId(token, userId);
            if (requestBody != null) {
                CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "createTag");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "createTag");
                response.setGUID(handler.createInformalTag(userId, requestBody));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createTag", serverName, TagProperties.class.getName());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createTag", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateTagDescription(String serverName, String tagGUID, String viewServiceURLMarker, String accessServiceURLMarker, InformalTagUpdateRequestBody requestBody) {
        String methodName = "updateTagDescription";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "updateTagDescription");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "updateTagDescription");
            restCallLogger.setUserId(token, userId);
            if (requestBody != null) {
                CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "updateTagDescription");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "updateTagDescription");
                handler.updateTagDescription(userId, tagGUID, requestBody.getDescription(), requestBody.getEffectiveTime());
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateTagDescription", serverName, InformalTagUpdateRequestBody.class.getName());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateTagDescription", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteTag(String serverName, String tagGUID, String viewServiceURLMarker, String accessServiceURLMarker, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "deleteTag";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "deleteTag");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "deleteTag");
            restCallLogger.setUserId(token, userId);
            CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "deleteTag");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteTag");
            if (requestBody != null) {
                handler.deleteTag(userId, tagGUID, requestBody.getEffectiveTime());
            } else {
                handler.deleteTag(userId, tagGUID, new Date());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "deleteTag", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public InformalTagResponse getTag(String serverName, String guid, String viewServiceURLMarker, String accessServiceURLMarker, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getTag";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getTag");
        InformalTagResponse response = new InformalTagResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getTag");
            restCallLogger.setUserId(token, userId);
            CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "getTag");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getTag");
            if (requestBody != null) {
                response.setTag(handler.getTag(userId, guid, requestBody.getEffectiveTime()));
            } else {
                response.setTag(handler.getTag(userId, guid, new Date()));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getTag", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public InformalTagsResponse getTagsByName(String serverName, int startFrom, int pageSize, String viewServiceURLMarker, String accessServiceURLMarker, FilterRequestBody requestBody) {
        String methodName = "getTagsByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getTagsByName");
        InformalTagsResponse response = new InformalTagsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getTagsByName");
            restCallLogger.setUserId(token, userId);
            CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "getTagsByName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getTagsByName");
            if (requestBody != null) {
                response.setTags(handler.getTagsByName(userId, requestBody.getFilter(), startFrom, pageSize, requestBody.getEffectiveTime()));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "getTagsByName", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getTagsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public InformalTagsResponse findTags(String serverName, int startFrom, int pageSize, boolean startsWith, boolean endsWith, boolean ignoreCase, String viewServiceURLMarker, String accessServiceURLMarker, FilterRequestBody requestBody) {
        String methodName = "findTags";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "findTags");
        InformalTagsResponse response = new InformalTagsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "findTags");
            restCallLogger.setUserId(token, userId);
            CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "findTags");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findTags");
            if (requestBody != null) {
                response.setTags(handler.findTags(userId, instanceHandler.getSearchString(requestBody.getFilter(), startsWith, endsWith, ignoreCase), startFrom, pageSize, requestBody.getEffectiveTime()));
            } else {
                response.setTags(handler.findTags(userId, instanceHandler.getSearchString(null, startsWith, endsWith, ignoreCase), startFrom, pageSize, new Date()));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findTags", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public InformalTagsResponse findMyTags(String serverName, int startFrom, int pageSize, boolean startsWith, boolean endsWith, boolean ignoreCase, String viewServiceURLMarker, String accessServiceURLMarker, FilterRequestBody requestBody) {
        String methodName = "findMyTags";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "findMyTags");
        InformalTagsResponse response = new InformalTagsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "findMyTags");
            restCallLogger.setUserId(token, userId);
            CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "findMyTags");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findMyTags");
            if (requestBody != null) {
                response.setTags(handler.findMyTags(userId, instanceHandler.getSearchString(requestBody.getFilter(), startsWith, endsWith, ignoreCase), startFrom, pageSize, requestBody.getEffectiveTime()));
            } else {
                response.setTags(handler.findMyTags(userId, instanceHandler.getSearchString(null, startsWith, endsWith, ignoreCase), startFrom, pageSize, new Date()));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findMyTags", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addTagToElement(String serverName, String elementGUID, String tagGUID, boolean isPublic, String viewServiceURLMarker, String accessServiceURLMarker, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "addTagToElement";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "addTagToElement");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "addTagToElement");
            restCallLogger.setUserId(token, userId);
            CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "addTagToElement");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addTagToElement");
            if (requestBody != null) {
                handler.addTagToElement(userId, elementGUID, tagGUID, isPublic, requestBody.getEffectiveTime());
            } else {
                handler.addTagToElement(userId, elementGUID, tagGUID, isPublic, new Date());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addTagToElement", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeTagFromElement(String serverName, String elementGUID, String tagGUID, String viewServiceURLMarker, String accessServiceURLMarker, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "removeTagFromElement";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "removeTagFromElement");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "removeTagFromElement");
            restCallLogger.setUserId(token, userId);
            CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "removeTagFromElement");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeTagFromElement");
            if (requestBody != null) {
                handler.removeTagFromElement(userId, elementGUID, tagGUID, requestBody.getEffectiveTime());
            } else {
                handler.removeTagFromElement(userId, elementGUID, tagGUID, new Date());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeTagFromElement", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementsResponse getElementsByTag(String serverName, String tagGUID, int startFrom, int pageSize, String viewServiceURLMarker, String accessServiceURLMarker, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getElementsByTag";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getElementsByTag");
        RelatedElementsResponse response = new RelatedElementsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getElementsByTag");
            restCallLogger.setUserId(token, userId);
            CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "getElementsByTag");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getElementsByTag");
            if (requestBody != null) {
                response.setElementList(handler.getElementsByTag(userId, tagGUID, startFrom, pageSize, requestBody.getEffectiveTime()));
            } else {
                response.setElementList(handler.getElementsByTag(userId, tagGUID, startFrom, pageSize, new Date()));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getElementsByTag", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public InformalTagsResponse getAttachedTags(String serverName, String elementGUID, int startFrom, int pageSize, String viewServiceURLMarker, String accessServiceURLMarker, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getAttachedTags";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getAttachedTags");
        InformalTagsResponse response = new InformalTagsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getAttachedTags");
            restCallLogger.setUserId(token, userId);
            CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "getAttachedTags");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAttachedTags");
            if (requestBody != null) {
                response.setTags(handler.getAttachedTags(userId, elementGUID, startFrom, pageSize, requestBody.getEffectiveTime()));
            } else {
                response.setTags(handler.getAttachedTags(userId, elementGUID, startFrom, pageSize, new Date()));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getAttachedTags", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createNoteLog(String serverName, String elementGUID, boolean isPublic, String viewServiceURLMarker, String accessServiceURLMarker, NoteLogProperties requestBody) {
        String methodName = "createNoteLog";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "createNoteLog");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "createNoteLog");
            restCallLogger.setUserId(token, userId);
            if (requestBody != null) {
                CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "createNoteLog");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "createNoteLog");
                response.setGUID(handler.createNoteLog(userId, elementGUID, requestBody, isPublic));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createNoteLog", serverName, NoteLogProperties.class.getName());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createNoteLog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateNoteLog(String serverName, String noteLogGUID, boolean isMergeUpdate, String viewServiceURLMarker, String accessServiceURLMarker, ReferenceableUpdateRequestBody requestBody) {
        String methodName = "updateNoteLog";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "updateNoteLog");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "updateNoteLog");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateNoteLog");
            if (requestBody != null) {
                ReferenceableProperties referenceableProperties = requestBody.getElementProperties();
                if (referenceableProperties instanceof NoteLogProperties) {
                    NoteLogProperties noteLogProperties = (NoteLogProperties)referenceableProperties;
                    CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "updateNoteLog");
                    handler.updateNoteLog(userId, noteLogGUID, isMergeUpdate, noteLogProperties, requestBody.getEffectiveTime());
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(NoteLogProperties.class.getName(), "updateNoteLog");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateNoteLog", serverName, ReferenceableUpdateRequestBody.class.getName());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateNoteLog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteNoteLog(String serverName, String noteLogGUID, String viewServiceURLMarker, String accessServiceURLMarker, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "deleteNoteLog";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "deleteNoteLog");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "deleteNoteLog");
            restCallLogger.setUserId(token, userId);
            CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "deleteNoteLog");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteNoteLog");
            if (requestBody != null) {
                handler.removeNoteLog(userId, noteLogGUID, requestBody.getEffectiveTime());
            } else {
                handler.removeNoteLog(userId, noteLogGUID, new Date());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "deleteNoteLog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public NoteLogsResponse findNoteLogs(String serverName, int startFrom, int pageSize, boolean startsWith, boolean endsWith, boolean ignoreCase, String viewServiceURLMarker, String accessServiceURLMarker, FilterRequestBody requestBody) {
        String methodName = "findNoteLogs";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "findNoteLogs");
        NoteLogsResponse response = new NoteLogsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "findNoteLogs");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findNoteLogs");
            CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "findNoteLogs");
            if (requestBody != null) {
                response.setElementList(handler.findNoteLogs(userId, instanceHandler.getSearchString(requestBody.getFilter(), startsWith, endsWith, ignoreCase), startFrom, pageSize, requestBody.getEffectiveTime()));
            } else {
                response.setElementList(handler.findNoteLogs(userId, instanceHandler.getSearchString(null, startsWith, endsWith, ignoreCase), startFrom, pageSize, new Date()));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findNoteLogs", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public NoteLogsResponse getNoteLogsByName(String serverName, int startFrom, int pageSize, String viewServiceURLMarker, String accessServiceURLMarker, FilterRequestBody requestBody) {
        String methodName = "getNoteLogsByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getNoteLogsByName");
        NoteLogsResponse response = new NoteLogsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getNoteLogsByName");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getNoteLogsByName");
            CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "getNoteLogsByName");
            if (requestBody != null) {
                response.setElementList(handler.getNoteLogsByName(userId, requestBody.getFilter(), startFrom, pageSize, requestBody.getEffectiveTime()));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "getNoteLogsByName", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getNoteLogsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public NoteLogsResponse getNoteLogsForElement(String serverName, String elementGUID, int startFrom, int pageSize, String viewServiceURLMarker, String accessServiceURLMarker, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getNotesForNoteLog";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getNotesForNoteLog");
        NoteLogsResponse response = new NoteLogsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getNotesForNoteLog");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getNotesForNoteLog");
            CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "getNotesForNoteLog");
            if (requestBody != null) {
                response.setElementList(handler.getNoteLogsForElement(userId, elementGUID, startFrom, pageSize, requestBody.getEffectiveTime()));
            } else {
                response.setElementList(handler.getNoteLogsForElement(userId, elementGUID, startFrom, pageSize, new Date()));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getNotesForNoteLog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public NoteLogResponse getNoteLogByGUID(String serverName, String noteLogGUID, String viewServiceURLMarker, String accessServiceURLMarker, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getNoteLogByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getNoteLogByGUID");
        NoteLogResponse response = new NoteLogResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getNoteLogByGUID");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getNoteLogByGUID");
            CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "getNoteLogByGUID");
            if (requestBody != null) {
                response.setElement(handler.getNoteLogByGUID(userId, noteLogGUID, requestBody.getEffectiveTime()));
            } else {
                response.setElement(handler.getNoteLogByGUID(userId, noteLogGUID, new Date()));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getNoteLogByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createNote(String serverName, String noteLogGUID, String viewServiceURLMarker, String accessServiceURLMarker, NoteProperties requestBody) {
        String methodName = "createNote";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "createNote");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "createNote");
            restCallLogger.setUserId(token, userId);
            if (requestBody != null) {
                CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "createNote");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "createNote");
                response.setGUID(handler.createNote(userId, noteLogGUID, requestBody));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createNote", serverName, NoteLogProperties.class.getName());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createNote", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateNote(String serverName, String noteGUID, boolean isMergeUpdate, String viewServiceURLMarker, String accessServiceURLMarker, ReferenceableUpdateRequestBody requestBody) {
        String methodName = "updateNote";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "updateNote");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "updateNote");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateNote");
            if (requestBody != null) {
                ReferenceableProperties referenceableProperties = requestBody.getElementProperties();
                if (referenceableProperties instanceof NoteProperties) {
                    NoteProperties noteProperties = (NoteProperties)referenceableProperties;
                    CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "updateNote");
                    handler.updateNote(userId, noteGUID, isMergeUpdate, noteProperties, requestBody.getEffectiveTime());
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(NoteProperties.class.getName(), "updateNote");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateNote", serverName, ReferenceableUpdateRequestBody.class.getName());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateNote", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteNote(String serverName, String noteGUID, String viewServiceURLMarker, String accessServiceURLMarker, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "deleteNote";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "deleteNote");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "deleteNote");
            restCallLogger.setUserId(token, userId);
            CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "deleteNote");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteNote");
            if (requestBody != null) {
                handler.removeNote(userId, noteGUID, requestBody.getEffectiveTime());
            } else {
                handler.removeNote(userId, noteGUID, new Date());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "deleteNote", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public NotesResponse findNotes(String serverName, int startFrom, int pageSize, boolean startsWith, boolean endsWith, boolean ignoreCase, String viewServiceURLMarker, String accessServiceURLMarker, FilterRequestBody requestBody) {
        String methodName = "findNotes";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "findNotes");
        NotesResponse response = new NotesResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "findNotes");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findNotes");
            CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "findNotes");
            if (requestBody != null) {
                response.setElementList(handler.findNotes(userId, instanceHandler.getSearchString(requestBody.getFilter(), startsWith, endsWith, ignoreCase), startFrom, pageSize, requestBody.getEffectiveTime()));
            } else {
                response.setElementList(handler.findNotes(userId, instanceHandler.getSearchString(null, startsWith, endsWith, ignoreCase), startFrom, pageSize, new Date()));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findNotes", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public NotesResponse getNotesForNoteLog(String serverName, String noteLogGUID, int startFrom, int pageSize, String viewServiceURLMarker, String accessServiceURLMarker, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getNotesForNoteLog";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getNotesForNoteLog");
        NotesResponse response = new NotesResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getNotesForNoteLog");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getNotesForNoteLog");
            CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "getNotesForNoteLog");
            if (requestBody != null) {
                response.setElementList(handler.getNotesForNoteLog(userId, noteLogGUID, startFrom, pageSize, requestBody.getEffectiveTime()));
            } else {
                response.setElementList(handler.getNotesForNoteLog(userId, noteLogGUID, startFrom, pageSize, new Date()));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getNotesForNoteLog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public NoteResponse getNoteByGUID(String serverName, String noteGUID, String viewServiceURLMarker, String accessServiceURLMarker, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getNoteByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getNoteByGUID");
        NoteResponse response = new NoteResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getNoteByGUID");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getNoteByGUID");
            CollaborationManagerHandler handler = instanceHandler.getCollaborationManagerHandler(userId, serverName, viewServiceURLMarker, accessServiceURLMarker, "getNoteByGUID");
            if (requestBody != null) {
                response.setElement(handler.getNoteByGUID(userId, noteGUID, requestBody.getEffectiveTime()));
            } else {
                response.setElement(handler.getNoteByGUID(userId, noteGUID, new Date()));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getNoteByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

