/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.feedbackmanager.admin;

import java.util.List;
import org.odpi.openmetadata.adminservices.configuration.properties.ViewServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.ViewServiceDescription;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.registration.ViewServerGenericServiceAdmin;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.viewservices.feedbackmanager.ffdc.FeedbackManagerAuditCode;
import org.odpi.openmetadata.viewservices.feedbackmanager.server.FeedbackManagerInstance;

public class FeedbackManagerAdmin
extends ViewServerGenericServiceAdmin {
    private AuditLog auditLog = null;
    private FeedbackManagerInstance instance = null;
    private String serverName = null;

    public void initialize(String serverName, ViewServiceConfig viewServiceConfig, AuditLog auditLog, String serverUserName, int maxPageSize, List<ViewServiceConfig> activeViewServices) throws OMAGConfigurationErrorException {
        String actionDescription = "initialize";
        auditLog.logMessage("initialize", FeedbackManagerAuditCode.SERVICE_INITIALIZING.getMessageDefinition());
        this.auditLog = auditLog;
        this.serverName = serverName;
        try {
            this.instance = new FeedbackManagerInstance(serverName, auditLog, serverUserName, maxPageSize, viewServiceConfig.getOMAGServerName(), viewServiceConfig.getOMAGServerPlatformRootURL(), activeViewServices);
            auditLog.logMessage("initialize", FeedbackManagerAuditCode.SERVICE_INITIALIZED.getMessageDefinition(), viewServiceConfig.toString());
        }
        catch (Exception error) {
            auditLog.logException("initialize", FeedbackManagerAuditCode.SERVICE_INSTANCE_FAILURE.getMessageDefinition(error.getMessage()), viewServiceConfig.toString(), (Throwable)error);
            super.throwUnexpectedInitializationException("initialize", ViewServiceDescription.FEEDBACK_MANAGER.getViewServiceFullName(), (Throwable)error);
        }
    }

    public void shutdown() {
        String actionDescription = "shutdown";
        this.auditLog.logMessage("shutdown", FeedbackManagerAuditCode.SERVICE_TERMINATING.getMessageDefinition(this.serverName));
        if (this.instance != null) {
            this.instance.shutdown();
        }
        this.auditLog.logMessage("shutdown", FeedbackManagerAuditCode.SERVICE_SHUTDOWN.getMessageDefinition(this.serverName));
    }
}

